/* macreadwriteres.c */

#include "../defs.h"
#include "../errors.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "../btree/btree.h"
#include "../LibFuncs/catalog.h"
#include "../DevSupport/readwrite.h"
#include "../Volume/volbmap.h"
#include "macreadwriteres_local.h"
#include "macreadwriteres.h"
#include <stdlib.h>
#ifdef DEBUG
#include <stdio.h>
#endif

int mread_res(MOUNT_RECORD *mr,
	      CATALOG_RECORD *cr, 
	      LONGWORD start, 
	      LONGWORD numbytes,
	      BYTE *buf,
	      LONGWORD *bytesactuallyread)
{
  LONGWORD startblock, endblock, numblocks, partialblock, partlen, actual;
  LONGWORD byteshandled;
  int rc;
  BYTE *localbuf, *bufptr;

  if (start+1>(cr->U.cdrFilRec.filRLgLen)) {
    *bytesactuallyread=0;
    return 0;
  }

  if ((start+numbytes-1)>(cr->U.cdrFilRec.filRLgLen-1))
    numbytes=cr->U.cdrFilRec.filRLgLen-start;

  if ((localbuf=(BYTE *)malloc(mr->vib.AlBlkSiz))==NULL)
    return MACWRITEOUTOFMEM;

  byteshandled=0;

  startblock=start/mr->vib.AlBlkSiz;

  endblock=(start+numbytes-1)/mr->vib.AlBlkSiz;

  numblocks=endblock-startblock+1;

  partialblock=start%mr->vib.AlBlkSiz;

  bufptr=buf;


  /* Is the first block a partial block? */
  if (partialblock) {
    if ((rc=macreadblocks_res(mr, cr, startblock, 1, localbuf, &actual))) {
      free(localbuf);
      return rc;
    }

    if (actual!=1) {
      free(localbuf);
      return MACWRITECANTREAD;
    }

    partlen=mr->vib.AlBlkSiz-partialblock;

    if (partlen>numbytes)
      partlen=numbytes;


    memcpy(bufptr,&(localbuf[partialblock]),partlen);

    ++startblock; --numblocks;
    byteshandled+=partlen;
    bufptr+=partlen;
  }

  if (numblocks==0) {
    *bytesactuallyread=byteshandled;
    free(localbuf);
    return 0;
  }

  /* If any middle blocks, handle them */
  if (numblocks>1) {
    if ((rc=macreadblocks_res(mr, cr, startblock, numblocks-1, bufptr, &actual))){
      free(localbuf);
      return rc;
    }
    if (actual!=(numblocks-1)) {
      free(localbuf);
      return MACREADCANTREAD;
    }
    
    startblock+=actual;
    byteshandled+=mr->vib.AlBlkSiz*actual;
    numblocks-=actual;
    bufptr+=mr->vib.AlBlkSiz*actual;
  }

  partialblock=(numbytes-byteshandled);

/* If last block is a partial block handle it specially */
  if (!partialblock) {
    if ((rc=macreadblocks_res(mr,cr,startblock,1,bufptr,&actual))) {
      free(localbuf);
      return rc;
    }
    
    if (actual!=1) {
      free(localbuf);
      return MACREADCANTREAD;
    }

    byteshandled+=mr->vib.AlBlkSiz;

  } else {
    if ((rc=macreadblocks_res(mr, cr, startblock, 1, localbuf, &actual))) {
      free(localbuf);
      return rc;
    }
    if (actual!=1) {
      free(localbuf);
      return MACREADCANTREAD;
    }
    
    memcpy(bufptr, localbuf, partialblock);
    
    byteshandled+=partialblock;
  }

  free(localbuf);

  *bytesactuallyread=byteshandled;

  return 0;
}
			  
int macreadblocks_res(MOUNT_RECORD *mr,
		      CATALOG_RECORD *cr,
		      LONGWORD start,
		      LONGWORD numblocks,
		      BYTE *buf,
		      LONGWORD *blocksactuallyread)
{
  ED *edlist;
  WORD startblock, length;
  LONGWORD startsect, numsects, nextbufoffset, blocksread;
  int numeds, cured;

  blocksread=0;

  if ((numeds=generateedlist_res(mr,
				 cr,
				 start,
				 numblocks,
				 &edlist))<0) {
    return numeds;
  }

  nextbufoffset=0;

  cured=0;

  while (cured<numeds) {
    startblock=edlist[cured].start;
    length=edlist[cured].length;
    
    startsect=mr->vib.AlBlSt+(mr->vib.AlBlkSiz/mr->sr.sectsize)*startblock;


/*    startsect=(mr->vib.VBMSt+mr->vib.NmAlBlks/8/mr->sr.sectsize)+

 That's the starting sector of the allocation area of the disk 
	     startblock*(mr->vib.AlBlkSiz/mr->sr.sectsize)+1;
 That's the sector desired 
*/

    numsects=length*(mr->vib.AlBlkSiz/mr->sr.sectsize);

    if (readsects(mr,startsect,numsects,
		  (char *) &(buf[nextbufoffset]))!=numsects) {
      free(edlist);
      return CANTREADALLOCBLOCK;
    }

    nextbufoffset+=numsects*mr->sr.sectsize;

    blocksread+=length;

    if (blocksread>numblocks) {
      free(edlist);
      return MACREADOUTOFBOUNDS;
    }

    ++cured;
  }

  free(edlist);

  *blocksactuallyread=blocksread;

  return 0;
}

int generateedlist_res(MOUNT_RECORD *mr,
		       CATALOG_RECORD *cr,
		       LONGWORD sb,
		       LONGWORD sl,
		       ED **edlist)
{
  WORD i, allocblockstart, allocblocklen, cured;
  int founddf; 
  EXTENT_RECORD er;
  ED *el, *tmp;
  int rc;
  LONGWORD foundid;
  WORD fb;
  LONGWORD osl;

  

  if ((cr->U.cdrFilRec.filRPyLen==0)
      ||(sb>(cr->U.cdrFilRec.filRPyLen/mr->vib.AlBlkSiz)))
    return 0;

  cured=0;

  if ((el=(ED*)malloc(sizeof(ED)*EDALLOCUNITS))==NULL)
    return GENEDLISTOUTOFMEM;

  osl=sl; /* Used to check against rollover */

/* First check the ExtRec in the Catalog Structure */

  memcpy(er,cr->U.cdrFilRec.filRExtRec,sizeof(EXTENT_RECORD));

  fb=0;

  do {
    i=0;

    
/* Check out Extent Descriptor */

    while (sl!=0 && i<3) {

/* See if this block contains part of what we're interested in... */

      if ((fb+er[i].length-1)>=sb) {

/* If so, add an extent descriptor to the edlist */

	allocblockstart=er[i].first+(sb-fb);
	allocblocklen=er[i].first+(er[i].length-allocblockstart);
	if (allocblocklen>sl) 
	  allocblocklen=sl;

	if (!(cured%EDALLOCUNITS)&&(cured!=0)) {
	  if ((tmp=(ED *)realloc(el, (cured+EDALLOCUNITS)*sizeof(ED)))==NULL) {
	    free(el);
	    return GENEDLISTOUTOFMEM;
	  } else {
	    el=tmp;
	  }
	}

	el[cured].start=allocblockstart;
	el[cured].length=allocblocklen;
	++cured;

/* Update found block and search block to reflect the next ed */

	fb=fb+er[i].length;
	sb=sb+allocblocklen;
	sl-=allocblocklen;

/* if search length (sl) wrapped around, something very strange happened... */
	
	if (sl>osl) {
	  free(el);
	  return GENEDLISTINTERNALERR;
	}

      } else {

/* If not on current extend descripter, increment fb and go to the next on */
	fb=fb+er[i].length;
      }
      ++i;
    }

/* if we ran of end of er but still have some sl left, get a new er */

    
    if (sl!=0) {
      rc=GetExtentRecord(mr, 
			 cr->U.cdrFilRec.filFlNum,
			 0,
			 sb,
			 er,
			 &foundid,
			 &founddf,
			 &fb);
      if (foundid!=cr->U.cdrFilRec.filFlNum) {
	free(el);
#ifdef DEBUG
	printf("Bad Return from GetExtentRecord - expect fid=%d, got"
	       " %d, expected df=%d, got df=%d\n", cr->U.cdrFilRec.filFlNum,
	       foundid, 0, founddf);
#endif
	return GENEDLISTBLOCKNOTFOUND;
      }
    }
  } while (sl!=0);
   
  *edlist=el;

  return cured;
}
		       


