/* log.c
   Logging facility
*/

#define INCL_DOSERRORS
#define INCL_NOCOMMON
#define INCL_NOPMAPI
#define _Seg16
#define _Far16
#define _System
#include <os2.h>
#include "os216.h"

#include <string.h>
#include <stdarg.h>
#include <dos.h>
#include <ctype.h>

#include "fsd.h"
#include "r0devhlp.h"
#include "..\r0r3shar.h"
#include "r0struct.h"
#include "fsh.h"
#include "r0global.h"
#include "r0comm.h"
#include "log.h"
#include "vsprintf.h"

static int log_text(const unsigned char *text);

/* The log buffer is a circular queue */
char logbuf[LOGBUF_SIZE];
unsigned short logbuf_head, logbuf_tail;

/* A semaphore which is cleared when data is present. FS_FSCTL waits on this
   semaphore when returning data. */
unsigned long logbuf_sem;

/******************************************************************************
**
** log_text - put text in the log buffer
**
******************************************************************************/

static int log_text(const unsigned char *text)
{
  int rc, i;

  for( i=0; i<strlen(text); i++ ) {
    logbuf[logbuf_tail++] = text[i];
    if( logbuf_tail==LOGBUF_SIZE )
      logbuf_tail=0;
  }

  /* Clear the log semaphore */
  if ((rc = FSH_SEMCLEAR(&logbuf_sem)) != NO_ERROR)
    return rc;

  return NO_ERROR;
}

/******************************************************************************
**
** printk - formatted logging
**
******************************************************************************/

int printk(const unsigned char *fmt, ...) 
{
  va_list arg;
  char Buf[256];

  va_start(arg, fmt);
  vsprintf(Buf, fmt, arg);
  va_end(arg);

  return log_text(Buf);
}

/******************************************************************************
**
** dump - debug style hex dump
**
******************************************************************************/

#define DUMP_WIDTH 16

void dump(const unsigned char *text, unsigned length)
{
  unsigned i=0;
  while( i<length ) {
    unsigned j;

    printk("%04X ", i);

    for( j=0; j<DUMP_WIDTH; j++ )
      if( i+j < length )
        printk("%02X ", (unsigned)text[i+j]);
      else
        printk("   ");
    printk("   ");
    for( j=0; j<DUMP_WIDTH; j++ )
      if( i+j < length ) {
        if( isprint(text[i+j]) )
          printk("%c", (unsigned)text[i+j]);
        else
          printk(".");
      }
    printk("\n");
    i += DUMP_WIDTH;
  }
}
