#define INCL_DOSERRORS
#define INCL_DOSDEVIOCTL
#define INCL_NOPMAPI
#include <os2.h>
#include <fsh.h>

#include <os2/types.h>
#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <os2/os2proto.h>
#include <os2/files.h>
#include <os2/minifsd.h>
#include <os2/volume.h>

BIOSPARAMETERBLOCK far *bootbpb;

extern struct super_block  stage1_superblk;

extern long nr_files;
extern long nr_free_files;
extern long nr_used_files;
extern struct file *free_files;
extern struct file *used_files;

extern struct inode * first_inode;
extern long nr_inodes;
extern long nr_free_inodes;

struct inode_hash_entry {
        struct inode * inode;
        int updating;
};
extern struct inode_hash_entry hash_table[];
extern struct inode stage1_inode[];

extern volume_global_data volglobdat;

struct minifsd_to_fsd_data  mfs_data = {
    MINIFSD_DATA_MAGIC, 
    &used_files,
    &free_files,
    &nr_files,
    &nr_free_files,
    &nr_used_files,
    &first_inode,
    &nr_inodes,
    &nr_free_inodes,
    hash_table,
    0,
    stage1_inode,
    &volglobdat
};

int far pascal _loadds MFS_CHGFILEPTR(
    unsigned long  offset,		/* offset	*/
    unsigned short type		        /* type		*/
) {

//    printk("**** MFS_CHGFILEPTR(ofs=%ld type=%d)", offset, type);

    if (!used_files)
        ext2_os2_panic(0, "MFS_CHGFILEPTR : used_files = 0");
    if (used_files->f_magic != FILE_MAGIC)
        ext2_os2_panic(0, "MFS_CHGFILEPTR : invalid magic number");

    switch(type) {
        case 0 :
            used_files->f_pos = offset;
            break;

        case 1 :
            used_files->f_pos = used_files->f_pos + offset;
            break;

        case 2 :
            used_files->f_pos = used_files->f_inode->i_size + offset;
            break;

        default :
            ext2_os2_panic(0, "MFS_CHFILEPTR : unknown type %d", type);
    }

    return NO_ERROR;
}

int far pascal _loadds MFS_CLOSE(void) {

    printk("**** MFS_CLOSE");

    if (!used_files)
        ext2_os2_panic(0, "MFS_CLOSE : flist = 0");
    if (used_files->f_magic != FILE_MAGIC)
        ext2_os2_panic(0, "MFS_CLOSE : invalid magic number");

    vfs_close(used_files);


    return NO_ERROR;
}

struct bootdata {
    magic_t bootdata_magic;
    USHORT  bootdrive;
};

int far pascal _loadds MFS_INIT(
    void far *bootdata,			/* bootdata	*/
    char far *number,			/* number io	*/
    long far *vectorripl,		/* vectorripl	*/
    void far *bpb,			/* bpb		*/
    unsigned long far *pMiniFSD,	/* pMiniFSD	*/
    unsigned long far *dump		/* dump address */
) {
    struct bootdata *boot;

    printk("**** MFS_INIT");
    bootbpb     = (BIOSPARAMETERBLOCK far *)bpb;
#if 0
    boot = (struct bootdata *)bootdata;

    if (!boot) 
	ext2_os2_panic(0, "MFS_INIT - can't retrieve  boot data from micro FSD");
    if (boot->bootdata_magic != BOOTDATA_MAGIC)
	ext2_os2_panic(0, "MFS_INIT - boot data with invalid magic number (%0X)", boot->bootdata_magic);

    MFSH_SETBOOTDRIVE(boot->bootdrive);
#else
    if (bootbpb->usReservedSectors != BOOTDATA_MAGIC)
	ext2_os2_panic(0, "MFS_INIT - boot data with invalid magic number (%0X)", bootbpb->usReservedSectors);

    MFSH_SETBOOTDRIVE(bootbpb->usSectorsPerFAT);
    bootbpb->usSectorsPerFAT   = 0;
    bootbpb->usReservedSectors = 0;
#endif
    *number     = 0;				// N/A here : local FSD
    *vectorripl = 0;				// no ripl data
    *dump       = 0;				// no alternate dump routine
    *pMiniFSD   = (unsigned long)(&mfs_data);	// data to pass to normal FSD

    stage1_superblk.sector_size       = (UINT32)bootbpb->usBytesPerSector;
    stage1_superblk.nb_sectors        = (UINT32)bootbpb->cLargeSectors;
    stage1_superblk.drive             = 0;

    stage1_superblk.block_size        = BLOCK_SIZE;
    stage1_superblk.s_blocksize       = stage1_superblk.block_size;
    stage1_superblk.sectors_per_block = stage1_superblk.block_size / stage1_superblk.sector_size;
    stage1_superblk.s_dev             = 0;
//    stage1_superblk.s_op              = &ext2_sops;
    stage1_superblk.s_flags           = MS_RDONLY;          // MINIFSD is ALWAYS readonly

        
    inode_init();
    buffer_init();

    stage1_ext2_read_super();


    return NO_ERROR;
}

int far pascal _loadds MFS_OPEN(
    char far *name,			/* name		*/
    unsigned long far *size		/* size		*/
) {
    char LocalName[CCHMAXPATH];

    struct file *f;

    if ((*name != '/') && (*name != '\\')) 
        strcpy(LocalName, "C:\\");
    else
        strcpy(LocalName, "C:");

    strcat(LocalName, name);

    printk("**** MFS_OPEN(%s)", LocalName);

    f     = _open_by_name(&stage1_superblk, LocalName, 0);
    if (f) {
        *size = f->f_inode->i_size;
        return NO_ERROR;
    } else {
        *size = 0;
        return ERROR_FILE_NOT_FOUND;
    }
}

int far pascal _loadds MFS_READ(
    char far *data,		/* data		*/
    unsigned short far *length	/* length	*/
) {
    unsigned long len;

    printk("**** MFS_READ");

    if (!used_files)
        ext2_os2_panic(0, "MFS_READ : flist = 0");
    if (used_files->f_magic != FILE_MAGIC)
        ext2_os2_panic(0, "MFS_READ : invalid magic number");

    len = (unsigned long)*length;
    VFS_read(used_files, data, len, &len); /* failure in VFS_read = panic */
    *length = (unsigned short)len;
    return NO_ERROR;
}

int far pascal _loadds MFS_TERM(void) {

    printk("**** MFS_TERM");

    if (mfs_data.init_fsd)
	mfs_data.init_fsd(&mfs_data);
    return NO_ERROR;
}
