
//===========================
// XPoint.cpp
// by SA VanNess
// 08 Mar 97
// for the Win32 platform
//===========================
// Point-class objects
// Class implementations
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#include <afxwin.h>
#include <afxcmn.h>
#include <afxres.h>

#include "macros.h"
#include "xbitmap.h"
#include "xpoint.h"

//===========================
// XPoint

//-----------------
void XPoint::Randomize(CRect rc, UINT iMinD, UINT iMaxD)
{
x = (rand()%(rc.right-rc.left)) + rc.left;
y = (rand()%(rc.bottom-rc.top)) + rc.top;
dx = ((rand()%(iMaxD-iMinD+1)) + iMinD); if (rand()%2) dx = -dx;
dy = ((rand()%(iMaxD-iMinD+1)) + iMinD); if (rand()%2) dy = -dy;
}

//-----------------
BOOL XPoint::Clip(CRect rc)
{
int xx=x+dx;
int yy=y+dy;

if (xx < rc.left || xx >= rc.right) return TRUE;
if (yy < rc.top || yy >= rc.bottom) return TRUE;

return FALSE;
}

//-----------------
BOOL XPoint::Update(XBitmap &xBmp)
{
//Black/blue boundary cld
Incr();

if ((m_bBlueBase) == (BOOL)(xBmp.GetPixel(x,y)&XBC_BLUEGRN)) return FALSE;

//We hit a boundary, so backup and poke around
int xx,yy;
xx = x; yy = y;
Decr();
if ((m_bBlueBase) == (BOOL)(xBmp.GetPixel(x,yy)&XBC_BLUEGRN)) dx = -dx; //if new y is okay, flip x
if ((m_bBlueBase) == (BOOL)(xBmp.GetPixel(xx,y)&XBC_BLUEGRN)) dy = -dy; //if new x is okay, flip y
if ((m_bBlueBase) == (BOOL)(xBmp.GetPixel(x-dx,y-dy)&XBC_BLUEGRN)) { dx = -dx; dy = -dy; }
Incr();
return TRUE;
}

//===========================
// XPointNoRed

//-----------------
BOOL XPointNoRed::CldRed(XBitmap &xBmp, BOOL bThorough)
{
UINT xx,yy;
xx = x+dx;
yy = y+dy;
if (dx)
   {
   if (xBmp.GetPixel(xx,yy)&XBC_RED) return TRUE;
   if (bThorough && (xBmp.GetPixel(xx,yy+OBJ_OFFSET)&XBC_RED)) return TRUE;
   if (bThorough && (xBmp.GetPixel(xx,yy-OBJ_OFFSET)&XBC_RED)) return TRUE;
   }
if (dy)
   {
   if (xBmp.GetPixel(xx,yy)&XBC_RED) return TRUE;
   if (bThorough && (xBmp.GetPixel(xx+OBJ_OFFSET,yy)&XBC_RED)) return TRUE;
   if (bThorough && (xBmp.GetPixel(xx-OBJ_OFFSET,yy)&XBC_RED)) return TRUE;
   }
return FALSE;
}

//===========================
// XGuy

//-----------------
BOOL XGuy::Clip(CRect rc)
{
if (!XPoint::Clip(rc))
   return FALSE;

if (dx < 0) x = rc.left+OBJ_OFFSET;
if (dx > 0) x = rc.right-OBJ_OFFSET-1;
if (dy < 0) y = rc.top+OBJ_OFFSET;
if (dy > 0) y = rc.bottom-OBJ_OFFSET-1;

dx = dy = 0;

return TRUE;
}

//-----------------
BOOL XGuy::Update(CDC &DC, XBitmap &xBmp, BOOL bDraw)
{
UINT ox,oy,xx,yy,cc = XBC_NONE;

//Stopped?
if (!dx && !dy) return bDraw;

ox = x; oy = y;
Incr();

//Edge detection to prevent redline slippage ;)
if (bDraw)
   if (dx)
      {
      if (xBmp.GetPixel(x,y+OBJ_OFFSET)&XBC_BLUEGRN) cc = XBC_BLUEGRN;
      if (xBmp.GetPixel(x,y-OBJ_OFFSET)&XBC_BLUEGRN) cc = XBC_BLUEGRN;
      }
   else //dy
      {
      if (xBmp.GetPixel(x+OBJ_OFFSET,y)&XBC_BLUEGRN) cc = XBC_BLUEGRN;
      if (xBmp.GetPixel(x-OBJ_OFFSET,y)&XBC_BLUEGRN) cc = XBC_BLUEGRN;
      }

if (xBmp.GetPixel(x,y)&XBC_BLUEGRN) cc = XBC_BLUEGRN;

//Draw the redline onto the DC and mark the xbmp with XBC_RED
if (bDraw || (cc == XBC_NONE))
   {
   for(xx=x-2;xx<=x+2;xx++)
      {
      for(yy=y-2;yy<=y+2;yy++)
         DC.SetPixel(xx,yy,RGB_RED);
      xBmp.VLine(xx,y-2,y+2,XBC_RED,TRUE);
      }
/*   if (!bDraw) //apply extra XBC_RED sealant for those rough edges  ;)
      {
      bDraw = TRUE;
      for(xx=ox-2;xx<=ox+2;xx++)
         xBmp.VLine(xx,oy-2,oy+2,XBC_RED,TRUE);
      }*/
   }

if (cc == XBC_NONE)
   return TRUE; //drawing
else
   return FALSE; //not drawing
}

//===========================
// XBDot

//-----------------
BOOL XBDot::Clip(CRect rc)
{
if (!XPoint::Clip(rc))
   return FALSE;

int xx=x+dx;
int yy=y+dy;

if (xx < rc.left || xx > rc.right-1) dx = -dx;
if (yy < rc.top || yy > rc.bottom-1) dy = -dy;

return TRUE;
}
