
//===========================
// XBitmap.h
// by SA VanNess
// 08 Mar 97
// for the Win32 platform
//===========================
// 8-Plane virtual bitmap
// Class declaration
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#ifndef __XBITMAP_H__
#define __XBITMAP_H__

//-----------------
class XBitmap //8-plane monochrome (256-color) bitmap storage class
{
private:
   UINT *m_pBits; //pointer to array of 32bit values
   UINT m_iWidth; //width in pixels
   UINT m_iHeight; //height in pixels
   UINT m_iWidth32; //width in 32-pixel quanta

public:
   XBitmap()
      { m_pBits = NULL; m_iWidth = m_iHeight = m_iWidth32 = 0; }
   ~XBitmap()
      { free(m_pBits); }
   BOOL Create(UINT iWidth, UINT iHeight);
   BOOL Copy(XBitmap &xBmpSrc);
   BOOL Clear();
   
   UINT GetPixel(UINT xx, UINT yy); //inline
   //BOOL SetPixel(UINT xx, UINT yy, UINT cc); //inline
   BOOL SetPixel(UINT xx, UINT yy, UINT cc, BOOL bVal); //inline 

   void HLine(UINT x0, UINT y1, UINT yy, UINT cc, BOOL bVal);
   void VLine(UINT xx, UINT y0, UINT y1, UINT cc, BOOL bVal);
   void Line(UINT x0, UINT y0, UINT x1, UINT y1, UINT cc, BOOL bVal);
   void FillSolidRect(CRect rc, UINT cc, BOOL bVal);
   void Wipe(UINT c1, UINT c2);
   void FloodFill(UINT xx, UINT yy, UINT cc);

   BOOL RScan(UINT xx, UINT yy);
   UINT ExpandTo(CDC &DC); //ret number of bluegrn pix
   UINT CountFilledPix(UINT iFirstLine, UINT iLastLine); //ret number of bluegrn pix
   UINT CalcFillFraction(UINT nPix); //ret fraction of xBmp filled with bluegrn pix
};


#endif //include-guard
