
//===========================
// Macros.h
// by SA VanNess
// 08 Mar 97
// for the Win32 platform
//===========================
// Game-specific
// Global macros
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#ifndef __MACROS_H__
#define __MACROS_H__

//Game info!
#define GAME_TITLE "Xonix32"
#define RELEASE
//#define BENCH_FPS
//#define LOGFILE

//Timer IDs (arbitrary nonzero constants)
#define IDT_GAMECLK 101

//Game params
#define MIN_FPS 10
#define MAX_FPS 50
#define NOM_FPS ((MIN_FPS+MAX_FPS)/2)
#define BONUS_CALC(remain,limit) 10*MAX(0,((remain)-((limit)/2))/NOM_FPS)

#define MAXBDOTS 4
#define MAXDOTS 8
#define MAXLINES 4
#define LEVEL2BDOTS(lev) MIN(MAXBDOTS,(1+(lev-1)/3))
#define LEVEL2DOTS(lev) MIN(MAXDOTS,(3+(lev+0)/3))
#define LEVEL2LINES(lev) MIN(MAXLINES,(0+(lev+1)/3))

// Sizing params
#define OBJ_OFFSET 3
#define OBJ_SIZE ((2*OBJ_OFFSET)+1)
#define OBJ_MOVE 4
#define BORDER_THICKNESS (OBJ_OFFSET+4*OBJ_MOVE-1)

//Colors
#define RGB_WHITE RGB(255,255,255)
#define RGB_BLACK RGB(0,0,0)      
#define RGB_GREY RGB(132,132,132) 
#define RGB_BLUEGRN RGB(0,132,132)
#define RGB_RED RGB(255,0,0)      
#define RGB_YELLOW RGB(132,132,0) 
#define RGB_YELLOW2 RGB(255,255,0)

#define XBC_NONE ((UINT)0x00)    //00000000
#define XBC_BLUEGRN ((UINT)0x01) //00000001
#define XBC_RED ((UINT)0x02)     //00000010
#define XBC_GREY ((UINT)0x04)    //00000100
#define XBC_WHITE ((UINT)0x08)   //00001000
#define XBC_FULL ((UINT)0xff)    //11111111

//Misc functions macros
#define MIN(a,b) (((a)<=(b))?(a):(b))
#define MAX(a,b) (((a)>=(b))?(a):(b))

//Temp debugging stuff
extern char g_szBuffer[];

#ifdef LOGFILE
extern FILE *g_pfLog; //logfile.out
#endif //logfile


#endif //include-guard
