
//===========================
// HiScores.cpp
// by SA VanNess
// 05 Jun 97
// for the Win32 platform
//===========================
// High score table
// Class implementation
//===========================
// Copyright (C) 1997  SA VanNess
// <savanness@pipeline.com>
//
// For copyright information, see the file gnu_license.txt included
// with this source code distribution.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//===========================

#include <afxwin.h>
#include <afxcmn.h>
#include <afxres.h>

#include "macros.h"
#include "hiscores.h"

//-----------------
BOOL CScoreList::Save()
{
int i,j;
FILE* pf = fopen("hiscores.dat","wb");
if (!pf) return FALSE;

for(i=0; i < 10; i++) m_iScoreArray[i] ^= 0x55555555;
for(i=0; i < 10; i++) for(j=0; j < 16; j++) m_szNameArray[i][j] ^= 0x55;
fwrite(m_iScoreArray,sizeof(UINT),10,pf);
fwrite(m_szNameArray,16,10,pf);
for(i=0; i < 10; i++) m_iScoreArray[i] ^= 0x55555555;
for(i=0; i < 10; i++) for(j=0; j < 16; j++) m_szNameArray[i][j] ^= 0x55;

fclose(pf);
return TRUE;
}

//-----------------
BOOL CScoreList::Load()
{
int i,j;
FILE* pf = fopen("hiscores.dat","rb");
if (!pf)
   {
   for(UINT i=0; i < 10; i++)
      {
      m_iScoreArray[i] = 0;
      strcpy(m_szNameArray[i],"...empty...");
      }
   return FALSE;
   }

fread(m_iScoreArray,sizeof(UINT),10,pf);
fread(m_szNameArray,16,10,pf);
for(i=0; i < 10; i++) m_iScoreArray[i] ^= 0x55555555;
for(i=0; i < 10; i++) for(j=0; j < 16; j++) m_szNameArray[i][j] ^= 0x55;

fclose(pf);
return TRUE;
}

//-----------------
void CScoreList::Insert(UINT iSlot, char* pszName, UINT iScore)
{
UINT j=0;

j = 9;
while(j > iSlot)
   {
   m_iScoreArray[j] = m_iScoreArray[j-1];
   strcpy(m_szNameArray[j],m_szNameArray[j-1]);
   j--;
   }
m_iScoreArray[j] = iScore;
strcpy(m_szNameArray[j],pszName);

return;
}

