///////////////////////////////////////////////
// 
//  Snipe2d ludum dare 48h compo entry
//
//  Jari Komppa aka Sol 
//  http://iki.fi/sol
// 
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
//
///////////////////////////////////////////////
//
// Houses are taken from a satellite picture of glasgow.
//
// The sources are a mess, as I didn't even try to do anything
// really organized here.. and hey, it's a 48h compo =)
//
#include "snipe2d.h"

void target()
{
    static int lastBadGuys = -1;
    static int lastVIPs = -1;
    static int badGuysChangeTick = 0;
    static int VIPsChangeTick = 0;

    int tick = GetTickCount();

    if (lastBadGuys != gBadGuyCount)
    {
        lastBadGuys = gBadGuyCount;
        badGuysChangeTick = tick;
    }
    if (lastVIPs != gVIPCount)
    {
        lastVIPs = gVIPCount;
        VIPsChangeTick = tick;
    }
    
    if ( SDL_LockSurface(gScreen) < 0 ) 
        return;

    int i;
    short *tgt = (short*)gScreen->pixels;

    if (gReloading)    
    {
        float distance = gReloading / (float)RELOAD_TIME;
        distance = distance * distance * distance;

        int ofs = (gScreen->pitch / 2) * 240;
        for (i = 0; i < 640; i++, ofs++)
            tgt[ofs] = (short)0;

        ofs = 320;
        for (i = 0; i < 480; i++, ofs += gScreen->pitch / 2)
            tgt[ofs] = (short)0;

        ofs = (gScreen->pitch / 2) * (int)(240 + distance * 200);
        for (i = 0; i < 640; i++, ofs++)
            tgt[ofs] = (short)0xC000;
        
        ofs = (gScreen->pitch / 2) * (int)(240 - distance * 200);
        for (i = 0; i < 640; i++, ofs++)
            tgt[ofs] = (short)0xC000;

        ofs = (int)(320 + distance * 300);
        for (i = 0; i < 480; i++, ofs += gScreen->pitch / 2)
            tgt[ofs] = (short)0xC000;

        ofs = (int)(320 - distance * 300);
        for (i = 0; i < 480; i++, ofs += gScreen->pitch / 2)
            tgt[ofs] = (short)0xC000;

        SDL_UnlockSurface(gScreen);

    }
    else // not reloading
    {
        int ofs = (gScreen->pitch / 2) * 240;
        for (i = 0; i < 640; i++, ofs++)
            tgt[ofs] = (short)0xff00;

        ofs = 320;
        for (i = 0; i < 480; i++, ofs += gScreen->pitch / 2)
            tgt[ofs] = (short)0xff00;

        SDL_UnlockSurface(gScreen);
    }
    
    int row;
    row = 196;
    print(324, row, COLOR_YELLOW, "time:    %02d:%02d", ((GetTickCount() - gGameStartTick) / 60000), ((GetTickCount() - gGameStartTick) / 1000)%60);
    row += 7;
    if ((tick - VIPsChangeTick) < 500)
        print(324, row, COLOR_GREEN, "VIPs    %6d", gVIPCount);
    else
        print(324, row, COLOR_YELLOW, "VIPs    %6d", gVIPCount);
    row += 7;
    if ((tick - badGuysChangeTick) < 500)
        print(324, row, COLOR_RED, "Threat  %6d", gBadGuyCount);
    else
        print(324, row, COLOR_YELLOW, "Threat  %6d", gBadGuyCount);
    row += 7;
    print(324, row, COLOR_YELLOW, "Score%09.8d", gScore);
    row += 7;
    print(324, row, COLOR_YELLOW, "FPS     %3.3f", (gFrameCount * 1000.0f) / (tick - gStartTick));
    row += 7;
    print(324, row, COLOR_YELLOW, "Zoom  %7.0fx", (1.0f / gCoordScale) * 100);
    row = 244;
    if (gSightedCharacter == NULL)
    {
        print(278, row, COLOR_YELLOW, "%10x", (tick >> 4) *  700);
        row += 7;
        print(278, row, COLOR_YELLOW, "%10x", (tick >> 3) *  1337);
        row += 7;
        print(278, row, COLOR_YELLOW, "%10x", (tick >> 2) *  4);
        row += 7;
        print(278, row, COLOR_YELLOW, "%10x", (tick >> 1) *  4935);
        row += 7;
        print(278, row, COLOR_YELLOW, "%10x", (int)(gMouseX * 0xc0c4c01a) - (tick >> 3));
        row += 7;
        print(278, row, COLOR_YELLOW, "%10x", (int)(gMouseY * 0xb4be2b3d) - (tick >> 4));
        row += 7;
        print(278, row, COLOR_YELLOW, "%10x", (tick << 4) *  4095);
        row += 7;
        print(278, row, COLOR_YELLOW, "%10x", (int)(gMouseZ * 0xf00ba573) - (tick >> 5));
    }
    else
    {
        print(238, row, COLOR_YELLOW, "%20s", "Citizen profile");
        row += 7;
        row += 7;
        print(238, row, COLOR_YELLOW, "%20s", "Coordinates");
        row += 7;
        print(238, row, COLOR_YELLOW, "     %6.2f - %6.2f", gSightedCharacter->mX, gSightedCharacter->mY);
        row += 7;
        row += 7;
        print(238, row, COLOR_YELLOW, "%20s", "Classification");
        row += 7;
        switch (gSightedCharacter->mType)
        {
        case 0:
            print(239, row + 1, COLOR_BLACK, "%20s", "** THREAT **");
            print(238, row, COLOR_RED, "%20s", "** THREAT **");
            row += 7;
            row += 7;
            print(238, row, COLOR_YELLOW, "%20s", "Destination");
            row += 7;
            if (gSightedCharacter->mTarget != -1)
            {
                print(238, row, COLOR_YELLOW, "     %6.2f - %6.2f", gCharacter[gSightedCharacter->mTarget].mX, gCharacter[gSightedCharacter->mTarget].mY);
                row += 7;
                row += 7;
                print(238, row, COLOR_YELLOW, "%20s", "Distance");
                row += 7;
                print(238, row, COLOR_YELLOW, "     %15.2f", distance(gCharacter[gSightedCharacter->mTarget].mX, gCharacter[gSightedCharacter->mTarget].mY, gSightedCharacter->mX, gSightedCharacter->mY));
            }
            else
            print(238, row, COLOR_YELLOW, "%20s", "Unknown");
            row += 7;
            row += 7;
            print(238, row, COLOR_YELLOW, "%20s", "VPB file ID");
            row += 7;
            print(238, row, COLOR_YELLOW, "      %03X-%07X/%02X", 
                        ((((unsigned int)gSightedCharacter) * 7001337) & 0xfff),
                        (((unsigned int)gSightedCharacter) * 1337357) & 0xfffffff,
                        (((unsigned int)gSightedCharacter) * 70741)  & 0xff);


            break;
        case 1:
            print(239, row + 1, COLOR_BLACK, "%20s", "- VIP -");
            print(238, row, COLOR_GREEN, "%20s", "- VIP -");
            row += 7;
            row += 7;
            print(238, row, COLOR_YELLOW, "%20s", "Destination");
            row += 7;
            print(238, row, COLOR_YELLOW, "     %6.2f - %6.2f", (float)gSpawnpoint[gSightedCharacter->mTarget].mX, (float)gSpawnpoint[gSightedCharacter->mTarget].mY);
            row += 7;
            row += 7;
            print(238, row, COLOR_YELLOW, "%20s", "Distance");
            row += 7;
            print(238, row, COLOR_YELLOW, "     %15.2f", distance((float)gSpawnpoint[gSightedCharacter->mTarget].mX, (float)gSpawnpoint[gSightedCharacter->mTarget].mY, gSightedCharacter->mX, gSightedCharacter->mY));
            row += 7;
            row += 7;
            print(238, row, COLOR_YELLOW, "%20s", "Net worth");
            row += 7;
            print(238, row, COLOR_YELLOW, "%20s", "Classified");
            break;
        case 2:
            print(238, row, COLOR_YELLOW, "%20s", "Citizen");
            row += 7;
            row += 7;
            print(238, row, COLOR_YELLOW, "%20s", "Net worth");
            row += 7;
            print(238, row, COLOR_YELLOW, "%17u KC", (((unsigned int)gSightedCharacter) * 1337357) % 71937);
            break;
        case 3:
            print(238, row, COLOR_YELLOW, "%20s", "Splat.");
            break;
        case 4:
            print(238, row, COLOR_BLACK, "%20s", "Missed shot");
            break;
        }
        row += 7;

                                            
    }

    if (gFrameCount > 100)
    {
        gFrameCount = 0;
        gStartTick = tick;
    }
    
}

