;NWOTERM.CTL
;
;This file is a "control file" for use with NWOTERM. It contains various
;parameters effecting the operation and configuration of NWOTERM. This file
;may be edited with any ASCII text editor. Lines beginning with a semicolon
;are treated as comments.
;
;
;PORT      The PORT parameter defines the default port that NWOTERM will use
;          if no port is given on the command line.
;
PORT 2
;
;BAUD      The baud parameter defines the default baud rate that NWOTERM will
;          use if no baud rate is given on the command line.
BAUD 38400
;
;
;MACRO     MACRO specifies a function key definition. With HPReader, you
;          may specify (normal,shift,ctrl,or alt) F1 - F10 as macro keys.
;          Macro keys may store any string of characters up to 254 characters
;          long. Upon pressing the specified key, NWOTERM will act upon
;          the keys specified in the macro.
;
;          The format for the macro definition is as follows:
;
;                   -MACRO <keynum> <string of characters>
;
;          The key numbers are as follows:
;
;                  1-10 = F1-F10
;
;          The <string of characters> may be any string of up to 255
;          characters. It may be only one line long, but may contain any
;          control characters and/or keyboard scan codes. To specify a control
;          character, use a carat (^) sign followed by the character (i.e.
;          CTRL-M would be ^M, CTRL-A would be ^A). Scan codes may be used
;          by inserting "\0xnn" where "nn" is the hexidecimal scan code of the
;          key you wish to insert.
;
;
;
;The following lines contain the configuration variables for NWOTERM's color
;scheme. For monochrome, you should leave them all commented out unless
;you specifically want to change something. (Monochrome is defaulted within
;NWOTERM). For color, you should uncomment them. A table of color definitions
;follows the configuration statements.
;
;
;     ::-------------------  Uncomment the following lines to set up colors
;     ::-------------------  for a color monitor
;     \/
;
HEADERNORMFORE 15
HEADERNORMBACK 1
HEADERHILIGHTFORE 0
HEADERHILIGHTBACK 7
MENUNORMBACK 3
MENUNORMFORE 0
MENUHILIGHTBACK 7
MENUHILIGHTFORE 0
MENUBORDERBACK 3
MENUBORDERFORE 15
FOOTERBACK 1
FOOTERFORE 15
DIALDIRBACK 3
DIALDIRFORE 0
DIALDIRBORDERBACK 3
DIALDIRBORDERFORE 15
DIALBACK 3
DIALFORE 0
DIALBORDERBACK 3
DIALBORDERFORE 15
CONBORDERBACK 3
CONBORDERFORE 15
CONBACK 3
CONFORE 0
CONHILIGHTBACK 7
CONHILIGHTFORE 0
HELPBACK 1
HELPFORE 7
HELPBORDERBACK 1
HELPBORDERFORE 15
LOGBACK 1
LOGFORE 7
LOGBORDERBACK 1
LOGBORDERFORE 15
RMBORDERBACK 3
RMBORDERFORE 15
RMBACK 3
RMFORE 0
RMHILIGHTBACK 7
RMHILIGHTFORE 0
;
;
;
; Color Codes:
;
;     Black     0        DarkGray      8
;     Blue      1        LightBlue     9
;     Green     2        LightGreen   10
;     Cyan      3        LightCyan    11
;     Red       4        LightRed     12
;     Magenta   5        LightMagenta 13
;     Brown     6        Yellow       14
;     LightGray 7        White        15
;
; (Note: Only colors 0-7 are available as background colors)
;
;Reliability parameters: The following parameters if specified will activate
;various NWOTERM services. The user is allowed them to be turned on/off because
;line noise may cause severe trouble for them.
