unit About; { About box that uses the version information resource. }

{
This unit requires an "About..." dialog with the following control IDs:
  IDD_PRODUCTNAME	Product name
  IDD_PRODUCTVERSION    Product version
  IDD_LEGALCOPYRIGHT    Copyright string

The dialog box uses stringtable strings with the following ID numbers:
  IDS_ABOUT             The "About" string
  IDS_WINDOWTITLE       String to use in the title (main window caption)
  IDS_VERSION           The "Version" string
  IDS_UNKNOWN           The "Unknown" string for missing version information

This unit also uses the Version unit's version information class (TVersionInfo). 
}  

interface

uses
  Windows, Messages;

{ Dialog box procedure for the About... box }
function About_DlgProc(Dialog: HWND; Msg, WParam: UINT; LParam: LPARAM): Bool; stdcall; export;

implementation

uses
  Version, SysUtils;

{$I Resource.inc}

var
  Ver: TVersionInfo;

{ Initialize the About box's controls with the version information. }
procedure About_OnInitDialog(Dialog: HWND; var Msg: TWMInitDialog);
var
  CaptionString, VersionString: string;
begin
  { Load "About" and application name strings and make a caption. }
  CaptionString := LoadStr(IDS_ABOUT) + ' ' + LoadStr(IDS_WINDOWTITLE);
  SetWindowText(Dialog, PChar(CaptionString));

  { Load "Version" and make a version string. }
  VersionString := LoadStr(IDS_VERSION) + ' ' + Ver.GetVarString(VF_VF_PRODUCTVERSION);
  SetDlgItemText(Dialog, IDD_PRODUCTVERSION, PChar(VersionString));

  SetDlgItemText(Dialog, IDD_PRODUCTNAME, PChar(Ver.GetVarString(VF_VF_PRODUCTNAME)));
  SetDlgItemText(Dialog, IDD_LEGALCOPYRIGHT, PChar(Ver.GetVarString(VF_VF_LEGALCOPYRIGHT)));

  Msg.Result := Longint(True);
end;

{ Handle the press of the OK button or cancellation with the Esc key. }
procedure About_OnCommand(Dialog: HWND; var Msg: TWMCommand);
begin
  if (Msg.ItemID = IDOK) or (Msg.ItemID = IDCANCEL) then
  begin
    EndDialog(Dialog, 0);
    Msg.Result := Longint(True);
  end;
end;

{ Dialog box procedure for the About... box }
function About_DlgProc(Dialog: HWND; Msg, WParam: UINT; LParam: LPARAM): Bool; stdcall; export;
var
  DialogMessage: TMessage;
begin
  DialogMessage.Msg := Msg;
  DialogMessage.WParam := WParam;
  DialogMessage.LParam := LParam;
  DialogMessage.Result := 0;

  case Msg of
    WM_INITDIALOG:
      About_OnInitDialog(Dialog, TWMInitDialog(DialogMessage));
    WM_COMMAND:
      About_OnCommand(Dialog, TWMCommand(DialogMessage));
  end;

  Result := Boolean(DialogMessage.Result);
end;

{ Use Delphi's unit initialization and finalization features to set up
  the version information upon startup and destroy the object when the
  program terminates. }
initialization
  Ver := TVersionInfo.Create(IDS_UNKNOWN); { pass the ID of an "unknown" string }

finalization
  Ver.Free;

end.
