// Chess clock header file
// M\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536-9801
/***************************************************************************/

extern "C" two_tone(),
	   blatt(),
    beep1(),
    beep2();

#define PLAY 1
#define GAME_OVER 1
#define QUIT 2	
#define ESC 27
#define MAXLEN 4
#define BUFSIZE 12
#define BLK_TIME 460
#define NAME_POS 530
#define Y_TIMEPOS 300
#define POS_OFFSET 158
#define POS1_OFFSET 130
#define COLORS 15
#define PATTERNS 11
#define RADIUS 50
#define X_C 315
#define Y_C 225
#define MOVES_X 316
#define MOVES_Y 440

typedef enum { FALSE, TRUE } BOOLEAN;
enum FLAG { OFF, ON };
enum Player { WHITE_, BLACK_ };

char *player[] = { "White", "Black" };

void graphics_setup( int ),
     exit__();



class CountdownTimer
   {
   protected:
      int hours,
	  minutes,
	  moves,
	  warning,
	  text_color;
      char line_clear [ BUFSIZE ];
	 Player p,
		   pp;
      FLAG running_flag,
	   visual_ticking_flag,
	   time_warning_flag;
      time_t seconds,
	     total_seconds,
	     start_t,
	     end_t,
	     startn_t,
	     interval_t,
	     running_t;
   public:
      CountdownTimer()
	  {
	   hours = 2; minutes = moves = 0; seconds = 0L;
	   total_seconds = hours * 3600 + minutes * 60;
	   p = WHITE_;
	  }
      CountdownTimer( int hrs, int min, time_t sec, Player pl )
	  {
	  hours = hrs; minutes = min; seconds = sec; moves = 0;
	  total_seconds = hours * 3600 + minutes * 60 + seconds;
	  p = pl;
	  }
      CountdownTimer( int min, time_t sec, Player pl )
	  { 
	  sec += min * 60;
	  total_seconds = sec; 
	  hours = sec / 3600;
	  minutes = ( sec % 3600 ) / 60;
	  seconds = sec % 60;
	  moves = 0;
	  p = pl;
	  }
      CountdownTimer( int hrs, int min, Player pl )
	 {
	 hours = hrs; minutes = min; seconds = 0L; moves = 0;
	 total_seconds = hours * 3600 + minutes * 60;
	 p = pl;
	 }
      CountdownTimer( time_t sec, Player pl )
	  {
	  total_seconds = sec;
	  convert( sec );
	  p = pl;
	  moves = 0;
	  }
      void convert( time_t sec )
	  { 
	  hours = sec / 3600;
	  sec %= 3600;
	  minutes = sec / 60;
	  seconds = sec % 60;
	  }

      void display_time()
	  {
	  char dbuff [ BUFSIZE ];

	     sprintf( dbuff,  "%02d:%02d:%02ld", hours, minutes, seconds );
 
	     erase_numbers();  // Wipe off old time.
	     
	     setcolor( text_color );
	     outtextxy( p * BLK_TIME, Y_TIMEPOS, dbuff );
	     sprintf( line_clear, dbuff );
	  }

      BOOLEAN timeout()
	 {
	 if( !hours )
	    if( !minutes )
	       if( !seconds )
		  {
		  two_tone();
		  return ( TRUE );
		  }
	 return ( FALSE );
	 }

      void exit_()
      { 
	 char buff [20];


      if( p )
	 sprintf( buff, "Black out of time." );
      else
	 sprintf( buff, "White out of time." );

      setcolor( RED );
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
      outtextxy( 460, 440, buff );

      sprintf( buff, "PRESS A KEY" );
      outtextxy( 460, 460, buff );

      getch();
      closegraph();
      exit ( GAME_OVER );
      }

      void initialize_clock()
      {
      running_flag = OFF;  //Clock is running.
      running_t = 0;
      start_t = time( NULL );
      }

      void clock_on(),
	   erase_numbers(),
	   display_moves(),
        ShowFlag();

	 friend void play();
	
    }; //end class defn.

