 /*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 The LiteStep Development Team

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


/****************************************************************************

 9/11/98 - M. West
			New popups created, limited functionality, will parse in a simple
			1 layer popup menu, and run programs from it,

****************************************************************************/



#include <windows.h>
#include <stdio.h>

#include "..\lsapi\lsapi.h"
#include "popup.h"

#define WM_SELECTED 9667
#define WM_NOTSELECTED 9666
//BOOL selected[255];

BOOL isMainWindowHidden = TRUE;

int previousCounter2 = 0;
int counter2 = 0;
int popupSubHeight = 20;
int titleHeight = 20;

HWND itemCaller = NULL;
menuItem *previousItem = NULL;	

BOOL noPopupBevel;
int popupLevel = 0;
HFONT popupFont;
int popupFontHeight;
char popupFontFace[256];
COLORREF titleColor, selColor, normColor;
WNDCLASS wc;
const char szAppName[] = "PopupMenu"; // Our window class, etc

WNDCLASS subM;
const char popupSubName[] = "subPopupMenu"; // Our window class, etc

popupMenu popup; //popup class struct
fileItem *popupFile;  //rc file info holder
subMenuHWND subList[255]; //popup submenu pointer struct

int subEnum = 0; //submenu counter

HINSTANCE appInstance;
int yy;
HWND parent;
HWND hMainWnd = NULL;

BOOL timerIdent = FALSE;

menuItem *timerPointer = NULL;
int timerHeight = 0;


BOOL goingToSubMenu = FALSE;
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
int initModuleEx(HWND ParentWnd, HINSTANCE dllInst, LPCSTR szPath);
int fillDirectory(char *dirName, menuItem *target);
void displaySubMenu(HWND calledFrom, menuItem *item, int height);
LRESULT CALLBACK PopupWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
void displaySingleMenuItem(HWND hwnd, menuItem *item, int totalHeight, BOOL selected);
void closePopupSubMenu(HWND subMenu);
void initializePopupMenu();
void displayPopup(HWND hwnd);

POINT pt; 

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//BEGIN CLASS DEFINITION 
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

menuItem::~menuItem()
	{
		if(next != NULL)
			delete next;
		if(SMenu != NULL)
			delete SMenu;
	}

BOOL popupMenu::newMenuItem()
{
	menuItem *temp = root;
	
	while(1) //finds the last node in the list
	{
		if(temp == NULL)
			break;
		else if(temp->next == NULL)
			break;
		else temp = temp->next;
	}
	
	if(temp == NULL)
	{
		root = new menuItem;
		root->next = NULL;
		current = root;
	}
	
	else 
	{
		temp->next = new menuItem;
		current = temp->next;
	}
	
	return(TRUE);
}


int popupMenu::returnMenuWidth()
{
	return(menuWidth);
}


fileItem::fileItem()
{
	strcpy(itemName, "\0");
	strcpy(bmpName, " ");
	strcpy(popupCommand, " ");
	next = NULL;
	itemHeight = popupSubHeight;
}

fileItem::~fileItem()
{
	delete next;
}


BOOL subMenu::newMenuItem()
{
	menuItem *temp = root;
	
	while(1) //finds the last node in the list
	{
		if(temp == NULL)
			break;
		else if(temp->next == NULL)
			break;
		else temp = temp->next;
	}
	
	if(temp == NULL)
	{
		root = new menuItem;
		current = root;
	}
	
	else 
	{
		temp->next = new menuItem;
		current = temp->next;
	}
	
	return(TRUE);
}




////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//END CLASS DEFINITION 
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


void destroyCurrentSubMenu()
{
	DestroyWindow((HWND)subList[subEnum].subMenuHwnd);
//	subList[subEnum].subMenu->isSubOpen = FALSE;
	subList[subEnum].subMenuHwnd = NULL;
	subList[subEnum].subMenu = NULL;
	subEnum--;
}


void destroyAllSubMenus()
{
	for(int i = 0;i < 255; i++)
	{
		if(subList[i].subMenuHwnd != NULL)
		{
			DestroyWindow((HWND)subList[i].subMenuHwnd);
//			subList[i].subMenu->isSubOpen = FALSE;
			subList[i].subMenuHwnd = NULL;
			subList[i].subMenu = NULL;
			
		}
		subEnum = 0;
	}
}

//get bitmaps size func stolen from 23e
void GetBitmapSize(HBITMAP hBitmap, int *x, int *y)
{
BITMAP bm;
if (!GetObject(hBitmap, sizeof(bm), (LPSTR)&bm))
	{
	*x=0;
	*y=0;
	}
else
	{
	*x = bm.bmWidth;
	*y = bm.bmHeight;
	}
}


//cleanup, not much to do
int quitModule(HINSTANCE dllInst)
{
	destroyAllSubMenus();
	DestroyWindow(hMainWnd);
	DeleteObject(popupFont);
	UnregisterClass(szAppName,dllInst); // unregister window class
	UnregisterClass(popupSubName,dllInst); // unregister window class
	return 1;
}

//now defunct entry point, will take it out if somone complains
int initModule(HWND ParentWnd, HINSTANCE dllInst, wharfDataType* wd)
{
	return initModuleEx (ParentWnd, dllInst, wd->lsPath);
}

//DLL entry point
int initModuleEx(HWND ParentWnd, HINSTANCE dllInst, LPCSTR szPath)
{

	

	appInstance = dllInst;
	parent = ParentWnd;

	//set all menus to NON-selected mode
	//for(int SE = 0; SE < 255; selected[SE] = FALSE, SE++);
	//parse file and fill popup class structure
	initializePopupMenu();
	

	memset(&wc,0,sizeof(wc));
	wc.lpfnWndProc = (WNDPROC)&WndProc;// our window procedure
	//wc.hbrBackground = (HBRUSH) GetStockObject(LTGRAY_BRUSH);
	wc.hInstance = appInstance;			
	wc.lpszClassName = szAppName;// our window class name
	wc.style = 0;

	
	memset(&subM,0,sizeof(subM));
	subM.lpfnWndProc = (WNDPROC)&PopupWndProc;// our window procedure
	//subM.hbrBackground = (HBRUSH) GetStockObject(LTGRAY_BRUSH);
	subM.hInstance = appInstance;			
	subM.lpszClassName = popupSubName;// our window class name
	subM.style = 0;


	if (!RegisterClass(&wc)) 
	{
		MessageBox(NULL,"Error registering window class",szAppName,MB_OK);
		return 1;
	}

	if (!RegisterClass(&subM)) 
	{
		MessageBox(NULL,"Error registering window class",szAppName,MB_OK);
		return 1;
	}

	hMainWnd = CreateWindowEx(
    		WS_EX_TOPMOST|WS_EX_TOOLWINDOW,//WS_EX_TRANSPARENT,									// exstyles 
		    szAppName,								// our window class name
		    "",											// use description for a window title
		    WS_POPUP,				
		    0, 0,									// position 
		    popup.menuWidth,(popup.totalHeight + titleHeight),				// width & height of window
		    ParentWnd,								// parent window 
		    NULL,									// no menu
		    appInstance,								// hInstance of DLL
		    NULL);									// no window creation data

	SetWindowLong(hMainWnd, GWL_USERDATA, magicDWord);

	//create the message id's that popup.dll will use
	int Msgs[10];
	Msgs[0] = 9182;
	Msgs[1] = 9183;
	Msgs[2] = 0;
	SendMessage (ParentWnd, 9263, (WPARAM)hMainWnd, (LPARAM)Msgs);

	return 0;
}


// window procedure for our window
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int counter = 20;
	POINT pt; RECT r;
	int previousCounter = 20;
	//yy = HIWORD(lParam); 
	int y = HIWORD(lParam); 
	WORD fActive;
	HWND hwndGetFocus;
	int p;
	
	menuItem *temp3 = NULL;
	int counter3 = 40;
	int previousCounter3 = 20;
	//makes a temp pointer to the root of our popup tree, 
	menuItem *item = popup.root;

	switch (message)
	{


	case 9182:
	case WM_PAINT:
	displayPopup(hwnd);
		return 0;

	case WM_LBUTTONDOWN:
		GetCursorPos(&pt);
		GetCursorPos(&pt);
		GetWindowRect(hwnd, &r);
		pt.x -= r.left;
		pt.y -= r.top;
		
		
		while(item != NULL)
		{
			counter = counter + item->height;
			
			if(pt.y > 20 && pt.y < counter)
			{
				char temp[256];
				if(item->SMenu == NULL)
				{
					strcpy(temp, item->command);

					destroyAllSubMenus();
					
					if(item->command[0] != '!')
					{
						SHELLEXECUTEINFO si;
						memset(&si, 0, sizeof(si));
						si.cbSize = sizeof(SHELLEXECUTEINFO);
						si.lpDirectory = NULL;
						si.lpVerb = NULL;
						si.nShow = 1;
						si.fMask = SEE_MASK_DOENVSUBST;
						si.lpFile = item->command;
						si.lpParameters = item->params;
						ShellExecuteEx(&si);

					}
					
					else
						ParseBangCommand (hwnd, item->command, item->params);
					
					previousItem = NULL;
					previousCounter2 =0;
					counter2 = 0;
					isMainWindowHidden = TRUE;
					ShowWindow(hwnd, SW_HIDE );

					break;
				}
					
				else if(item->SMenu != subList[subEnum].subMenu)
				{
					if(subEnum > 0)
						destroyAllSubMenus();
					
					else
					{
						goingToSubMenu = TRUE;
						displaySubMenu(hwnd,item, counter);
					}
					
					break;
				}
				break;
			}
			item = item->next;
		}
	
		break;		

	
	case WM_TIMER:
		
		if(timerPointer == NULL)
			break;
		if(timerPointer->SMenu->root->itemLevel == 1 && 
			timerPointer->SMenu != subList[subEnum].subMenu)
		{
			destroyAllSubMenus();
			displaySubMenu(hwnd, timerPointer, timerHeight);
			timerPointer = NULL;
			KillTimer(hwnd, 0);
		}

		break;
	case WM_MOUSEMOVE:

			if(y < 20 || previousItem == NULL);
			
			else if(y < previousCounter2 || y > counter2 || previousItem->itemLevel > 0)
			{
				if(previousItem != popup.isSelected && previousItem->itemLevel > 0)
				{
					temp3 = popup.root;
					while(temp3 != popup.isSelected)
					{
						counter3 = counter3 + temp3->height;
						previousCounter3 = previousCounter3 + temp3->height;
						temp3 = temp3->next;
					}
				
				}
				
				else
				{
					temp3 = previousItem;
					previousCounter3 = previousCounter2;
				}


				displaySingleMenuItem(hwnd, temp3, previousCounter3, FALSE);			


				timerPointer = NULL;
			}

		
		while(item != NULL)
		{
			counter = counter + item->height;

	
		
			if(y < 20);
			else if(y > previousCounter && y < counter)
			{

				if(previousItem == NULL);
				else if(subEnum != 0 && previousItem->SMenu != subList[subEnum].subMenu)
					destroyAllSubMenus();

				displaySingleMenuItem(hwnd, item, previousCounter, TRUE);			
				previousCounter2 = previousCounter;
				popup.isSelected = item;
				counter2 = counter;
				previousItem = item;

			}

			
			if(y > previousCounter && y < counter && item->SMenu != NULL && subList[subEnum].subMenu != item->SMenu)
			{
				if(timerPointer != item)
				{
					SetTimer(hwnd, 0, popup.subMenuDelay, NULL);
					timerPointer = item;
					timerHeight = counter;
					break;
				}
			}

			

			previousCounter = previousCounter + item->height;
			item = item->next;
		}
		break;
	
	//so you can move the window around, will implement more here later
	case WM_NCHITTEST:
		GetCursorPos(&pt);
		GetWindowRect(hwnd, &r);
		//pt.x -= r.left;
		pt.y -= r.top;
		
		if(pt.y < titleHeight)
		{

			if(previousItem == NULL);
			else if(previousItem->itemLevel == 0)
			{
				displaySingleMenuItem(hwnd, previousItem, previousCounter2, FALSE);			
				previousItem = NULL;
				timerPointer = NULL;

			}
			else
			{
					temp3 = popup.root;
					while(temp3 != popup.isSelected)
					{
						counter3 = counter3 + temp3->height;
						previousCounter3 = previousCounter3 + temp3->height;
						temp3 = temp3->next;
					}

				displaySingleMenuItem(hwnd, temp3, previousCounter3, FALSE);			
				previousItem = NULL;
				timerPointer = NULL;
		
				}
				
				destroyAllSubMenus();
				return (HTCAPTION);
		}
		
		else break;
	
	case WM_ACTIVATE:
		
		fActive = LOWORD(wParam);

		if(fActive == WA_INACTIVE)
		{
			hwndGetFocus = (HWND)lParam; // handle of window receiving focus 
			
			if(goingToSubMenu == TRUE)
				break;
			p = 1;
			do
			{
				if(subList[p].subMenuHwnd == hwndGetFocus && subList[p].subMenuHwnd !=NULL)
					return 0;
				p++;
			}while(p < (subEnum +1));
			previousItem = NULL;
			previousCounter2 =0;
			counter2 = 0;
			isMainWindowHidden = TRUE;
			timerPointer = NULL;
			ShowWindow(hwnd, SW_HIDE );
			destroyAllSubMenus();
			return 0;
		}
		break;	

	
	case WM_SYSCOMMAND:
		{
		switch (wParam)
			{
			case SC_CLOSE:
				PostMessage(parent,WM_KEYDOWN,8889,0);
				return 0;
			default:
				return DefWindowProc(hwnd,message,wParam,lParam);
			}
		}


	case WM_NCDESTROY:
	case WM_CLOSE:
	case WM_DESTROY:
	case WM_QUIT:
	case WM_ENDSESSION:
	case WM_QUERYENDSESSION:
		break;
		//		return SendMessage(parent,message,wParam,lParam);


/*	case WM_KEYDOWN:          

		//if (wParam != VK_LEFT && wParam != VK_RIGHT && wParam != VK_UP && wParam != VK_DOWN)         
		//	break; 
        
		if(previousItem == NULL && wParam == VK_DOWN)
		{

			displaySingleMenuItem(hwnd, popup.root, previousCounter, TRUE);
			previousCounter2 = previousCounter;
			popup.isSelected = popup.root;
			counter2 = counter;
			previousItem = popup.root;
			break;

		}
		
		else if(previousItem == NULL && wParam == VK_UP)
		{
			int totalHeight = 0;
			menuItem *temper = popup.root;

			while(temper != NULL)
			{
				totalHeight = totalHeight + temper->height;
				temper = temper->next;
			}

		
			displaySingleMenuItem(hwnd, popup.current, totalHeight, TRUE);			
			previousCounter2 = totalHeight;
			counter2 = totalHeight;
			previousItem = popup.current;
			break;

		}

		else if(wParam == VK_DOWN && popup.isSelected != NULL && popup.isSelected->next != NULL)
		{
			int totalHeight = 20;
			menuItem *temper = popup.root;

			while(temper != popup.isSelected->next)
			{
				totalHeight = totalHeight + temper->height;
				temper = temper->next;
			}
			displaySingleMenuItem(hwnd, popup.isSelected->next, totalHeight, TRUE);


			totalHeight = 20;
			temper = popup.root;
			while(temper != popup.isSelected)
			{
				totalHeight = totalHeight + temper->height;
				temper = temper->next;
			}
			displaySingleMenuItem(hwnd, popup.isSelected, totalHeight, FALSE);
			
			
			counter2 = counter;
			previousCounter2 = totalHeight + popup.isSelected->height;
			
			previousItem = popup.isSelected->next;
			popup.isSelected = popup.isSelected->next;
			break;

		}

		else if(wParam == VK_UP && popup.isSelected != popup.root)
		{
			int totalHeight = 20;
			menuItem *temper = popup.root;

			while(temper->next != popup.isSelected)
			{
				totalHeight = totalHeight + temper->height;
				temper = temper->next;
			}

			displaySingleMenuItem(hwnd, temper, totalHeight, TRUE);

			previousItem = temper;

			totalHeight = 20;
			temper = popup.root;
			while(temper != popup.isSelected)
			{
				totalHeight = totalHeight + temper->height;
				temper = temper->next;
			}
			displaySingleMenuItem(hwnd, popup.isSelected, totalHeight, FALSE);
			
			counter2 = counter;
			previousCounter2 = totalHeight - popup.isSelected->height;
			
			
			popup.isSelected = previousItem;
			break;

		}
		else if(wParam == VK_DOWN)
		{
			displaySingleMenuItem(hwnd, popup.root, 20, TRUE);

			int totalHeight = 20;
			menuItem *temper = popup.root;

			while(temper != popup.isSelected)
			{
				totalHeight = totalHeight + temper->height;
				temper = temper->next;
			}
			displaySingleMenuItem(hwnd, popup.current, totalHeight, FALSE);

			counter2 = counter;
			previousCounter2 = 20;
			
			previousItem = popup.root;
			popup.isSelected = popup.root;
			break;


		}
		else if(wParam == VK_UP)
		{

			int totalHeight = 20;
			menuItem *temper = popup.root;
			while(temper != popup.current)
			{
				totalHeight = totalHeight + temper->height;
				temper = temper->next;
			}

			displaySingleMenuItem(hwnd, popup.current	, totalHeight, TRUE);
			displaySingleMenuItem(hwnd, popup.root, 20, FALSE);

			counter2 = counter;
			previousCounter2 = totalHeight;
			
			previousItem = popup.current;
			popup.isSelected = popup.current;


			break;
		}
		else if(wParam == VK_RETURN && previousItem != NULL && previousItem->itemLevel == 0)
		{
					
			if(previousItem->SMenu == NULL)
			{
				char temp[256];
				strcpy(temp, previousItem->command);

				destroyAllSubMenus();
				
				if(previousItem->command[0] != '!')
				{
					SHELLEXECUTEINFO si;
					memset(&si, 0, sizeof(si));
					si.cbSize = sizeof(SHELLEXECUTEINFO);
					si.lpDirectory = NULL;
					si.lpVerb = NULL;
					si.nShow = 1;
					si.fMask = SEE_MASK_DOENVSUBST;
					si.lpFile = previousItem->command;
					si.lpParameters = previousItem->params;
					ShellExecuteEx(&si);

				}
				
				else
					ParseBangCommand (hwnd, previousItem->command, previousItem->params);
				
				previousItem = NULL;
				previousCounter2 =0;
				counter2 = 0;
				isMainWindowHidden = TRUE;
				ShowWindow(hwnd, SW_HIDE );

				break;
			}
			break;

		}
		

		else if(wParam == VK_RIGHT && previousItem->SMenu != NULL && 
			previousItem != NULL && previousItem->itemLevel == 0 && item->SMenu != subList[subEnum].subMenu)
		{
					if(subEnum > 0)
						destroyAllSubMenus();
					
					else
					{
						int totalHeight = 20+popup.root->height;
						menuItem *temper = popup.root;
						while(temper != previousItem)
						{
							totalHeight = totalHeight + temper->height;
							temper = temper->next;
						}
						
						goingToSubMenu = TRUE;
						displaySubMenu(hwnd,previousItem, totalHeight);//totalHeight);
					}
					
				break;

		}

			
			
			
			
			
			
		break; 

  */
	}
	return DefWindowProc(hwnd, message, wParam, lParam);

}


void displaySingleMenuItem(HWND hwnd, menuItem *item, int totalHeight, BOOL selected)
{
	HDC DC, memDC;
    PAINTSTRUCT ps;
	HFONT oldFont;
	HPEN hPen, oldPen;
	RECT r;

	if(selected)
	{
		DC = BeginPaint(hwnd,&ps);
		memDC = CreateCompatibleDC(DC);

		DC = GetDC(hwnd);
		SetTextColor(DC,  selColor);
		SetBkMode(DC, TRANSPARENT);
		oldFont = (HFONT) SelectObject(DC, popupFont);
		SelectObject(memDC, popup.selectBMP.bitmap);
		
		BitBlt(DC,0,totalHeight, popup.selectBMP.x, popup.selectBMP.y, memDC, 0, 0,SRCCOPY);
		r.left = 3;
		r.right = popup.selectBMP.x-3;
		r.top= totalHeight;
		r.bottom = totalHeight + popup.selectBMP.y;
		DrawText(DC, item->name, lstrlen(item->name), &r, DT_END_ELLIPSIS | DT_VCENTER | DT_SINGLELINE);
//		TextOut(DC, 0,totalHeight,  item->name, strlen(item->name));

		if (!noPopupBevel)
		{
			// First we draw the white frame on the left/top
			hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, 0, totalHeight, NULL);
			LineTo(DC, popup.menuWidth, totalHeight);
			MoveToEx(DC, 0, totalHeight, NULL);
			LineTo(DC, 0, totalHeight+item->height-1);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);

			// Now the black frame on the bottom/right
			hPen = CreatePen(PS_SOLID, 1, RGB(0,0,0));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, popup.menuWidth-1, totalHeight, NULL);
			LineTo(DC, popup.menuWidth-1, totalHeight+item->height-1);
			MoveToEx(DC, 0, totalHeight+item->height-1, NULL);
			LineTo(DC, popup.menuWidth-1, totalHeight+item->height-1);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);
		}

		// Paint little folder arrow thingy
		if (item->SMenu != NULL)
		{
			// First 2 lines are dark gray
			hPen = CreatePen(PS_SOLID, 1, RGB(0x40,0x40,0x40));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, popup.menuWidth-12, totalHeight+item->height-5, NULL);
			LineTo(DC, popup.menuWidth-12, totalHeight+4);
			LineTo(DC, popup.menuWidth-5, totalHeight+(item->height/2));
			SelectObject(DC, oldPen);
			DeleteObject(hPen);

			// Finish it off with a white line
			hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
			oldPen = (HPEN) SelectObject(DC, hPen);
			LineTo(DC, popup.menuWidth-12, totalHeight+item->height-5);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);
		}

		SelectObject(DC, oldFont);
		ReleaseDC(hwnd, DC);
		EndPaint(hwnd,&ps);	
		DeleteDC(memDC);
	}

	else
	{
		DC = BeginPaint(hwnd,&ps);
		memDC = CreateCompatibleDC(DC);

		DC = GetDC(hwnd);
		SetTextColor(DC,  normColor);
		SetBkMode(DC, TRANSPARENT);
		oldFont = (HFONT) SelectObject(DC, popupFont);
		SelectObject(memDC, popup.backBMP.bitmap);
		
		BitBlt(DC,0,totalHeight, popup.backBMP.x, popup.backBMP.y, memDC, 0, 0,SRCCOPY);
		r.left = 3;
		r.right = popup.backBMP.x-3;
		r.top= totalHeight;
		r.bottom = totalHeight + popup.backBMP.y;
		DrawText(DC, item->name, lstrlen(item->name), &r, DT_END_ELLIPSIS | DT_VCENTER | DT_SINGLELINE);
//		TextOut(DC, 0,totalHeight,  item->name, strlen(item->name));
		
		if (!noPopupBevel)
		{
			// First we draw the white frame on the left/top
			hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, 0, totalHeight, NULL);
			LineTo(DC, popup.menuWidth, totalHeight);
			MoveToEx(DC, 0, totalHeight, NULL);
			LineTo(DC, 0, totalHeight+item->height-1);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);

			// Now the black frame on the bottom/right
			hPen = CreatePen(PS_SOLID, 1, RGB(0,0,0));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, popup.menuWidth-1, totalHeight, NULL);
			LineTo(DC, popup.menuWidth-1, totalHeight+item->height-1);
			MoveToEx(DC, 0, totalHeight+item->height-1, NULL);
			LineTo(DC, popup.menuWidth-1, totalHeight+item->height-1);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);
		}

		// Paint little folder arrow thingy
		if (item->SMenu != NULL)
		{
			// First 2 lines are dark gray
			hPen = CreatePen(PS_SOLID, 1, RGB(0x40,0x40,0x40));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, popup.menuWidth-12, totalHeight+item->height-5, NULL);
			LineTo(DC, popup.menuWidth-12, totalHeight+4);
			LineTo(DC, popup.menuWidth-5, totalHeight+(item->height/2));
			SelectObject(DC, oldPen);
			DeleteObject(hPen);

			// Finish it off with a white line
			hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
			oldPen = (HPEN) SelectObject(DC, hPen);
			LineTo(DC, popup.menuWidth-12, totalHeight+item->height-5);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);
		}

		SelectObject(DC, oldFont);
		ReleaseDC(hwnd, DC);
		EndPaint(hwnd,&ps);	
		DeleteDC(memDC);

	}

}


void subFolderInit(menuItem *target, fileItem *item)
{
	subMenu *subMenuItem;
	target->SMenu = new subMenu;
	subMenuItem = target->SMenu;
	popupLevel++;

	item = item->next;
	while(item != NULL)
	{
		if(!stricmp(item->popupCommand, "~folder"))
			break;
		
		subMenuItem->newMenuItem();
		strcpy(subMenuItem->current->name, item->itemName);
		strcpy(subMenuItem->current->command, item->popupCommand);
		strcpy(subMenuItem->current->bmp, item->bmpName);
		strcpy(subMenuItem->current->params, item->commandParam);
		subMenuItem->current->height = item->itemHeight;
		subMenuItem->current->itemLevel = popupLevel;	

		item = item->next;

	}
	popupLevel--;

	menuItem *temper = subMenuItem->root;
	int totalHeight = 0;
	while(temper != NULL)
	{
		totalHeight = totalHeight + temper->height;
		temper = temper->next;
	}

	subMenuItem->totalHeight = totalHeight;

}


void initializePopupMenu() 
{
	FILE *f = NULL;
	char	buffer[4096];
	char	token1[4096], token2[4096], token3[4096], token4[4096], token5[4096], extra_text[4096];
	char*	tokens[5];
	fileItem * item = popupFile;
	
	GetRCString("HotListName", popup.menuName, "", 256);
	GetRCString("PopupTitlePix", popup.titleBarBMP	, "", 256);
	GetRCString("PopupEntryPix", popup.backgroundBMP	, "", 256);
	GetRCString("PopupSelEntryPix", popup.selectedBMP	, "", 256);
	GetRCString("PopupFontFace", popupFontFace, "Arial", 256);

	noPopupBevel = GetRCBool("NoPopupBevel", TRUE);
	popupFontHeight = GetRCInt("PopupFontHeight", 16);
	titleColor = GetRCColor("PopupTitleColor", 0xffffff);
	normColor = GetRCColor("PopupEntryColor", 0xffffff);
	selColor = GetRCColor("PopupSelEntryColor", 0x000000);
	popup.subMenuDelay = GetRCInt("PopupMenuDelay",0);
	popup.menuWidth = GetRCInt("minpopupwidth", 100);
	popupSubHeight = GetRCInt("PopupSubmenuHeight", 20);

	
	popupFile = new fileItem;
	item = popupFile;

	
	tokens[0] = token1;
	tokens[1] = token2;
	tokens[2] = token3;
	tokens[3] = token4;
	tokens[4] = token5;

	buffer[0] = 0;
	f = LCOpen (NULL);
	int keeper = 0;
	
	while (LCReadNextConfig (f, "*popup", buffer, sizeof (buffer)))
	{
 		int count = 0, count2 = 0;
		char truly_extra_text[4096];
		if(keeper == 0)
			keeper = 1;
		else
		{
			item->next = new fileItem;
			item = item->next;
		}

		token1[0] = token2[0] = token3[0] = token4[0] = token5[0] = extra_text[0] = truly_extra_text[0] = '\0';

		count = LCTokenize (buffer, tokens, 3, extra_text);
		
		switch (count)
		{
		case 3:											// *Popup
			strcpy(item->itemName, token2);				// "Name"
			if (atoi(token3))
			{
				item->itemHeight = atoi(token3);			// Height
				count2 = LCTokenize(extra_text, tokens, 2, truly_extra_text);
				strcpy(item->bmpName, token1);				// Bitmap.bmp
				strcpy(item->popupCommand, token2);			// Command.exe
				strcpy(item->commandParam, truly_extra_text);		// -command_params
			}
			else
			{
				item->itemHeight = popupSubHeight;
				strcpy(item->bmpName, popup.backgroundBMP);
				if (!stricmp(token3, "Folder"))
				{
					strcpy(item->popupCommand, "!Folder");
				}
				else
				{
					strcpy(item->popupCommand, token3);
				}
				strcpy(item->commandParam, extra_text);
			}
			break;

		case 2:
			strcpy(item->popupCommand, token2);
		}
				
	}		

	
	//copys the popupFile structure into our popup strucure
	//in later revisions error checking will go here
	
	LCClose(f);


	item = popupFile;
	while(item != NULL)
	{
		if(!stricmp(item->popupCommand, "~folder"))
			item = item->next;
		if(item == NULL)
			break;
		
		popup.newMenuItem();
		strcpy(popup.current->name, item->itemName);
		strcpy(popup.current->command, item->popupCommand);
		strcpy(popup.current->bmp, item->bmpName);
		strcpy(popup.current->params, item->commandParam);
		popup.current->height = item->itemHeight;
		popup.current->itemLevel = popupLevel;	
		
		if(!strncmp(popup.current->command, "!PopupFolder", 12))
		{
			char temp[MAX_PATH];
			strcpy(temp, popup.current->command+13);
			popupLevel++;
			fillDirectory(temp, popup.current);
			popupLevel--;
		}
		
		else if(!stricmp(popup.current->command, "!Folder"))
		{
			subFolderInit(popup.current, item);
			while(stricmp(item->next->popupCommand, "~folder") && item != NULL)
				item = item->next;
			if(item == NULL)
				break;
		}

		
		item = item->next;
	}
		
		

	
	menuItem *temper = popup.root;
	int totalHeight = 0;
	while(temper != NULL)
	{
		totalHeight = totalHeight + temper->height;
		temper = temper->next;
	}

	popup.totalHeight = totalHeight;

	//loads up images i will eventualy seperate this into its own function
	popup.backBMP.bitmap = LoadLSImage(popup.backgroundBMP, NULL);
	popup.titleBMP.bitmap = LoadLSImage(popup.titleBarBMP, NULL);
	popup.selectBMP.bitmap = LoadLSImage(popup.selectedBMP, NULL);
	
	GetBitmapSize(popup.selectBMP.bitmap, &popup.selectBMP.x, &popup.selectBMP.y);
	GetBitmapSize(popup.backBMP.bitmap, &popup.backBMP.x, &popup.backBMP.y);
	GetBitmapSize(popup.titleBMP.bitmap, &popup.titleBMP.x, &popup.titleBMP.y);

	popupFont = CreateFont(
			popupFontHeight,
			0,
			0,
			0,
			FW_NORMAL,
			FALSE,
			FALSE,
			FALSE,
			DEFAULT_CHARSET,
			OUT_DEFAULT_PRECIS,
			CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY,
			DEFAULT_PITCH,
			popupFontFace);
}



void displayPopup(HWND hwnd)
{
	HDC DC, memDC;
    PAINTSTRUCT ps;
	HFONT oldFont;
	RECT r;
	
	DC = BeginPaint(hwnd,&ps);
	memDC = CreateCompatibleDC(DC);
	isMainWindowHidden = FALSE;
	
	
	SetTextColor(DC,  RGB(255,255,255));
	SetBkMode(DC, TRANSPARENT);
	oldFont = (HFONT) SelectObject(DC, popupFont);
	//blits out title info
	SelectObject(memDC, popup.titleBMP.bitmap);
	TransparentBltLS(DC,0,0, popup.titleBMP.x, popup.titleBMP.y, memDC, 0, 0,RGB(255,0,255));
	//BitBlt(DC,0,0, popup.titleBMP.x, popup.titleBMP.y, memDC, 0, 0,SRCCOPY);

	r.left = 3;
	r.right = popup.titleBMP.x-3;
	r.top= 0;
	r.bottom = popup.titleBMP.y;
	DrawText(DC, popup.menuName, lstrlen(popup.menuName), &r, DT_END_ELLIPSIS | DT_VCENTER | DT_SINGLELINE);
//	TextOut(DC, 0,0,  popup.menuName, strlen(popup.menuName));
	SelectObject(DC, oldFont);
	ReleaseDC(hwnd, DC);
	
	
	GetCursorPos(&pt);
	
	//creates a list hopper to retrive popup info
	menuItem *item = popup.root;
	
	int totalHeight = titleHeight;
	
	//blits out each menu item, in order that they where entered into the RC
	while(item != NULL)
	{
		HPEN hPen, oldPen;

		DC = GetDC(hwnd);
		SetTextColor(DC,  normColor);
		SetBkMode(DC, TRANSPARENT);
		oldFont = (HFONT) SelectObject(DC, popupFont);
		SelectObject(memDC, popup.backBMP.bitmap);
	
		//not implemented yet
		//TransparentBltLS( DC, 0,totalHeight, popup.backBMP.x, popup.backBMP.y, memDC, 0, 0,RGB(255,0,255));
	
		
		BitBlt(DC,0,totalHeight, popup.backBMP.x, popup.backBMP.y, memDC, 0, 0,SRCCOPY);
		r.left = 3;
		r.right = popup.backBMP.x-3;
		r.top= totalHeight;
		r.bottom = totalHeight + popup.backBMP.y;
		DrawText(DC, item->name, lstrlen(item->name), &r, DT_END_ELLIPSIS | DT_VCENTER | DT_SINGLELINE);
//		TextOut(DC, 0,totalHeight,  item->name, strlen(item->name));

		if (!noPopupBevel)
		{
			// First we draw the white frame on the left/top
			hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, 0, totalHeight, NULL);
			LineTo(DC, popup.menuWidth, totalHeight);
			MoveToEx(DC, 0, totalHeight, NULL);
			LineTo(DC, 0, totalHeight+item->height-1);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);

			// Now the black frame on the bottom/right
			hPen = CreatePen(PS_SOLID, 1, RGB(0,0,0));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, popup.menuWidth-1, totalHeight, NULL);
			LineTo(DC, popup.menuWidth-1, totalHeight+item->height-1);
			MoveToEx(DC, 0, totalHeight+item->height-1, NULL);
			LineTo(DC, popup.menuWidth-1, totalHeight+item->height-1);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);
		}

		// Paint little folder arrow thingy
		if (item->SMenu != NULL)
		{
			// First 2 lines are dark gray
			hPen = CreatePen(PS_SOLID, 1, RGB(0x40,0x40,0x40));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, popup.menuWidth-12, totalHeight+item->height-5, NULL);
			LineTo(DC, popup.menuWidth-12, totalHeight+4);
			LineTo(DC, popup.menuWidth-5, totalHeight+(item->height/2));
			SelectObject(DC, oldPen);
			DeleteObject(hPen);

			// Finish it off with a white line
			hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
			oldPen = (HPEN) SelectObject(DC, hPen);
			LineTo(DC, popup.menuWidth-12, totalHeight+item->height-5);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);
		}

		ReleaseDC(hwnd, DC);
		totalHeight = totalHeight + item->height;
		item = item->next;
	}
	SelectObject(DC, oldFont);
	EndPaint(hwnd,&ps);	

	//displays the window
	if (pt.x + popup.menuWidth > GetSystemMetrics(SM_CXSCREEN))
		pt.x -= popup.menuWidth;

	if ((pt.y + popup.totalHeight + titleHeight) > GetSystemMetrics(SM_CYSCREEN))
		pt.y = GetSystemMetrics(SM_CYSCREEN) - (popup.totalHeight + titleHeight);


	SetWindowPos(hwnd, HWND_TOP, pt.x, pt.y, popup.menuWidth,(popup.totalHeight + titleHeight), 
		SWP_SHOWWINDOW);
	
	DeleteDC(memDC);
	int sdaf =123;
}

int fillDirectorySortFunc(const void *a, const void *b)
{
	WIN32_FIND_DATA *f1 = (WIN32_FIND_DATA *)a;
	WIN32_FIND_DATA *f2 = (WIN32_FIND_DATA *)b;

	if (f1->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	{
		if (f2->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			return stricmp(f1->cFileName, f2->cFileName);
		else
			return -1;
	}
	if (f2->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		return 1;

	return stricmp(f1->cFileName, f2->cFileName);
}

//parses a directory and fills the popup data structure with the results
int fillDirectory(char *dirName, menuItem *target)
{
	int l=0;	
	int j, k, still=1;

	WIN32_FIND_DATA fd;
	HANDLE h;
	char temp2[MAX_PATH];
	strcpy(temp2, dirName);
	strcat(temp2, "\\*");
	h = FindFirstFile(temp2, &fd);
	if (h == INVALID_HANDLE_VALUE)
		return 1;
	
	target->SMenu = new subMenu;
	
	
	
	menuItem *walker = target;
	WIN32_FIND_DATA fileTable[255];
	
	for (j=0;j<255 && still;j++)
	{
		fileTable[j] = fd;
		still = FindNextFile(h, &fd);
	}

	qsort((void *)fileTable, j, sizeof(WIN32_FIND_DATA), fillDirectorySortFunc);

	for (k=j,j=0;l<255 && j<k;l++,j++)
   	{
	    if (fileTable[j].dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
    	{
			if (!strcmp(fileTable[j].cFileName, ".") || !strcmp(fileTable[j].cFileName, ".."))
       		{
        		l--;
			}
			else
			{
				char t[MAX_PATH];
				walker->SMenu->newMenuItem();// = new menuItem;
				strcpy(walker->SMenu->current->name, fileTable[j].cFileName);
				strcpy(t, dirName);
				strcat(t, "\\");
				strcat(t, fileTable[j].cFileName);
				walker->SMenu->current->height = popupSubHeight;
				walker->SMenu->current->itemLevel = popupLevel;
				popupLevel++;
				int temp2 = fillDirectory(t, walker->SMenu->current);
				if(temp2)
				{
					delete walker->SMenu->current->SMenu;
					walker->SMenu->current->SMenu = NULL;
					strcpy(walker->SMenu->current->command, t);
				}

				popupLevel--;
			}
		}
		else
		{
			char temp[5];
			
			//strcpy(temp2, "\"");
			strcpy(temp2, "");
	 		strcat(temp2, dirName);
			strcat(temp2, "\\");
			strcat(temp2, fileTable[j].cFileName);
			//strcat(temp2, "\"");
   			
			walker->SMenu->newMenuItem();			
			strcpy(walker->SMenu->current->command,temp2);
			
			strcpy(temp, fileTable[j].cFileName +(strlen(fileTable[j].cFileName) -4));
			

			//stripping unwanted extentions from the name
			if(!strcmp(temp, ".lnk") || !strcmp(temp, ".exe") || !strcmp(temp, ".pif") || !strcmp(temp, ".com"))
			{
				strncpy(walker->SMenu->current->name, fileTable[j].cFileName, 
					strlen(fileTable[j].cFileName) -4);
				walker->SMenu->current->name[strlen(fileTable[j].cFileName) -4] = '\0';
			}
			
			else strcpy(walker->SMenu->current->name, fileTable[j].cFileName);
			
			
			walker->SMenu->current->height = popupSubHeight;
			walker->SMenu->current->itemLevel = popupLevel;
		}

	}
	FindClose(h);
	menuItem *counter = target->SMenu->root;
	target->SMenu->totalHeight = 0;
	while(counter != NULL)
	{
		target->SMenu->totalHeight = counter->height + target->SMenu->totalHeight;
		counter = counter->next;
	}
	
	if(target->SMenu->root == NULL)
		return 1;
	return 0;


}

void displaySubMenu(HWND calledFrom, menuItem *firstItem, int height)
{
	HFONT oldFont;
	RECT lpRect;
	RECT r;

	if(isMainWindowHidden == TRUE)
		return;
	GetWindowRect(calledFrom, &lpRect);
	subEnum++;

	if (lpRect.right + popup.menuWidth > GetSystemMetrics(SM_CXSCREEN)) //||
		//lpRect.right + popup.menuWidth * subEnum > GetSystemMetrics(SM_CXSCREEN))
		lpRect.right -= popup.menuWidth * 2;

	if (firstItem->SMenu->totalHeight+(lpRect.top+(height-20)) > GetSystemMetrics(SM_CYSCREEN))
		lpRect.top = GetSystemMetrics(SM_CYSCREEN) - (firstItem->SMenu->totalHeight +(height- 20));

	subList[subEnum].subMenuHwnd = CreateWindowEx(
    		WS_EX_TOPMOST|WS_EX_TOOLWINDOW,//WS_EX_TRANSPARENT,										// exstyles 
		    popupSubName,								// our window class name
		    "",											// use description for a window title
		    WS_POPUP,				
		    lpRect.right, (lpRect.top+(height-20)), 							// position 
		    popup.menuWidth,(firstItem->SMenu->totalHeight),	// width & height of window
		    hMainWnd,								// parent window 
		    NULL,									// no menu
		    appInstance,								// hInstance of DLL
		    NULL);									// no window creation data
	
	SetWindowLong(subList[subEnum].subMenuHwnd, GWL_USERDATA, magicDWord);

	subList[subEnum].subMenu = firstItem->SMenu;
	subList[subEnum].subMenu->isSubOpen = TRUE;
	BOOL temp2 = SetWindowPos(subList[subEnum].subMenuHwnd, HWND_TOP, lpRect.right, (lpRect.top+(height-20)), 
	popup.menuWidth,(firstItem->SMenu->totalHeight),
	SWP_SHOWWINDOW);
	
	HDC DC, memDC;
    PAINTSTRUCT ps;
	
	DC = BeginPaint(subList[subEnum].subMenuHwnd,&ps);
	memDC = CreateCompatibleDC(DC);
	
	//creates a list hopper to retrive popup info
	menuItem *item = firstItem->SMenu->root;
	
	int totalHeight = 0;
	
	//blits out each menu item, in order that they where entered into the RC
	while(item != NULL)
	{
		HPEN hPen, oldPen;

		DC = GetDC(subList[subEnum].subMenuHwnd);
		SetTextColor(DC,  normColor);
		SetBkMode(DC, TRANSPARENT);
		oldFont = (HFONT) SelectObject(DC, popupFont);
		SelectObject(memDC, popup.backBMP.bitmap);
		
		//not implemented yet
		//TransparentBltLS( DC, 0, totalHeight, popup.backBMP.x, popup.backBMP.y, memDC, 0, 0, 
	//	RGB(255,0,255)) ;
	
		BitBlt(DC,0,totalHeight, popup.backBMP.x, popup.backBMP.y, memDC, 0, 0,SRCCOPY);
		r.left = 3;
		r.right = popup.backBMP.x-3;
		r.top= totalHeight;
		r.bottom = totalHeight + popup.backBMP.y;
		DrawText(DC, item->name, lstrlen(item->name), &r, DT_END_ELLIPSIS | DT_VCENTER | DT_SINGLELINE);
//		TextOut(DC, 0,totalHeight,  item->name, strlen(item->name));

		if (!noPopupBevel)
		{
			// First we draw the white frame on the left/top
			hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, 0, totalHeight, NULL);
			LineTo(DC, popup.menuWidth, totalHeight);
			MoveToEx(DC, 0, totalHeight, NULL);
			LineTo(DC, 0, totalHeight+item->height-1);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);

			// Now the black frame on the bottom/right
			hPen = CreatePen(PS_SOLID, 1, RGB(0,0,0));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, popup.menuWidth-1, totalHeight, NULL);
			LineTo(DC, popup.menuWidth-1, totalHeight+item->height-1);
			MoveToEx(DC, 0, totalHeight+item->height-1, NULL);
			LineTo(DC, popup.menuWidth-1, totalHeight+item->height-1);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);
		}

		// Paint little folder arrow thingy
		if (item->SMenu != NULL)
		{
			// First 2 lines are dark gray
			hPen = CreatePen(PS_SOLID, 1, RGB(0x40,0x40,0x40));
			oldPen = (HPEN) SelectObject(DC, hPen);
			MoveToEx(DC, popup.menuWidth-12, totalHeight+item->height-5, NULL);
			LineTo(DC, popup.menuWidth-12, totalHeight+4);
			LineTo(DC, popup.menuWidth-5, totalHeight+(item->height/2));
			SelectObject(DC, oldPen);
			DeleteObject(hPen);

			// Finish it off with a white line
			hPen = CreatePen(PS_SOLID, 1, RGB(255,255,255));
			oldPen = (HPEN) SelectObject(DC, hPen);
			LineTo(DC, popup.menuWidth-12, totalHeight+item->height-5);
			SelectObject(DC, oldPen);
			DeleteObject(hPen);
		}

		ReleaseDC(subList[subEnum].subMenuHwnd, DC);
		totalHeight = totalHeight + item->height;
		item = item->next;
	}
	SelectObject(DC, oldFont);
	EndPaint(subList[subEnum].subMenuHwnd,&ps);	

	//displays the window
	DeleteDC(memDC);
	goingToSubMenu = FALSE;
}


void closePopupSubMenu(HWND subMenu)
{
	DestroyWindow(subMenu);
}	

// window procedure for our window
LRESULT CALLBACK PopupWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int counter = 0;
	int counter22 = popupSubHeight;
	int previousCounter = 0;
	BOOL setFlag = FALSE;
	RECT r;
	HWND hwndGetFocus;
	int p;
	int tempEnum = 1;
	int tempEnum2 = 0;
	menuItem *item;
	menuItem *temp3;
	int goingTo = 1;
	//subMenu *goingTo = NULL;
	int y = HIWORD(lParam); 
	int x = LOWORD(lParam); 
	WORD fActive;
	int counter3 = popupSubHeight;
	int previousCounter3 = 0;

	while(hwnd != subList[tempEnum].subMenuHwnd)
	{
		tempEnum++;
		if(tempEnum > subEnum)
			break;
	}
	
	switch (message)
	{


	case WM_TIMER:
		KillTimer(hwnd, 1);
		if(timerPointer == NULL)
			break;

		if(timerPointer->SMenu != subList[subEnum].subMenu && timerPointer != NULL && hwnd == itemCaller)
		{

			
			static int tempertemper = 0;
			tempertemper++;
			if(tempertemper > 1)
				tempertemper = 0;
			while(timerPointer->itemLevel < subList[subEnum].subMenu->root->itemLevel)
				destroyCurrentSubMenu();
			goingToSubMenu = TRUE;
			displaySubMenu(hwnd, timerPointer, timerHeight);
			timerPointer = NULL;			
		}

		break;
	case WM_MOUSEMOVE:

		item = subList[subEnum].subMenu->root;
		if(tempEnum < subEnum)
			item = subList[tempEnum].subMenu->root;

		
		while(item != NULL)
		{
			
			GetCursorPos(&pt);
			GetWindowRect(hwnd, &r);
			pt.x -= r.left;

			if(subList[tempEnum].subMenu->root->itemLevel > previousItem->itemLevel && setFlag == FALSE)
			{
				timerPointer = NULL;	
				setFlag = TRUE;
				KillTimer(hwnd, 1);
			}

			if(subList[tempEnum].subMenu->root->itemLevel < previousItem->itemLevel 
				&& 
				previousItem->itemLevel > 0 && setFlag == FALSE)
			{
				//while(subList[subEnum].subMenu->root->itemLevel != subList[tempEnum].subMenu->isSelected->itemLevel)
				//	destroyCurrentSubMenu();
				KillTimer(hwnd, 1);

				while(subList[subEnum].subMenu->root->itemLevel != subList[tempEnum].subMenu->root->itemLevel)
					destroyCurrentSubMenu();
				
				temp3 =	subList[tempEnum].subMenu->isSelected;
				menuItem *tempPointer = subList[tempEnum].subMenu->root;
				while(tempPointer != temp3)
				{
					previousCounter3 = previousCounter3 + tempPointer->height;
					tempPointer = tempPointer->next;
				}
								
				displaySingleMenuItem(hwnd, temp3, previousCounter3, FALSE);
				setFlag = TRUE;
				timerPointer = NULL;
			}
			
			else if(y < previousCounter2 || y > counter2 || pt.x < 0 || pt.x > popup.menuWidth)
			{
				KillTimer(hwnd, 1);

				
				
				if(previousItem->itemLevel != 0 && setFlag == FALSE)
				{
					while(subList[subEnum].subMenu->root->itemLevel != subList[tempEnum].subMenu->root->itemLevel)
						destroyCurrentSubMenu();

					temp3 = previousItem;
					previousCounter3 = previousCounter2;
				
					displaySingleMenuItem(hwnd, temp3, previousCounter3, FALSE);
					setFlag = TRUE;
					timerPointer = NULL;
				}
				
				
			}
			
			if(y > previousCounter && y < counter22)
			{
				
				displaySingleMenuItem(hwnd, item, previousCounter, TRUE);
				previousCounter2 = previousCounter;
				counter2 = counter22;
				previousItem = item;
			
			}
			
			if(y > previousCounter && y < counter22 && item->SMenu != NULL && item != timerPointer 
				&& item->SMenu != subList[subEnum].subMenu && subList[tempEnum+1].subMenu != item->SMenu)
			{
				if(timerPointer != item)
				{
					subList[tempEnum].subMenu->isSelected = item;
					SetTimer(hwnd, 1, popup.subMenuDelay, NULL);
					timerPointer = item;
					itemCaller = hwnd;
					timerHeight = counter22;
					previousCounter2 = previousCounter;

					counter2 = counter22;
					break;
					}

			}
			counter22 = counter22 + item->height;
			previousCounter = previousCounter + item->height;
			item = item->next;
		}
		break;

	
	
	
	
	case WM_ACTIVATE:
		
		fActive = LOWORD(wParam);

		if(fActive == WA_INACTIVE)
		{
			hwndGetFocus = (HWND)lParam; // handle of window receiving focus 
			
			if(goingToSubMenu == TRUE || hwndGetFocus == hMainWnd)
				break;
			p = 1;
			do
			{
				if(subList[p].subMenuHwnd == hwndGetFocus)
					return 0;
				p++;
			}while(p < (subEnum +1));
			previousItem = NULL;
			previousCounter2 =0;
			counter2 = 0;
			isMainWindowHidden = TRUE;
			ShowWindow(hMainWnd, SW_HIDE );
			destroyAllSubMenus();
			return 0;
		}
		break;	
	

	case WM_LBUTTONDOWN:
		GetCursorPos(&pt);
		GetWindowRect(hwnd, &r);
		pt.x -= r.left;
		pt.y -= r.top;
		
		item = subList[subEnum].subMenu->root;

		tempEnum2 = 0;
		if(tempEnum < subEnum)
		{
			tempEnum2 = subEnum;
			item = subList[tempEnum].subMenu->root;
			while(tempEnum2 > tempEnum)
			{
				destroyCurrentSubMenu();
				tempEnum2--;
			}


		}

		

		while(item != NULL)
		{
			counter = counter + item->height;
			
			if(pt.y > 0 && pt.y < counter && pt.x > 0 && pt.x < r.right&& hwnd == subList[subEnum].subMenuHwnd)
			{
//				char temp[256];
	
				if(item->SMenu == NULL )
				{
					if(item->command[0] != '!')
					{
						SHELLEXECUTEINFO si;
						memset(&si, 0, sizeof(si));
						si.cbSize = sizeof(SHELLEXECUTEINFO);
						si.lpDirectory = NULL;
						si.lpVerb = NULL;
						si.nShow = 1;
						si.fMask = SEE_MASK_DOENVSUBST;
						si.lpFile = item->command;
						si.lpParameters = item->params;
						ShellExecuteEx(&si);
					}
					

					else
						ParseBangCommand (hwnd, item->command, item->params);

					destroyAllSubMenus();
					isMainWindowHidden = TRUE;
					previousItem = NULL;
					previousCounter2 =0;
					counter2 = 0;
					ShowWindow(hMainWnd, SW_HIDE );

					break;
				}
				else
				{
					displaySubMenu(hwnd, item, counter);
					break;
				}
					
			}
			else if(tempEnum < subEnum)
			{
//				char temp[256];
	
				if(item->SMenu == NULL )
				{


//					strcpy(temp, item->command);

					if(item->command[0] != '!')
					{
						SHELLEXECUTEINFO si;
						memset(&si, 0, sizeof(si));
						si.cbSize = sizeof(SHELLEXECUTEINFO);
						si.lpDirectory = NULL;
						si.lpVerb = NULL;
						si.nShow = 1;
						si.fMask = SEE_MASK_DOENVSUBST;
						si.lpFile = item->command;
						si.lpParameters = item->params;
						ShellExecuteEx(&si);
					}
					

					else
						ParseBangCommand (hwnd, item->command, item->params);

					destroyAllSubMenus();
					isMainWindowHidden = TRUE;
					previousItem = NULL;
					previousCounter2 =0;
					counter2 = 0;
					ShowWindow(hMainWnd, SW_HIDE );

					break;
				}
				else
				{
					goingToSubMenu = TRUE;
					displaySubMenu(hwnd, item, counter);
					break;
				}

			}
			item = item->next;
		}
	
		break;		

	}
	
	
	return DefWindowProc(hwnd, message, wParam, lParam);

}
