/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/****************************************************************************

 7/18/98 - Azerov
            This file contains [Drizzt]'s hotkey code, which scans the 
            start menu and desktop, looking for *.LNK files and registering
			the hotkeys of those files if present.

****************************************************************************/

#include <windows.h>
#include "hotkey2.h"

extern HWND hMainWnd; // main window handle

static void drizzt_FindLnks (const char *);
static void drizzt_AddHotKey(const char *szBaseFileDir, const char *szFileName);

static ATOM hotKeys[200];
int nCurrentHotKey = 0;

void drizzt_FreeHotKeys(void)
{
	UINT nLoop;
	ATOM aHotKey;

	aHotKey = GlobalFindAtom("CTRL-ESC");
	UnregisterHotKey(hMainWnd, aHotKey);
	GlobalDeleteAtom (aHotKey);

	aHotKey = GlobalFindAtom("REINIT");
	UnregisterHotKey(hMainWnd, aHotKey);
	GlobalDeleteAtom (aHotKey);

	for (nLoop = 0; nLoop < sizeof (hotKeys) / sizeof (ATOM); ++nLoop) {
		aHotKey = hotKeys[nLoop];
		if (aHotKey != 0) {
			UnregisterHotKey(hMainWnd, aHotKey);
			GlobalDeleteAtom(aHotKey);
			hotKeys[nLoop] = 0;
		}
	}

	nCurrentHotKey = 0;
}

void drizzt_InitHotKeys(void)
{
	HKEY shellFoldersKey;
	DWORD dataType, dataLength = 1024;

	char szAllStartMenu[1024];	// WinNT
	char szAllDesktop[1024];	// WinNT
	char szUserStartMenu[1024];
	char szUserDesktop[1024];

	// Trap CTRL-ESC
	RegisterHotKey(hMainWnd, GlobalAddAtom("CTRL-ESC"), MOD_CONTROL, 27);
	
	// Hotkey Code
	RegisterHotKey(hMainWnd, GlobalAddAtom("REINIT"), MOD_CONTROL | MOD_ALT | MOD_SHIFT, 'R');

	RegOpenKey(HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", &shellFoldersKey);
	dataLength = sizeof (szUserStartMenu);
	if (RegQueryValueEx(shellFoldersKey, "Start Menu", NULL, &dataType, (LPBYTE) szUserStartMenu, &dataLength) != ERROR_SUCCESS)
		strcpy(szUserStartMenu, "");
	dataLength = sizeof (szUserDesktop);
	if (RegQueryValueEx(shellFoldersKey, "Desktop", NULL, &dataType, (LPBYTE) szUserDesktop, &dataLength) != ERROR_SUCCESS)
		strcpy(szUserDesktop, "");
	RegCloseKey(shellFoldersKey);

	RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", 0, KEY_READ, &shellFoldersKey);
	dataLength = sizeof (szAllStartMenu);
	if (RegQueryValueEx(shellFoldersKey, "Common Start Menu", NULL, &dataType, (LPBYTE) szAllStartMenu, &dataLength) != ERROR_SUCCESS)
		strcpy(szAllStartMenu, "");
	dataLength = sizeof (szAllDesktop);
	if (RegQueryValueEx(shellFoldersKey, "Common Desktop", NULL, &dataType, (LPBYTE) szAllDesktop, &dataLength) != ERROR_SUCCESS)
		strcpy(szAllDesktop, "");
	RegCloseKey(shellFoldersKey);

	memset(&hotKeys, 0, sizeof(hotKeys));
	nCurrentHotKey = 0;

	if (strcmp(szUserStartMenu, "")) {
		SetCurrentDirectory(szUserStartMenu);
		drizzt_FindLnks(szUserStartMenu);
	}
	if (strcmp(szUserDesktop, "")) {
		SetCurrentDirectory(szUserDesktop);
		drizzt_FindLnks(szUserDesktop);
	}
	if (strcmp(szAllStartMenu, "")) {
		SetCurrentDirectory(szAllStartMenu);
		drizzt_FindLnks(szAllStartMenu);
	}
	if (strcmp(szAllDesktop, "")) {
		SetCurrentDirectory(szAllDesktop);
		drizzt_FindLnks(szAllDesktop);
	}
}

void drizzt_execute(const char *prog, const char *param, const char *dir)
{
SHELLEXECUTEINFO si;
char d[261];
const char *dd;
memset(&si, 0, sizeof(SHELLEXECUTEINFO));

si.cbSize = sizeof(SHELLEXECUTEINFO);
si.fMask = SEE_MASK_DOENVSUBST;
si.hwnd = hMainWnd;
si.lpVerb = NULL;
si.lpFile = prog;
si.lpParameters = param;

if (dir == NULL)
	{
    char *p;
    strcpy(d, prog);
    p = d + strlen(d);
    for (;p>d;p--)
    	if (*p == '\\') break;
    if (p == d)
    	dd = dir;
    else
    	{
    	*p = 0;
        dd = d;
        }
    }
else
	dd = dir;

si.lpDirectory = dd;
si.nShow = 1;

ShellExecuteEx(&si);
}

void drizzt_FindLnks(const char *szBaseSearchDir)
{
	WIN32_FIND_DATA findDirData;
	WIN32_FIND_DATA findLnkData;
	HANDLE hDirFind;
	HANDLE hLnkFind;
	char szSearchDir[1024];

	SetCurrentDirectory(szBaseSearchDir);
	hLnkFind = FindFirstFile("*.lnk", &findLnkData);
	if (hLnkFind != INVALID_HANDLE_VALUE) {
		if (findLnkData.dwFileAttributes ^ FILE_ATTRIBUTE_DIRECTORY) {
			drizzt_AddHotKey(szBaseSearchDir, findLnkData.cFileName);
		}
		while (FindNextFile(hLnkFind, &findLnkData)) {
			if (findLnkData.dwFileAttributes ^ FILE_ATTRIBUTE_DIRECTORY) {
				drizzt_AddHotKey(szBaseSearchDir, findLnkData.cFileName);
			}
		}
	}
	FindClose(hLnkFind);

	hDirFind = FindFirstFile("*.*", &findDirData);
	if (hDirFind != INVALID_HANDLE_VALUE) {
		if (findDirData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			if (strcmp(findDirData.cFileName, ".") != 0 && strcmp(findDirData.cFileName, "..") != 0) {
				strcpy(szSearchDir, szBaseSearchDir);
				strcat(szSearchDir, "\\");
				strcat(szSearchDir, findDirData.cFileName);
				drizzt_FindLnks(szSearchDir);
				SetCurrentDirectory(szBaseSearchDir);
			}
		}

		while (FindNextFile(hDirFind, &findDirData)) {
			if (findDirData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
				if (strcmp(findDirData.cFileName, ".") != 0 && strcmp(findDirData.cFileName, "..") != 0) {
					strcpy(szSearchDir, szBaseSearchDir);
					strcat(szSearchDir, "\\");
					strcat(szSearchDir, findDirData.cFileName);
					drizzt_FindLnks(szSearchDir);
					SetCurrentDirectory(szBaseSearchDir);
				}
			}
		}
	}
	FindClose(hDirFind);
}

void drizzt_AddHotKey(const char *szBaseFileDir, const char *szFileName)
{
	HANDLE hFile;
	BYTE btHotKey;
	BYTE btModifier;
	LONG lHotKeyOffset = 64;
	DWORD dwRead;
	char szLnkFile[1024];

	strcpy(szLnkFile, szBaseFileDir);
	strcat(szLnkFile, "\\");
	strcat(szLnkFile, szFileName);

	hFile = CreateFile(szLnkFile,
				GENERIC_READ, 
				0,
				NULL,
				OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, 
				NULL);

	if (hFile != INVALID_HANDLE_VALUE) {
		SetFilePointer(hFile, lHotKeyOffset, NULL, FILE_BEGIN);
		ReadFile(hFile, &btHotKey, 1, &dwRead, NULL);
		ReadFile(hFile, &btModifier, 1, &dwRead, NULL);

		if (btHotKey && btModifier) {

			switch(btModifier) {
				case 0x03:
					{
						hotKeys[nCurrentHotKey] = GlobalAddAtom(szLnkFile);
						if (hotKeys[nCurrentHotKey]) 
							if (RegisterHotKey(hMainWnd, hotKeys[nCurrentHotKey], MOD_CONTROL | MOD_SHIFT, btHotKey))
								nCurrentHotKey++;
					} break;
				case 0x05:
					{
						hotKeys[nCurrentHotKey] = GlobalAddAtom(szLnkFile);
						if (hotKeys[nCurrentHotKey]) 
							if (RegisterHotKey(hMainWnd, hotKeys[nCurrentHotKey], MOD_SHIFT | MOD_ALT, btHotKey))
								nCurrentHotKey++;
					} break;
				case 0x06:
					{
						hotKeys[nCurrentHotKey] = GlobalAddAtom(szLnkFile);
						if (hotKeys[nCurrentHotKey]) 
							if (RegisterHotKey(hMainWnd, hotKeys[nCurrentHotKey], MOD_CONTROL | MOD_ALT, btHotKey))
								nCurrentHotKey++;
					} break;
				case 0x07:
					{
						hotKeys[nCurrentHotKey] = GlobalAddAtom(szLnkFile);
						if (hotKeys[nCurrentHotKey]) 
							if (RegisterHotKey(hMainWnd, hotKeys[nCurrentHotKey], MOD_CONTROL | MOD_SHIFT | MOD_ALT, btHotKey))
								nCurrentHotKey++;
					} break;
				default:
					break;
			}
		}
		CloseHandle(hFile);
	}
}

