/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/****************************************************************************

 06/03/98 - F. Gastellu
            This file contains the source code for the LM78 module
            Parts from the LM78 linux driver by Ronald Schmidt

****************************************************************************/

#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>
#include <conio.h>

#include "lm78.h"
#include "resource.h"

char szAppName[] = "lm78"; // Our window class, etc

unsigned long  m_SMBBA;                    //  SMBB addresse
unsigned short m_fan1div,m_fan2div;
float VCore, Vcpu, V5v, V12v, Vm12v, Vm5v, MBTemp, CPUTemp;
int fan1, fan2, fan3;

#define CPU_AMD   0
#define CPU_CYRIX 1
#define CPU_INTEL 2

int coefTable[3] = {8, 15, 22};
int cpuType = CPU_AMD;
int cpuCorrection;

int unit, maxCpu, maxMb;

// our window procedure
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
HWND hMainWnd; // main window handle
HWND parent;

// Double buffering data
HDC memDC;		// memory device context
HBITMAP	memBM,  // memory bitmap (for memDC)
		oldBM;  // old bitmap (from memDC)

HDC memDC_font;		// memory device context

HBITMAP bmp_font, ofont;

wharfDataType wharfData;
HICON cadre;
HICON chip;
HICON mb;
HICON ledoff, ledon;
HICON cpu, mb2;

UINT Timer;

BOOL backInit=FALSE;

void createView(void);
	
//-------------------------------------------------------------------------------------------------
int initWharfModule(HWND ParentWnd, HINSTANCE dllInst, wharfDataType *wd)
{
	HDC pDC;

	parent = ParentWnd;
	memcpy(&wharfData, wd, sizeof(*wd));

	unit = wharfData.lm78Unit;
	maxCpu = wharfData.lm78MaxCpu;
	maxMb = wharfData.lm78MaxMb;

	{	// Register our window class
		WNDCLASS wc;

		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProc;				// our window procedure
		wc.hInstance = dllInst;					// hInstance of DLL
		wc.lpszClassName = szAppName;			// our window class name
	
		if (!RegisterClass(&wc)) 
		{
			MessageBox(parent,"Error registering window class","lm78",MB_OK);
			return 1;
		}
	}


	hMainWnd = CreateWindowEx(
		WS_EX_TRANSPARENT,										// exstyles 
		szAppName,								// our window class name
		"lsclock",								// use description for a window title
		WS_CHILD,				
		wharfData.borderSize, wharfData.borderSize,				// position 
		64-wharfData.borderSize*2,64-wharfData.borderSize*2,		// width & height of window
		parent,									// parent window (winamp main window)
		NULL,									// no menu
		dllInst,								// hInstance of DLL
		0);										// no window creation data

	if (!hMainWnd) 
	{						   
		MessageBox(parent,"Error creating window","lm78",MB_OK);
		return 1;
	}


	SetCursor(LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW)));
	SetWindowLong(hMainWnd,GWL_USERDATA,magicDWord); // set our user data to a "this" pointer

	// create our doublebuffer
	pDC = GetDC(parent);
	memDC = CreateCompatibleDC(pDC);
	memBM = CreateCompatibleBitmap(pDC,64-wharfData.borderSize*2,64-wharfData.borderSize*2);
	oldBM = SelectObject(memDC,memBM);


	cadre = LoadImage(dllInst,MAKEINTRESOURCE(IDI_ICON1), IMAGE_ICON, 64, 64, LR_DEFAULTCOLOR);
	chip = LoadImage(dllInst,MAKEINTRESOURCE(IDI_ICON3), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	mb = LoadImage(dllInst,MAKEINTRESOURCE(IDI_ICON2), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	ledoff = LoadImage(dllInst,MAKEINTRESOURCE(IDI_ICON5), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	ledon = LoadImage(dllInst,MAKEINTRESOURCE(IDI_ICON4), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	cpu = LoadImage(dllInst,MAKEINTRESOURCE(IDI_ICON6), IMAGE_ICON, 32, 32, LR_DEFAULTCOLOR);
	mb2 = LoadImage(dllInst,MAKEINTRESOURCE(IDI_ICON7), IMAGE_ICON, 32, 32, LR_DEFAULTCOLOR);
	bmp_font = LoadImage(dllInst,MAKEINTRESOURCE(IDB_BITMAP1), IMAGE_BITMAP, 119, 11, LR_DEFAULTCOLOR);
	
	memDC_font = CreateCompatibleDC(pDC);

	ReleaseDC(parent, pDC);

	ofont = SelectObject(memDC_font, bmp_font);

	// show the window
	ShowWindow(hMainWnd,SW_SHOWNORMAL);

	initLM78();

	Timer = SetTimer(hMainWnd, 0, 1000, NULL);
	return 0;
}

//-------------------------------------------------------------------------------------------------
// cleanup (opposite of init()). Destroys the window, unregisters the window class
__declspec( dllexport ) void quitWharfModule(HINSTANCE dllInst/*struct winampVisModule *this_mod*/)
{
	//config_write(this_mod);		// write configuration
	KillTimer(hMainWnd, Timer);

	SelectObject(memDC,oldBM);	// delete our doublebuffer
	DeleteObject(memDC);
	DeleteObject(memBM);	

												
	SelectObject(memDC_font,ofont);	// delete our doublebuffer
	DeleteObject(memDC_font);
	
	DestroyWindow(hMainWnd); // delete our window
	UnregisterClass(szAppName,dllInst/*this_mod->hDllInstance*/); // unregister window class
}


//-------------------------------------------------------------------------------------------------
// window procedure for our window
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
HDC dp;

	switch (message)
	{
		case WM_CREATE:		return 0;
		case WM_ERASEBKGND: return 0;
		case WM_PAINT:
			{ // update from doublebuffer
				PAINTSTRUCT ps;
				RECT r;
				HDC hdc = BeginPaint(hwnd,&ps);
				GetClientRect(hwnd,&r);
				if (!backInit)
					{
					dp = GetDC(parent);
					BitBlt(memDC, 0, 0, r.right, r.bottom, dp, wharfData.borderSize, wharfData.borderSize, SRCCOPY);
					ReleaseDC(parent, dp);
                                        createView();
					backInit = TRUE;
					}
				BitBlt(hdc,0,0,r.right,r.bottom,memDC,0,0,SRCCOPY);
				EndPaint(hwnd,&ps);
			}
		return 0;
		case WM_KEYDOWN: // pass keyboard messages to main winamp window (for processing)
		case WM_KEYUP:
			{	
				PostMessage(parent,message,wParam,lParam);
			}
		return 0;
        case WM_RBUTTONUP:
                {
                RECT r;
                GetWindowRect(hwnd, &r);
                PostMessage(GetParent(GetParent(parent)), 9182, r.top+(int)HIWORD(lParam), r.left+(int)LOWORD(lParam));
                }
            return 0;
        case WM_RBUTTONDOWN:
        case WM_LBUTTONDOWN:
        case WM_MBUTTONDOWN:
            PostMessage(GetParent(GetParent(parent)), 9183, 0, 0);
            return 0;
	    case WM_TIMER:
			{
			RECT r;
			GetClientRect(hwnd,&r);
                        createView();
			InvalidateRect(hwnd, &r, FALSE);
			}
		return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}


//-------------------------------------------------------------------------------------------------
void createView(void)
{
char buffer[10];
int x;
char *p;
int pflag=0;
float a;

queryLM78();

a = (float)(clock() / CLOCKS_PER_SEC);
pflag = (a / 2.0 == (int)(a / 2));

DrawIconEx(memDC, 2,0,chip,16,16,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);
DrawIconEx(memDC, 2,31,mb,16,16,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);

DrawIconEx(memDC, 20,2,cpu,32,32,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);
DrawIconEx(memDC, 20,33,mb2,32,32,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);

if (CPUTemp < maxCpu)
	DrawIconEx(memDC, 45,1,ledoff,16,16,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);
else
	if (pflag)
		DrawIconEx(memDC, 45,1,ledon,16,16,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);
	else
		DrawIconEx(memDC, 45,1,ledoff,16,16,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);


if (MBTemp < maxMb)
	DrawIconEx(memDC, 45,32,ledoff,16,16,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);
else
	if (pflag)
		DrawIconEx(memDC, 45,32,ledon,16,16,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);
	else
		DrawIconEx(memDC, 45,32,ledoff,16,16,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);

DrawIconEx(memDC, 4,15,cadre,64,64,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);
DrawIconEx(memDC, 4,46,cadre,64,64,0,NULL,DI_NORMAL|DI_DEFAULTSIZE);

memset(buffer, 0, 10);
if (!unit)
	sprintf(buffer, "%5.1fC", CPUTemp);
else
	{
	CPUTemp = CPUTemp * 9 / 5 + 32;
	sprintf(buffer, "%5.1fF", CPUTemp);
	}

p = buffer;
x=0;
for (x=0;x<7;x++)
	{
	switch (*p)
		{
		case ' ':
			p++;
			continue;
		case '.':
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 17, 4, 11, memDC_font, 115, 0, SRCCOPY);
			break;
		case '':
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 17, 6, 11, memDC_font, 108, 0, SRCCOPY);
			break;
		case 'C':
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 17, 5, 11, memDC_font, 90, 0, SRCCOPY);
			break;
		case 'F':
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 17, 5, 11, memDC_font, 99, 0, SRCCOPY);
			break;
		default:
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 17, 9, 11, memDC_font, (*p - '0') * 9, 0, SRCCOPY);
			break;
		}
	p++;
	}


memset(buffer, 0, 10);
if (!unit)
	sprintf(buffer, "%5.1fC", MBTemp);
else
	{
	MBTemp = MBTemp * 9 / 5 + 32;
	sprintf(buffer, "%5.1fF", MBTemp);
	}

p = buffer;
x=0;
for (x=0;x<7;x++)
	{
	switch (*p)
		{
		case ' ':
			p++;
			continue;
		case '.':
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 48, 4, 11, memDC_font, 115, 0, SRCCOPY);
			break;
		case '':
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 48, 6, 11, memDC_font, 108, 0, SRCCOPY);
			break;
		case 'C':
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 48, 5, 11, memDC_font, 90, 0, SRCCOPY);
			break;
		case 'F':
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 48, 5, 11, memDC_font, 99, 0, SRCCOPY);
			break;
		default:
			BitBlt(memDC, 5+x*9-(x > 3 ? 5 : 0)-(x > 5 ? 3 : 0), 48, 9, 11, memDC_font, (*p - '0') * 9, 0, SRCCOPY);
			break;
		}
	p++;
	}

}

/**************************************************************************
 *  lm78 implementation for tx boards     v0.1
 * 
 *  (c) Ronald Schmidt 1997
 *
 *  tanx to Pedro Ortigao (Pedro.Ortigao@ip.pt) 
 *          who send me the specifikation
 *
 *  modified by Francis Gastellu to use under Windows9x (not NT) machines
 */


//-------------------------------------------------------------------------------------------------
void queryLM78(void)
{
        //char *p;
        //float dummy;
        long ch;
        unsigned char SMBHSTCNT,SMBHSTSTS;
        unsigned long maxtimeout=10000;
        unsigned long timeout ;

		_asm cli;


    	//p = buf;

        _outp((unsigned short)0x295, 0x61);

        // get the core Voltage
        VCore=((float) _inp(0x296)) * 0.016f;
        /*p += sprintf(p,"coreV\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ));*/

        // get the IO Voltages (cpu)
        Vcpu=((float) _inp(0x296)) * 0.016f;
        /*p += sprintf(p,"cpuioV\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ) );*/


        // get the 5 VOLT
	    V5v =((float) _inp(0x296)) * 0.016f * 1.68f;
        /*p += sprintf(p,"+5VOLT\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy*10) ));*/

        // get the +12	Volt
	    V12v=((float) _inp(0x296)) * 0.016f * 3.8f;
        /*p += sprintf(p,"+12VOLT\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ));*/


        // get the -12 VOLT
	    Vm12v=(((float) _inp(0x296)) * -0.016f * 3.47f)*(-1);
        /*p += sprintf(p,"-12VOLT\t= -%d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ) );*/


        // get the -5 VOLT
		Vm5v=(((float) _inp(0x296)) * -0.016f * 1.5f)*(-1);
        /*p += sprintf(p,"-5VOLT\t= -%d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ) );*/



        // get the mainboard temp
		MBTemp=(float)_inp(0x296);
        /*p += sprintf(p,"mb_temp\t= %d\n",(unsigned short)dummy);*/


        // get the fan1 speen
		/*if ((ch=inp(0x296))==0xFF) p +=sprintf(p,"fan1\t= not aviable\n");
                              else p +=sprintf(p,"fan1\t= %d\n",(unsigned long)(675000 / m_fan1div / ch ));*/
		if ((ch=_inp(0x296))==0xFF) fan1 = -1;
							  else fan1 = (unsigned long)(675000 / m_fan1div / ch );

		// get the fan2 speed
        /*if ((ch=inp(0x296))==0xFF) p +=sprintf(p,"fan2\t= not aviable\n");
                              else p +=sprintf(p,"fan2\t= %d\n",(unsigned long)(675000 / m_fan2div / ch ));*/

		if ((ch=_inp(0x296))==0xFF) fan2 = -1;
							  else fan2 = (unsigned long)(675000 / m_fan2div / ch );

		//get the fan3 speed
        /*if ((ch=inp(0x296))==0xFF) p +=sprintf(p,"fan3\t= not aviable\n");
                              else p +=sprintf(p,"fan3\t= %d\n",(unsigned long)(337500 / ch));*/
		if ((ch=_inp(0x296))==0xFF) fan3 = -1;
							  else fan3 = (unsigned long)(337500 / ch);



		SMBHSTSTS = (unsigned char)_inp((unsigned short)m_SMBBA);  timeout=0;
        while ( (SMBHSTSTS & 1) && (timeout<maxtimeout)) {
                SMBHSTSTS = (unsigned char)_inp((unsigned short)m_SMBBA);
                timeout++;
        }
        //if (timeout>=maxtimeout) printf("lm78: timeout\n");

        timeout=0;
        if ( ((SMBHSTSTS & 0x1E) != 0) && (timeout<maxtimeout)){
                _outp((unsigned short) m_SMBBA, SMBHSTSTS);
		timeout++;
        }
        //if (timeout>=maxtimeout) printf("lm78: timeout\n");
        _outp((unsigned short)(m_SMBBA+3), 0x00);
        _outp((unsigned short)(m_SMBBA+4), 0x93);

        SMBHSTCNT = (unsigned char)_inp((unsigned short)(m_SMBBA+2));
        SMBHSTCNT = ( SMBHSTCNT & 0xE0) | 0x0C;			 


        _outp((unsigned short) (m_SMBBA+2), SMBHSTCNT);
        _outp((unsigned short) (m_SMBBA+2), (SMBHSTCNT | 0x40));

        timeout=0;
        while ( ( _inp((unsigned short)m_SMBBA) & 0x1 ) && (timeout<maxtimeout)){ timeout++; }
        //if (timeout>=maxtimeout) printf("lm78: timeout\n");


		// get the cpu temp
		CPUTemp = (float)_inp((unsigned short)(m_SMBBA+5)) + ((_inp((unsigned short)(m_SMBBA+6))>>7) & 0x1) * 0.5f;
        CPUTemp+=cpuCorrection;
        /*p += sprintf(p,"cpu_tmp\t= %d.%d\n",
                        (unsigned short)dummy,
                        (unsigned short)(dummy*10-( (unsigned short)dummy *10) ) ) ;*/
        
//        return p - buf;
		_asm sti;
}


//-------------------------------------------------------------------------------------------------
void initLM78(void)
{
    unsigned long pix;
    unsigned char tmp;
    char txt[4096]="";

    cpuCorrection = coefTable[wharfData.lm78Cpu];

    /* SMBBUS addr */
    pix = _inpw(0x0CF8);
    pix &= 0x7F000003;
    pix |= 0x80000800;
    pix |= (1<<11);
    pix |= (3<<8);
    pix |= (0x90);
    _outpw((unsigned short)0x0CF8, (unsigned short)pix);
    m_SMBBA = (unsigned short)_inpw(0x0CFC) - 1;

    /* FANDIVS */
    _outp((unsigned short) 0x295, 0x47);
    tmp = _inp(0x296);
    m_fan1div = (tmp & 0x30) >> 4;
    m_fan2div = (tmp & 0xC0) >> 6;

    m_SMBBA = 0xe800;

    //Just to make sure the LM78 is measuring
    _outp((unsigned short) 0x295, 0x40);
    _outp((unsigned short) 0x296, 0x01);
}


