//	************************************************************
//
//	System-Click 'System Control at a Mouseclick'
//	Win95 32-bit Shell Extension
//		James P. Ketrenos
//
//	************************************************************
#include <afxwin.h>

#include "Resource.h"
#include "Global.h"
#include "SysClk.h"
#include "IconWnd.h"


//	************************************************************
//	CSysClkApp Class Implementation
//
//	Purpose:
//	*	Main application initialization
//	*	Check for prior instances
//	*	Create main application window
//
//	************************************************************



//	*******************************
//	CSysClkApp::InitInstance()
//
//	Purpose:
//	*	Checks to see if the 'FullDragApp' mutex already exists.  If
//		not, then it claims it.
//	*	Creates the main application window and hides it.
//	*******************************
BOOL	CSysClkApp::InitInstance()
{	
CIconWnd*		pWnd;
CString			FileName;
CRect			Rect;

	//	Check for Mutex and claim it if not there
	m_Mutex	= CreateMutex(NULL, TRUE, "SysClkApp");
	if (GetLastError() == ERROR_ALREADY_EXISTS)
	{
		MessageBox(
			NULL, 
			"System-Click already running.",
			"System-Click",
			MB_ICONSTOP);

		return	FALSE;
	}
		
	//	Create our applications window
	pWnd		= new CIconWnd;
	m_pMainWnd	= (CWnd*)pWnd; 
	
	::GetWindowRect(GetDesktopWindow(), Rect);

	if (pWnd->Create(NULL, "System-Click", WS_OVERLAPPEDWINDOW, Rect) == 0)
	{
		MessageBox(NULL, "Failed to create main window", "System-Click", MB_ICONSTOP);
		return	FALSE;
	}

	pWnd->ShowWindow(SW_HIDE);
	
	//	Initialize the Notification Icon.
	//	NOTE:	The icon will only appear if the NotifyIcon entry
	//			in our INI file is set to 1 (TRUE).
	if (pWnd->m_InitIcon() == FALSE)
	{
		MessageBox(NULL, "Failed to create notification icon.", "System-Click", MB_ICONSTOP);
		return	FALSE;
	}

	return	TRUE;
}



//	*******************************
//	CSysClkApp::ExitInstance()
//
//	Purpose:
//	*	Destroys the mutex that let's other instances know we are 
//		already running.
//	*******************************
int		CSysClkApp::ExitInstance()
{
	ReleaseMutex(m_Mutex);
	
	return CWinApp::ExitInstance();
}



//	*******************************
//	Create our window
//	*******************************
CSysClkApp	FullDrag;
