; A demonstration Program.  A continuous loop doing the following.

; nbauers@samphire.demon.co.uk

; HELLO WORLD Text output.
; Traffic lights.
; Seven segment displays.
; Heater and thermostat.
; Snake in the maze.
; Stepper Motor.

	CLO			; CLOSE ALL PERIPHERAL WINDOWS
	JMP	 HERE
	DB	"HELLO WORLD!"
	DB	0		; Null terminated
HERE:
	MOV	CL,C0		; VIDEO RAM BASE ADDRESS
	MOV	BL,03		; OFFSET OF TEXT STRING
START:				; TEXT OUTPUT TO VDU
	MOV	AL,[BL]		; TEXT POINTER INTO AL
	CMP	AL,0		; AT END YET?
	JZ	END1		; JUMP OUT OF LOOP
	MOV	[CL],AL		; AL INTO VIDEO MEMORY
	INC	CL		; NEXT VIDEO LOCATION
	INC	BL		; NEXT TEXT CHARACTER
	JMP	START		; NOT THERE YET
END1:

	MOV	BL,0C		; FLASH THE TRAFFIC LIGHTS
	MOV	AL,AA		; 1010 1010b
REP1:
	OUT	01		; LIGHTS ARE ON PORT ONE
	NOT	AL		; 0101 0101b
	DEC	BL		; COUNT DOWN
	JNZ	REP1		; JUMP OUT OF LOOP ON ZERO

	JMP	SKIPOVR
MIDDLE:
	JMP	HERE
SKIPOVR:

	MOV	BL,0C		; FLASH SEVEN SEGMENT DISPLAYS
REP2:
	MOV	AL,FF		; 1111 1111b
	OUT	02		; LIGHTS ARE ON PORT ONE
	MOV	AL,FE		; 1111 1110b
	OUT	02		; LSB USED FOR MULTIPLEXING

	MOV	AL,01		; 0000 0001b
	OUT	02		;
	MOV	AL,0		; 0000 0000b
	OUT	02		;

	DEC	BL		; COUNT DOWN
	JNZ	REP2		; JUMP OUT OF LOOP ON ZERO

	MOV	BL,0C		; CONTROL THE HEATER
	MOV	AL,80		; TURN IT ON WITH MSB
REP3:
	OUT	03		; HEATER IS ON PORT 3
	DEC	BL		; COUNT DOWN
	JNZ	REP3		; JUMP OUT OF LOOP ON ZERO

	MOV	BL,0C		; CONTROL THE HEATER
	MOV	AL,00		; TURN IT OFF
REP4:
	OUT	03		; 
	DEC	BL		;
	JNZ	REP4		; JUMP OUT OF LOOP ON ZERO

	MOV	AL,FF		; MAZE RESET
	OUT	04		; SNAKE IS ON PORT 4
	MOV	BL,0A		; COUNT DOWN START VALUE
	MOV	AL,4F		; 4 MEANS DOWN.  F MEANS 15.
REP5:
	OUT	04
	DEC	BL
	JNZ	REP5

	MOV	BL,20		; COUNT DOWN START VALUE
	MOV	AL,11		; 0001 0001b
REP6:
	OUT	05
	ROL	AL
	DEC	BL
	JNZ	REP6

	CLO

	MOV	CL,C0		; SCREEN BASE ADDRESS
	MOV	BL,10		; CLEAR ROW ON SCREEN
	MOV	AL,20		; ASCII SPACE
REP7:
	MOV	[CL],AL
	INC	CL
	DEC	BL
	JNZ	REP7
	JMP	MIDDLE
	
	END
