unit Choose;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TChooseDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Liste: TListBox;
    Label2: TLabel;
    procedure Init(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ChooseDialog: TChooseDialog;

implementation

uses Decla;

{$R *.DFM}

(* init dialog *)
procedure TChooseDialog.Init(Sender: TObject);
var Bcl : integer;
    Max : integer;
    Tmp : string;
begin
 Caption := VTrans.Title;
 Case VTrans.Number of
  1 : Max := Number_Files;
  2 : Max := Number_Icons;
  3 : Max := Number_Run;
  4 : Max := Number_Ini;
 end;
 if Max > 0 then
 begin
  Liste.Clear;
  for Bcl := 1 to Max do
  begin
   Case VTrans.Number of
    1 : Tmp := VFiles [Bcl].FileName;
    2 : Tmp := VIcons [Bcl].FileName;
    3 : Tmp := VRun [Bcl].DocsName;
    4 : Tmp := VIniF [Bcl].FileName + ',' +
               VIniF [Bcl].INISecti + ',' +
               VIniF [Bcl].INIField + ',' +
               VIniF [Bcl].IniValue;
   end;
   Liste.Items.Add (Tmp);
  end;
  Liste.ItemIndex := -1;
 end;
end;

(* Ok button choose ! *)
procedure TChooseDialog.OKBtnClick(Sender: TObject);
begin
 VTrans.Number := Liste.ItemIndex;
 ModalResult := mrOk;
end;

(* cancel button *)
procedure TChooseDialog.CancelBtnClick(Sender: TObject);
begin
 VTrans.Number := -1;
 ModalResult := mrCancel;
end;

end.
