/* Rotate the log files for a given PowerWeb Server service */

parse arg service admin_user admin_password

if length(service) = 0 | service = "?" | service = "/?" then do
	say "Utility to Rotate PowerWeb Server++ Logs"
	say ""
	say "Usage:     Rotate [service [AdminName [AdminPassword]]]"
	say ""
	say "Example 1: Rotate HTTP"
	say "Example 2: Rotate HTTP admin secret"
	say ""
	say "If the admin user name is omitted, it defaults to 'admin'."
	say "If the admin user password is omitted, it defaults to empty."
	return
end

if length(admin_user) = 0 then
	admin_user = 'admin'

http = '/!log?Server='service'&Log=0&submit=Rotate'

call CallHTTP http, admin_user, admin_password, "Audit Log", "Copyright"

return

