<h3>Overview</h3>

The following tree structure should help explain the relationship between
resources, templates and rules:
<pre>
Resource Definition
        Overall Resource Template Name
        Resource FileName Pattern
                Authentication
                Access Rules
                        Access Rules Template Name
                        Rule1
                                Host&IP
                                Access Method
                                Continue?
                                Allow?
                        Rule2
                                Host&IP
                                Access Method
                                Continue?
                                Allow?
                        Rule3
                                Host&IP
                                Access Method
                                Continue?
                                Allow?
                Presentation Rules
                        Presentation Rules Template Name
                API System Event Rules
                        Event Rules Template Name
                MIME Rules
                        MIME Rules Template Name
</pre>
In summary: each resource is defined by both its filename pattern and the
template which describes its behaviour. That template in turn is composed of
sub-sections for access control, presentation rules, API events, and MIME, each
of which can have its own sub-template (although this feature of sub-templates
is not often used and can only be accessed via "advanced settings").
<p>

The user databases (realms) fit into authentication. An access control rule
that specifies access is allowed to only some users or user groups must have a
corresponding authentication setting. The most common setting is to use "basic"
authentication within the realm "admin".
<p>

Each resource can have its own realm, so you can have independent valid user
lists for separate resources, without fear of conflict of user names or
permissions across such lists. If you establish sub-directories for different
organisations to serve their HTML from, you would probably allocate each such
sub-directory resource its own realm.

