' TERM.BAS
Option Explicit

Dim FatalFlag As Integer
Dim Code As Integer

Sub Aborting ()
  Dim Code As Integer
  TERM.Print "Fatal Error, Aborting..."
  Code = SioDone(ThePort)
  End
End Sub

Sub GetIncoming ()
  Dim i As Integer
  Dim TheChar As Integer
  Dim Code As Integer
  Dim S As String
  'is modem I/O (MIO) running ?
  If mioState <> 0 Then
    'run Modem I/O driver
    Call RunMIO
    Exit Sub
  End If
  'is ASCII driver running ?
  If asState <> 0 Then
    'run ascDriver
    Call RunAS
    Exit Sub
  End If
  'is XMODEM / YMODEM driver running ?
  If xyState <> 0 Then
    'run xyDriver
    Call RunXY
    Exit Sub
  End If
  'get all incoming serial
  For i = 1 To 1000
    TheChar = SioGetc(ThePort)
    If TheChar > 0 Then
      Call DisplayChar(TERM, TheChar)
    Else
      Exit For
    End If
  Next i
End Sub

Sub GoOffLine ()
  Dim Code As Integer
  OnLineFlag = 0
  'release xyDriver
  Code = xyRelease(ThePort)
  'shut down port
  Code = SioDone(ThePort)
End Sub

Sub GoOnLine ()
  Dim i As Integer
  Dim RxQueSize As Integer
  Dim TxQueSize As Integer
  If OnLineFlag Then
    Exit Sub
  End If
  'reset the port (1024 byte RX buffer & 128 byte TX buffer)
  RxQueSize = RX_QUE_SIZE
  TxQueSize = TX_QUE_SIZE
  Code = SioReset(ThePort, RxQueSize, TxQueSize)
  If Code < 0 Then
    Call SayError(TERM, Code)
    Exit Sub
  End If
  ''' set baud rate
  Code = SioBaud(ThePort, TheBaudCode)
  'call Aborting() if detect error after resetting port
  Call DisplayLine(TERM, "COM" + LTrim$(Str$(1 + ThePort)) + " reset")
  'set DTR & RTS
  Code = SioDTR(ThePort, Asc("S"))
  Code = SioRTS(ThePort, Asc("S"))
  'turn on hardware flow control
  Code = SioFlow(ThePort, Asc("H"))
  Call DisplayLine(TERM, "RTS/CTS flow control on [Waiting for DSR]")
  If SioCTS(ThePort) = 0 Then
    Call DisplayLine(TERM, "Flow control not enabled on modem [CTS=0]")
  End If
  ' set parms
  Code = SioParms(ThePort, TheParity, TheStopBits, TheDataBits)
  'acquire xyDriver
  Code = xyAcquire(ThePort)
  'set xyDriver debug level
  Code = xyDebug(DebugLevel)
  ' we're online !
  OnLineFlag = 1
End Sub

Sub RunAS ()
  Dim Code As Integer
  Dim Buffer As String * 81
  Dim Text As String
  Dim Packet As Integer
  ' any messages from xyDriver ?
  While ascGetMessage(Buffer, 80) > 0
    Text = Buffer
    Call DisplayLine(TERM, Text)
  Wend
  ' run the driver
  Code = ascDriver()
  If Code <> 0 Then
    'time to go to next ASCII state (since driver is idle)
    Select Case asState
      '*** ASDRIVER states ***
      Case TX_AS 'Send ASCII
        Code = ascInit(ThePort, RX_QUE_SIZE, 0)
        Code = ascStartTX(TERM.AcceptText.Text, 10, 0, 1)
        asState = RUN_AS
      Case RX_AS 'Receive ASCII
        Code = ascInit(ThePort, RX_QUE_SIZE, 0)
        Code = ascStartRX(TERM.AcceptText.Text, 0, 30, 3, 1)
        'prompt sender with CR
        Code = SioPutc(ThePort, 13)
        asState = RUN_AS
      Case RUN_AS 'ASDRIVER is done
        Call DisplayLine(TERM, "ascDriver is done.")
        asState = 0
        TERM.menuSend.Enabled = True
        TERM.menuReceive.Enabled = True
        TERM.menuBreak.Enabled = False
    End Select
  End If
End Sub

Sub RunMIO ()
  Dim i As Integer
  Dim TheChar As Integer
  Dim Code As Integer
  Dim S As String
  'MIO is running
  TheChar = mioDriver(ThePort)
  If TheChar = MIO_IDLE Then
    'time to go to next MIO state (since driver is idle)
    Select Case mioState
      '*** DIAL states ***
      Case Dial_1
        'dial modem [edit to call local BBS]
        S = "!!ATDT" + TERM.AcceptText.Text + "!"
        Call DisplayLine(TERM, S)
        Code = mioSendTo(ThePort, 100&, S)
        mioState = Dial_2
      Case Dial_2
        'expect "CONNECT" back (wait up to 60 seconds)
        If mioWaitFor(ThePort, 60000, "CONNECT") Then
          mioState = Dial_3
        Else
          'error!
          Call DisplayLine(TERM, ">>>mioWaitFor fails!")
          TERM.menuDial.Enabled = True
          mioState = 0
        End If
      Case Dial_3
        'did we get expected result ("CONNECT")
        If mioResult(ThePort) Then
          Call DisplayLine(TERM, ">>>CONNECT was received")
        Else
          Call DisplayLine(TERM, ">>>CONNECT was NOT received!")
        End If
        'all done
        mioState = 0
        TERM.menuBreak.Enabled = False
      End Select
    Else
      'MIO is not IDLE (it's running)
      If TheChar <> MIO_RUNNING Then
        Call DisplayChar(TERM, TheChar)
      End If
    End If
End Sub

Sub RunXY ()
  Dim Code As Integer
  Dim Buffer As String * 81
  Dim Text As String
  Dim Packet As Integer
  ' any messages from xyDriver ?
  While xyGetMessage(Buffer, 80) > 0
    Text = Buffer
    Call DisplayLine(TERM, Text)
  Wend
  ' run the driver
  Code = xyDriver(ThePort)
  If Code = XY_IDLE Then
    'time to go to next XY state (since driver is idle)
    Select Case xyState
      '*** XYDRIVER states ***
      Case TX_XM 'Send XMODEM
        Code = xyStartTX(ThePort, TERM.AcceptText.Text, 0, XMODEM)
        xyState = RUN_XY
      Case RX_XM 'Receive XMODEM
        Code = xyStartRX(ThePort, TERM.AcceptText.Text, NAK, XMODEM)
        xyState = RUN_XY
'''DisplayLine ("xyStartRX: Code=" + Str$(Code))
      Case TX_YM 'Send YMODEM
        Code = xyStartTX(ThePort, TERM.AcceptText.Text, 1, YMODEM)
        xyState = RUN_XY
      Case RX_YM 'Receive YMODEM
        Code = xyStartRX(ThePort, TERM.AcceptText.Text, Asc("C"), YMODEM)
        xyState = RUN_XY
      Case RUN_XY 'XYDRIVER is done
        Call DisplayLine(TERM, "xyDriver is done.")
        xyState = 0
        TERM.menuSend.Enabled = True
        TERM.menuReceive.Enabled = True
        TERM.menuBreak.Enabled = False
    End Select
  Else
    'xyDriver is running
    Packet = xyGetParameter(ThePort, XY_GET_PACKET)
     If Packet <> LastPacket Then
       Call DisplayLine(TERM, "Packet " + Str$(Packet))
       LastPacket = Packet
     End If
   End If
End Sub

Sub ShowConfig ()
  Dim A As String
  Dim B As String
  Dim C As String
  Dim D As String
  Dim E As String
  If OnLineFlag Then
    A = " (Online)"
  Else
    A = " (Offline)"
  End If
  B = "COM" + LTrim$(Str$(ThePort + 1))
  C = " @ " + BaudText(TheBaudCode) + " "
  D = Str$(TheDataBits) + ParityText(TheParity)
  E = LTrim$(Str$(1 + TheStopBits))
  TERM.Caption = "TERM: " + B + C + D + E + A
End Sub

