VERSION 2.00
Begin Form FIND 
   AutoRedraw      =   -1  'True
   BorderStyle     =   3  'Fixed Double
   Caption         =   "FIND"
   ClientHeight    =   5595
   ClientLeft      =   2550
   ClientTop       =   2730
   ClientWidth     =   8565
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "Courier New"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   6285
   Left            =   2490
   LinkTopic       =   "Form1"
   ScaleHeight     =   5595
   ScaleWidth      =   8565
   Top             =   2100
   Width           =   8685
   Begin Menu menuExit 
      Caption         =   "Exit"
   End
   Begin Menu menuFindModem 
      Caption         =   "FindModem"
   End
End

' FIND.BAS

Option Explicit

Sub Form_Load ()
    Call DisplayInit(FIND)
End Sub

Sub menuExit_Click ()
  End
End Sub

Sub menuFindModem_Click ()
Dim Port As Integer
Dim Code As Integer
'examine COM1 through COM4 for modem
For Port = COM1 To COM4
  'reset the port
  Call DisplayString(FIND, "COM" + LTrim$(Str$(1 + Port)) + " ")
  Code = SioReset(Port, 512, 512)
  If Code < 0 Then
    Call SayError(FIND, Code)
  Else
    'we have hardware
    Code = SioBaud(Port, Baud9600)
    'set DTR & RTS
    Code = SioDTR(Port, Asc("S"))
    Code = SioRTS(Port, Asc("S"))
    'look for DSR
    If SioDSR(Port) Then
      Call DisplayString(FIND, " (DSR=1) ")
      'got DSR, so lets send "AT"
      Code = mioSendTo(Port, 100&, "!AT!")
      Call RunDriver(Port)
      'wait 2 seconds for OK
      Code = mioWaitFor(Port, 2000&, "OK")
      Call RunDriver(Port)
      'get result
      If mioResult(Port) Then
        'found modem
        Call DisplayLine(FIND, " Modem is detected !")
        Code = SioDone(Port)
        Exit Sub
      Else
        'no response
        Call DisplayLine(FIND, " No response.")
      End If
    Else
      Call DisplayLine(FIND, " (DSR=0) ")
    End If
    'shut down port
    Code = SioDone(Port)
  End If
Next Port
Call DisplayLine(FIND, "")
Call DisplayLine(FIND, "Cannot locate modem on COM1 through COM4")
End Sub

Sub RunDriver (ByVal Port As Integer)
Dim Code As Integer
While True
  Code = mioDriver(Port)
  If Code = MIO_IDLE Then
    ' driver is done
    Exit Sub
  End If
  If Code <> MIO_RUNNING Then
    ' display character returned by driver
    Call DisplayChar(FIND, Code)
  End If
Wend
End Sub

