unit Graph_f;
{ if running under Delphi, turn off Break on exception in Options|Environment}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Spin, Grids, XyGraph, Printers;

type
  TXYGraphDemoForm = class(TForm)
    XMinEdit: TEdit;
    Label1: TLabel;
    XMaxEdit: TEdit;
    Label6: TLabel;
    XStepEdit: TEdit;
    Label3: TLabel;
    YMinEdit: TEdit;
    Label4: TLabel;
    YMaxEdit: TEdit;
    Label5: TLabel;
    YStepEdit: TEdit;
    Label2: TLabel;
    Panel1: TPanel;
    AutoStepCB: TCheckBox;
    AutoXSizeCB: TCheckBox;
    AutoYSizeCB: TCheckBox;
    AllowedOutCB: TCheckBox;
    XLogCB: TCheckBox;
    YLogCB: TCheckBox;
    StringGrid1: TStringGrid;
    PlottingCB: TCheckBox;
    SeriesSE: TSpinEdit;
    Label7: TLabel;
    SetSeriesBtn: TButton;
    Label8: TLabel;
    ColorLB: TListBox;
    LinesCB: TCheckBox;
    PointsCB: TCheckBox;
    PrintBtn: TButton;
    RandomBtn: TButton;
    Label9: TLabel;
    MinStepEdit: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    XLogTickEdit: TEdit;
    YLogTickEdit: TEdit;
    xyGraph1: TxyGraph;
    DrawFnBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure PlottingCBClick(Sender: TObject);
    procedure AutoStepCBClick(Sender: TObject);
    procedure AutoXSizeCBClick(Sender: TObject);
    procedure AutoYSizeCBClick(Sender: TObject);
    procedure AllowedOutCBClick(Sender: TObject);
    procedure XLogCBClick(Sender: TObject);
    procedure YLogCBClick(Sender: TObject);
    procedure XMinEditChange(Sender: TObject);
    procedure XMaxEditChange(Sender: TObject);
    procedure YMinEditChange(Sender: TObject);
    procedure YMaxEditChange(Sender: TObject);
    procedure XStepEditChange(Sender: TObject);
    procedure YStepEditChange(Sender: TObject);
    procedure XStepEditExit(Sender: TObject);
    procedure YStepEditExit(Sender: TObject);
    procedure XMinEditExit(Sender: TObject);
    procedure XMaxEditExit(Sender: TObject);
    procedure YMinEditExit(Sender: TObject);
    procedure YMaxEditExit(Sender: TObject);
    procedure MinStepEditChange(Sender: TObject);
    procedure MinStepEditExit(Sender: TObject);
    procedure XLogTickEditChange(Sender: TObject);
    procedure YLogTickEditChange(Sender: TObject);
    procedure XLogTickEditExit(Sender: TObject);
    procedure YLogTickEditExit(Sender: TObject);
    procedure SetSeriesBtnClick(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
    procedure SeriesSEChange(Sender: TObject);
    procedure RandomBtnClick(Sender: TObject);
    procedure xyGraph1Rescale(Sender: TObject);
    procedure DrawFnBtnClick(Sender: TObject);
  private
    { Private declarations }
    internal: Boolean;
    xygraph2:txygraph;
  public
    { Public declarations }
  end;

var
  XYGraphDemoForm: TXYGraphDemoForm;

implementation

{$R *.DFM}

procedure TXYGraphDemoForm.FormCreate(Sender: TObject);
begin
  xyGraph1.XAxis.Title := 'Time';
  xyGraph1.YAxis.Title := 'Temperature';
  xyGraph1.AllowDuplicates := true;
  xyGraph1.OnRescale := xyGraph1Rescale;
  StringGrid1.Cells[0,0] := 'Time';
  StringGrid1.Cells[1,0] := 'Temp';
  ColorLB.ItemIndex := 0;
end;


{plotting a function:}
type
  FnParmArray = array[1..3] of Double;
const
  parms: FnParmArray = (0.5, 1.5, 4);

function Fn(x: Double; var p): Double; far;
var
  pA: FnParmArray absolute p;
begin
  Result := 1/((x - pA[1])*(x - pA[2])*(x - pA[3])) + 1;
end;

procedure TXYGraphDemoForm.DrawFnBtnClick(Sender: TObject);
begin
  xyGraph1.DrawFunction(Fn, parms, 0, 0, clGreen, psSolid, 0);
end;



procedure TXYGraphDemoForm.PlottingCBClick(Sender: TObject);
begin
  xyGraph1.Plotting := PlottingCB.Checked;
end;

procedure TXYGraphDemoForm.AutoXSizeCBClick(Sender: TObject);
begin
  if internal then Exit;
  xyGraph1.XAxis.AutoSizing := AutoXSizeCB.Checked;
  if AutoXSizeCB.Checked then
  begin
    internal := true;
    XMinEdit.Text := FloatToStrF(xyGraph1.XAxis.Min, ffFixed, 10, 6);
    XMaxEdit.Text := FloatToStrF(xyGraph1.XAxis.Max, ffFixed, 10, 6);
    internal := false;
  end;
end;

procedure TXYGraphDemoForm.AutoYSizeCBClick(Sender: TObject);
begin
  if internal then Exit;
  xyGraph1.YAxis.AutoSizing := AutoYSizeCB.Checked;
  if AutoYSizeCB.Checked then
  begin
    internal := true;
    YMinEdit.Text := FloatToStrF(xyGraph1.YAxis.Min, ffFixed, 10, 6);
    YMaxEdit.Text := FloatToStrF(xyGraph1.YAxis.Max, ffFixed, 10, 6);
    internal := false;
  end;
end;

procedure TXYGraphDemoForm.XMinEditChange(Sender: TObject);
begin
  if internal then Exit;
  try
  xyGraph1.XAxis.Min := StrToFloat(XMinEdit.Text);
  internal := true;
  AutoXSizeCB.Checked := false;
  internal := false;
  except end;
end;

procedure TXYGraphDemoForm.XMinEditExit(Sender: TObject);
begin
  XMinEdit.Text := FloatToStrF(xyGraph1.XAxis.Min, ffFixed, 10, 6);
end;

procedure TXYGraphDemoForm.XMaxEditChange(Sender: TObject);
begin
  if internal then Exit;
  try
  xyGraph1.XAxis.Max := StrToFloat(XMaxEdit.Text);
  internal := true;
  AutoXSizeCB.Checked := false;
  internal := false;
  except end;
end;

procedure TXYGraphDemoForm.XMaxEditExit(Sender: TObject);
begin
  XMaxEdit.Text := FloatToStrF(xyGraph1.XAxis.Max, ffFixed, 10, 6);
end;

procedure TXYGraphDemoForm.YMinEditChange(Sender: TObject);
begin
  if internal then Exit;
  try
  xyGraph1.YAxis.Min := StrToFloat(YMinEdit.Text);
  internal := true;
  AutoYSizeCB.State := cbUnchecked;
  internal := false;
  except end;
end;

procedure TXYGraphDemoForm.YMinEditExit(Sender: TObject);
begin
  YMinEdit.Text := FloatToStrF(xyGraph1.YAxis.Min, ffFixed, 10, 6);
end;

procedure TXYGraphDemoForm.YMaxEditChange(Sender: TObject);
begin
  if internal then Exit;
  try
  xyGraph1.YAxis.Max := StrToFloat(YMaxEdit.Text);
  internal := true;
  AutoYSizeCB.State := cbUnChecked;
  internal := false;
  except end;
end;

procedure TXYGraphDemoForm.YMaxEditExit(Sender: TObject);
begin
  YMaxEdit.Text := FloatToStrF(xyGraph1.YAxis.Max, ffFixed, 10, 6);
end;


procedure TXYGraphDemoForm.AutoStepCBClick(Sender: TObject);
begin
  if internal then Exit;
  xyGraph1.XAxis.AutoStepping := AutoStepCB.Checked;
  xyGraph1.YAxis.AutoStepping := AutoStepCB.Checked;
  if AutoStepCB.Checked then
  begin
    internal := true;
    XStepEdit.Text := FloatToStrF(xyGraph1.XAxis.StepSize, ffFixed, 10, 6);
    YStepEdit.Text := FloatToStrF(xyGraph1.YAxis.StepSize, ffFixed, 10, 6);
    internal := false;
  end;
end;

procedure TXYGraphDemoForm.XStepEditChange(Sender: TObject);
begin
  if internal then Exit;
  try
  xyGraph1.XAxis.StepSize := StrToFloat(XStepEdit.Text);
  internal := true;
  AutoStepCB.Checked := false;
  internal := false;
  except end;
end;

procedure TXYGraphDemoForm.XStepEditExit(Sender: TObject);
begin
  XStepEdit.Text := FloatToStrF(xyGraph1.XAxis.StepSize, ffFixed, 10, 6);
end;

procedure TXYGraphDemoForm.YStepEditChange(Sender: TObject);
begin
  if internal then Exit;
  try
  xyGraph1.YAxis.StepSize := StrToFloat(YStepEdit.Text);
  internal := true;
  AutoStepCB.Checked := false;
  internal := false;
  except end;
end;

procedure TXYGraphDemoForm.YStepEditExit(Sender: TObject);
begin
  YStepEdit.Text := FloatToStrF(xyGraph1.YAxis.StepSize, ffFixed, 10, 6);
end;


procedure TXYGraphDemoForm.AllowedOutCBClick(Sender: TObject);
begin
  xyGraph1.Appearance.PlotOffGraph := AllowedOutCB.Checked;
end;

procedure TXYGraphDemoForm.XLogCBClick(Sender: TObject);
begin
  xyGraph1.XAxis.LogScale := XLogCB.Checked;
  XStepEdit.OnExit(nil);
end;

procedure TXYGraphDemoForm.YLogCBClick(Sender: TObject);
begin
  xyGraph1.YAxis.LogScale := YLogCB.Checked;
  YStepEdit.OnExit(nil);
end;

procedure TXYGraphDemoForm.MinStepEditChange(Sender: TObject);
begin
  xyGraph1.Appearance.MinSteps := StrToInt(MinStepEdit.Text);
end;

procedure TXYGraphDemoForm.MinStepEditExit(Sender: TObject);
begin
  MinStepEdit.Text := IntToStr(xyGraph1.Appearance.MinSteps);
end;

procedure TXYGraphDemoForm.XLogTickEditChange(Sender: TObject);
begin
  xyGraph1.XAxis.LogCycleDivisions := StrToInt(XLogTickEdit.Text);
end;

procedure TXYGraphDemoForm.YLogTickEditChange(Sender: TObject);
begin
  xyGraph1.YAxis.LogCycleDivisions := StrToInt(YLogTickEdit.Text);
end;

procedure TXYGraphDemoForm.XLogTickEditExit(Sender: TObject);
begin
  XLogTickEdit.Text := IntToStr(xyGraph1.XAxis.LogCycleDivisions);
end;

procedure TXYGraphDemoForm.YLogTickEditExit(Sender: TObject);
begin
  YLogTickEdit.Text := IntToStr(xyGraph1.YAxis.LogCycleDivisions);
end;

procedure TXYGraphDemoForm.PrintBtnClick(Sender: TObject);
begin
  if MessageDlg('Print the graph?', mtInformation, [mbYes, mbNo], 0) = mrYes then
(*
  Print multiple copies on page:
  Printer.BeginDoc;
    xyGraph1.PrintScalePct := 48;
    xyGraph1.PrintXOffsetPct := 0;
    xyGraph1.PrintOnPage;
    xyGraph1.PrintXOffsetPct := 52;
    xyGraph1.PrintOnPage;
  Printer.EndDoc;
*)
    xyGraph1.Print;
end;

procedure TXYGraphDemoForm.SetSeriesBtnClick(Sender: TObject);
const
  Colors: array[0..8] of TColor = (clBlack, clBlue, clTeal, clGreen,
            clLime, clYellow, clMaroon, clRed, clPurple);
var
  j, sN: Integer;
  xv, yv: Double;
  color: TColor;
begin
  xyGraph1.AllowDuplicates := true;
  sN := SeriesSE.Value;
  with xyGraph1.Series[sN] do
  begin
    Active := true;
    Clear;
    AutoZero := false;
    DrawLine := LinesCB.Checked;
    DrawPoints := PointsCB.Checked;
    PointSize := 6;
  end;
  j := 1;
  while j < StringGrid1.RowCount do
    try
      xv := StrToFloat(StringGrid1.Cells[0,j]);
      yv := StrToFloat(StringGrid1.Cells[1,j]);
      xyGraph1[sN][xv] := yv;
      Inc(j);
    except
      on EConvertError do Break
    end;
end;

procedure TXYGraphDemoForm.SeriesSEChange(Sender: TObject);
var
  b: Boolean; d: Double;
  sN, j: Integer;
  index: longint;
  x, y, r: Double;
  more: Boolean;
begin
  StringGrid1.Cols[0].Clear;
  StringGrid1.Cols[1].Clear;
  StringGrid1.Cells[0,0] := 'Time';
  StringGrid1.Cells[1,0] := 'Temp';
  sN := StrToInt(SeriesSE.Text);
  j := 1;
  more := xyGraph1[sN].GetFirstPoint(x, y, r, index);
  while more do
  begin
    StringGrid1.Cells[0,j] := FloatToStrF(x, ffFixed, 10, 6);
    StringGrid1.Cells[1,j] := FloatToStrF(y, ffFixed, 10, 6);
    more := xyGraph1[sN].GetNextPoint(x, y, r, index);
    Inc(j);
  end;
end;


procedure TXYGraphDemoForm.RandomBtnClick(Sender: TObject);
var
  sN, j: Integer;
  xRange, yRange: Integer;
  xv, yv, xOffset, yOffset: Double;
  holdPlotting: Boolean;
begin
  xyGraph1.AllowDuplicates := true;
  holdPlotting := xyGraph1.Plotting;
  xyGraph1.Plotting := false;
  for sN := 1 to 6 do
  begin
    with xyGraph1.Series[sN] do
    begin
      Active := true;
      Clear;
      AutoZero := false;
      DrawLine := true;
      PointSize := 6;
    end;

    xRange := 1 + Random(10);
    yRange := 1 + Random(15);
    xOffset := xRange/2;
    yOffset := 1; {Random(yRange div 5) - yRange + 1;}
    for j := 1 to sN+1 do
    begin
      xv := (Random(xRange) + xOffset);
      yv := (Random(yRange) + yOffset);
      xyGraph1[sN][xv] := yv;
    end;
  end;
  xyGraph1.Plotting := holdPlotting;
end;

procedure TXYGraphDemoForm.xyGraph1Rescale(Sender: TObject);
begin
  internal := true;
  XMinEdit.Text := FloatToStrF(xyGraph1.XAxis.Min, ffFixed, 10, 6);
  XMaxEdit.Text := FloatToStrF(xyGraph1.XAxis.Max, ffFixed, 10, 6);
  internal := true;
  YMinEdit.Text := FloatToStrF(xyGraph1.YAxis.Min, ffFixed, 10, 6);
  internal := true;
  YMaxEdit.Text := FloatToStrF(xyGraph1.YAxis.Max, ffFixed, 10, 6);
  internal := true;
  XStepEdit.Text := FloatToStrF(xyGraph1.XAxis.StepSize, ffFixed, 10, 6);
  internal := true;
  YStepEdit.Text := FloatToStrF(xyGraph1.YAxis.StepSize, ffFixed, 10, 6);
  internal := false;
  XLogTickEdit.Text := IntToStr(xyGraph1.XAxis.LogCycleDivisions);
  YLogTickEdit.Text := IntToStr(xyGraph1.YAxis.LogCycleDivisions);
  MinStepEdit.Text := IntToStr(xyGraph1.Appearance.MinSteps);
end;


end.


