(****************************************************************************
  This is the main form of the TTrayIcon example program.  This form is never
  actually shown - it is hidden as soon as it is created.  Application logic
  is initialized on this form.

  Notice the INITIALIZATION section.  This hides the application instance
  (Delphi uses another window handle for the taskbar) so that nothing shows
  up on the task bar OR the ALT-TAB task manager.  If you want to show this
  at any time or add the application to the ALT-TAB order, issue a:
  ShowWindow( Application.Handle, SW_SHOW ).
  You might do this, for example, in the on-click event for the trayicon so that
  the open window shows up on the taskbar.  I prefer it like it is for small
  utility type applications...

  One problem with using Delphi for this is that in the TApplication code, the
  application window is shown.  This causes a brief flash on the taskbar for
  the application when it is first run.  If this is annoying, you can modify
  TApplication source code so this flash will not happen.  You must have the
  Developer or Client/Server edition to have the source code.  Follow these
  instructions to make the modifications:
  Open the Forms.PAS file.
  Find the TApplication.CreateHandle method (around line 3943).
  About 10 lines into the method there is a FHandle := CreateWindow( .... )
     function call.  In this call, comment out the 'or WS_VISIBLE' clause.
  About 5 lines below this, comment out the 'ShowWinNoAnimate( ... )' line.
  Recompile your DCL file.  (Or, just include your source in your project
                             search path)
  This ONLY gets rid of the brief flash.  You should probably un-comment these
  lines for normal projects, although everything seems to still work ok, there
  might be some side effects.

  There should be enough example code here for you to integrate some of these
  ideas into your own application.  If you have a 'hidden' program accessible
  mostly from the trayicon (like this example is), it is best to use the main
  form for logic only - don't actually show and hide the form - because showing
  and hiding the main form also causes the application window to be adjusted
  which will make it re-appear.

 ****************************************************************************)

unit TrayT1;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Graphics, 
  TrayIcon, Menus, StdCtrls, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    PopupMenu1: TPopupMenu;
    Test11: TMenuItem;
    Test21: TMenuItem;
    Test31: TMenuItem;
    TrayIcon1: TTrayIcon;
    Timer1: TTimer;
    Animate1: TMenuItem;
    N1: TMenuItem;
    procedure TrayIcon1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Animate1Click(Sender: TObject);
    procedure Test31Click(Sender: TObject);
    procedure Test11Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  AnimateSequence : Integer = 1;

implementation

uses fVisible;

{$R *.DFM}

procedure TForm1.TrayIcon1Click(Sender: TObject);
begin
   ViewableForm.Show;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   Left := -5000;  { move it off the screen because it will flash on for a second
                     before the application processes all the messages }

   ShowWindowAsync( Handle, SW_HIDE );
   Timer1.Enabled := True;   // Start those eyes moving!
   PopupMenu1.Items[2].Checked := True;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  AppIcon : TIcon;
  IconName : String;
begin
  // we're loading icons from the EXE file - they're in the resource file and
  // compiled in.

  IconName := format('EYES%d',[ AnimateSequence ] );

  AppIcon := TIcon.Create;
  AppIcon.Handle := LoadIcon( HInstance ,pchar( format('ICON_%d',[ AnimateSequence ] )) );
  TrayIcon1.Icon := AppIcon;
  AppIcon.Free;

  AnimateSequence := AnimateSequence + 1;
  if AnimateSequence > 13 then
     AnimateSequence := 1;

end;

procedure TForm1.Animate1Click(Sender: TObject);
begin
   Timer1.Enabled := not Timer1.Enabled;
   (Sender as TMenuItem).Checked := Timer1.Enabled;
end;

procedure TForm1.Test31Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.Test11Click(Sender: TObject);
begin
   ViewableForm.Show;
end;

initialization
begin
   { We want to hide the application TASKBAR icon }
   ShowWindow( Application.Handle, SW_HIDE ); // Get it done NOW
   Application.ProcessMessages;
end;

end.
