unit Tifimage;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Zoompic, tifffile,Dsgnintf;

type
  TTiffImage = class(TZoomImage)
  private
    { Private declarations }
    FTiff:TTiffFile;
    function getfilename:string;
    function getcurrimage:integer;
    function getimagecount:integer;
    procedure setfilename(v:string);
    procedure setCurrImage(v:integer);
  protected
    { Protected declarations }
    constructor create(owner:TComponent); override;
    destructor destroy; override;
  public
    { Public declarations }
    property ImageCount:integer read getimagecount;
  published
    { Published declarations }
    property Filename:string read getFilename write SetFilename;
    property CurrentImage:integer read getcurrimage write setCurrimage;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('graf', [TTiffImage]);
  RegisterPropertyEditor(Typeinfo(string),
       TTiffImage, 'Filename', TFileNameProperty);
end;

function TTiffImage.getfilename:string;
begin
 result := FTiff.Filename;
end;

function TTiffImage.getcurrimage:integer;
begin
 result := FTiff.Currentimage;
end;

function  TTiffImage.getimagecount:integer;
begin
 result := FTiff.Imagecount;
end;

procedure TTiffImage.setfilename(v:string);
begin
  if (v <> FTiff.Filename) or (Fbitmap.handle = 0) then
   begin
    FTiff.Filename := v;
    if (v <> '') and (FTiff.imagecount > 0) then
     FBitmap.handle := Ftiff.readbitmap
      else Fbitmap.handle := 0;{clear bitmap}
   end;
end;

procedure TTiffImage.setCurrImage(v:integer);
begin
 if (v <> Ftiff.Currentimage) or (Fbitmap.handle = 0) then
  begin
   Ftiff.currentimage := v;
   if Ftiff.CurrentImage = v then
      FBitmap.handle := Ftiff.readbitmap
       else  Fbitmap.handle := 0; {clear bitmap}
   end;
end;

constructor TTiffImage.create(owner:TComponent);
begin
 inherited create(owner);
 FTiff := tTiffFile.create(self);
end;

destructor TTiffImage.destroy;
begin
  FTiff.free;
  inherited destroy;
end;

end.
