unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, Execfile, StdCtrls, ExtCtrls, ShellAPI;

type
  TForm1 = class(TForm)
    ExecFile1: TExecFile;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Label1: TLabel;
    WaitBox: TCheckBox;
    WaitMethod: TRadioGroup;
    Ass: TCheckBox;
    Edit1: TEdit;
    PriorityType: TRadioGroup;
    WinStyle: TRadioGroup;
    Label2: TLabel;
    Label3: TLabel;
    SpeedButton3: TSpeedButton;
    OpenDialog1: TOpenDialog;
    procedure SpeedButton1Click(Sender: TObject);
    procedure ExecFile1Fail(Sender: TObject);
    procedure WaitBoxClick(Sender: TObject);
    procedure WaitMethodClick(Sender: TObject);
    procedure AssClick(Sender: TObject);
    procedure PriorityTypeClick(Sender: TObject);
    procedure WinStyleClick(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
ExecFile1.CommandLine := Edit1.Text;
ExecFile1.Parameters := '';

Label1.Caption := 'Waiting';
If ExecFile1.Execute then Label1.Caption := 'Done';
end;

procedure TForm1.ExecFile1Fail(Sender: TObject);
begin
Label1.Caption := 'Error->  '+IntToStr(ExecFile1.ErrorCode);
end;

procedure TForm1.WaitBoxClick(Sender: TObject);
begin
If WaitBox.Checked then ExecFile1.Wait := True else
begin ExecFile1.StopWaiting; ExecFile1.Wait := False; end;
end;

procedure TForm1.WaitMethodClick(Sender: TObject);
begin
If WaitMethod.ItemIndex = 0 then ExecFile1.WaitStyle := wRegular else
ExecFile1.WaitStyle := wSuspend;
end;

procedure TForm1.AssClick(Sender: TObject);
begin
If Ass.Checked then ExecFile1.Associate := True else
ExecFile1.Associate := False;

end;

procedure TForm1.PriorityTypeClick(Sender: TObject);
begin
If PriorityType.ItemIndex = 0 then ExecFile1.Priority := pcIdle;
If PriorityType.ItemIndex = 1 then ExecFile1.Priority := pcNormal;
If PriorityType.ItemIndex = 2 then ExecFile1.Priority := pcHigh;
If PriorityType.ItemIndex = 3 then ExecFile1.Priority := pcRealTime;

end;

procedure TForm1.WinStyleClick(Sender: TObject);
begin
If WinStyle.ItemIndex =0 then ExecFile1.WindowStyle := wsNorm;
If WinStyle.ItemIndex =1 then ExecFile1.WindowStyle := wsMaximize;
If WinStyle.ItemIndex =2 then ExecFile1.WindowStyle := wsMinimize;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
ExecFile1.Terminate;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
If OpenDialog1.Execute then Edit1.Text := OpenDialog1.Filename;
end;

end.
