unit Capitst1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TMainForm = class(TForm)
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    FCapiBufSize : Longint;
    FCapiBuffer : Pointer;
    FAppl_Id : Integer;

    procedure FormIdle (Sender : TObject; var Done : Boolean);
  end;

var
  MainForm: TMainForm;

implementation

uses
  Capi;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
const
  MaxMessages = 200;
  MaxConnections = 3;
  MaxBChanPackets = 3;
  MaxBChanDataSize = 512;
var
  Error : Integer;
  Msg :
    record
      Length : Word;
      APPL_ID : Word;
      Command,
      SubCommand : Byte;
      MessageNumber : Word;
      Data : array[0..2] of Byte;
    end;
  ListenMsg : TCapi_Listen_Req;
  VersionString : array[0..255] of Char;
begin
  FAppl_Id:=-1;

  { Check if CAPI is installed }
  if API_INSTALLED = 0 then
    raise Exception.Create('CAPI not installed');

  { Get CAPI version }
  Error:=API_GET_VERSION(@VersionString);
  ListBox1.Items.Add(StrPas(VersionString));

  { Get manufacturer identification }
  Error:=API_GET_MANUFACTURER(@VersionString);
  ListBox1.Items.Add(StrPas(VersionString));

  { Allocate buffer }
  FCapiBufSize:=CapiBufferSizeNeeded(MaxMessages,
    MaxConnections, MaxBChanPackets, MaxBChanDataSize);
  GetMem(FCapiBuffer, FCapiBufSize);

  { Register application }
  Error:=API_REGISTER(FCapiBuffer,
    MaxMessages, MaxConnections, MaxBChanPackets, MaxBChanDataSize);
  if (Error = 0) or (Error = $1001) then
    raise Exception.Create('Error registering API');
  FAppl_Id:=Error;

{ The following code applies only to TeleS BRI cards. This will request (as
  yet undocumented by TeleS) manufacturer messages from the adapter card.
  Other adapters have different message IDs.

  CapiMk_Manufacturer_Req(FAppl_Id, subcmd_REQ, [$12, $00, $00], Msg);
  Error:=API_PUT_MESSAGE(FAppl_Id, @Msg);
}

  { Listen to calls }
  ListenMsg:=CapiMk_Listen_Req(FAppl_Id, 0,
                               imInfoMask_All,
                               semServicedEaz_All,
                               simServicedSi_All);
  Error:=API_PUT_MESSAGE(FAppl_Id, @ListenMsg);
  if Error <> 0 then
    raise Exception.Create('Error sending listen request');

  { Set idle proc }
  Application.OnIdle:=FormIdle;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
  Error : Integer;
begin
  try
    { Unregister application }
    if FAppl_Id <> -1 then
      begin
        Error:=API_RELEASE(FAppl_Id);
        if Error <> 0 then
          raise Exception.Create('Error releasing API');
      end;
  finally
    { Deallocate buffer }
    FreeMem(FCapiBuffer, FCapiBufSize);
  end;
end;

procedure TMainForm.FormIdle (Sender : TObject; var Done : Boolean);
var
  Msg : PCapiMessage;
  Error : Integer;
begin
  Done:=False;
  Error:=API_GET_MESSAGE(FAppl_Id, Msg);
  if Error <> $1006 then
    begin
      ListBox1.Items.Add(CapiMessageToString(Msg^));
    end;
end;

end.

