unit AlbRegD_;

{Shows Disk Drives and CD Drives and the Media sense of the first CD Drive}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Registry,
  StdCtrls, Buttons, {If problems: Add the path to AlbReg.pas to the project} AlbReg;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    Edit1: TEdit;
    Edit2: TEdit;
    CheckBox1: TCheckBox;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function get_drives(DeviceType:string):string;
{Liest:
 HKEY_LOCAL_MACHINE
   enum
     scsi  / esdi
       device-Id
         Bus-port
           class -> device class
           CurrentDriveLetterAssignment ->  Ergebnis}

var erg:String; i,j:integer; c:char;
    letters,conditions:TStringList;
begin letters:=TStringList.create;
      try conditions:=TStringList.create;
      try conditions.add('class='+DeviceType);
      {Get SCSI-Devices}
      read_registry_values(HKey_Local_Machine,'enum\scsi\*\*','CurrentDriveLetterAssignment',
                           conditions,letters);
      erg:='';
      with letters do
      for i:=0 to count-1 do
       erg:=erg+strings[i];
      {Get IDE-Devices}
      read_registry_values(HKey_Local_Machine,'enum\esdi\*\*','CurrentDriveLetterAssignment',
                           conditions,letters);
      with letters do
      for i:=0 to count-1 do
       erg:=erg+strings[i];
      finally conditions.free end;
      finally letters.free end;
      {Sort drive letters}
      for i:=1 to length(erg)-1 do
      for j:=i+1 to length(erg) do
      if erg[i]>erg[j] then
       begin c:=erg[i]; erg[i]:=erg[j]; erg[j]:=c
       end;
      get_drives:=erg
end;

procedure TForm1.FormCreate(Sender: TObject);
var letters,conditions:TStringList;
begin edit1.text:=get_drives('DiskDrive');
      edit2.text:=get_drives('CDROM');
      letters:=TStringList.create;
      try conditions:=TStringList.create;
      try conditions.add('class=CDROM');
      read_registry_values(HKey_Local_Machine,'enum\scsi\*\*','AutoInsertNotification',
                           conditions,letters);
      with checkbox1 do
      if letters.count=0 then enabled:=false
                         else checked:=letters[0]=#1
      finally conditions.free end;
      finally letters.free end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
close
end;


end.
