/*** sioerror.c ***/

#include <stdio.h>
#include "windows.h"
#include "sioerror.h"
#include "wsc.h"
#include "paint.h"

void cdecl SioError(int Code, char *Text)
{static char Temp[81];
 DisplayString(Text);
 DisplayString(". ");
 switch(Code)
   {case WSC_NO_DATA:
      DisplayLine("No Data");
      break;
    case WSC_RANGE:
      DisplayLine("Parameter out of range");
      break;
    case WSC_ABORTED:
      DisplayLine("Aborted");
      break;
    case WSC_EXPIRED:
      DisplayLine("Shareware execution expired");
      break;
    case IE_BADID:
      DisplayLine(" Invalid COM port\n");
      break;
    case IE_OPEN:
      DisplayLine(" COM port already open\n");
      break;
    case IE_NOPEN:
      DisplayLine(" Cannot open COM port\n");
      break;
    case IE_MEMORY:
      DisplayLine(" Cannot allocate memory\n");
      break;
    case IE_DEFAULT:
      DisplayLine(" Error in default parameters\n");
      break;
    case IE_HARDWARE:
      DisplayLine(" COM port hardware not present\n");
      break;
    case IE_BYTESIZE:
      DisplayLine(" Unsupported byte size\n");
      break;
    case IE_BAUDRATE:
      DisplayLine(" Unsupported baud rate\n");
      break;
#ifdef WIN32
    case WSC_WIN32ERR:
      SioWinError((LPSTR)Temp,80);
      DisplayLine((LPSTR)Temp);
      break;
#endif
    default:
      wsprintf((LPSTR)Temp," Unknown code %d\n",Code);
      DisplayLine((LPSTR)Temp);
      break;
   }
} /* end SioError */
  
