/* 
** event.c
*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#include "wsc.h"
 
typedef struct
{int Port;
 int BytesRead;
} ParamType;

// 'TheThread' handles all incoming serial data 
// independently of the main program.

void TheThread(PVOID pvoid)
{int Code;
 char Buffer[128];
 ParamType *ParamPtr;
 ParamPtr = (ParamType *) pvoid;
 while(1)
   {Sleep(0);
    /* grab all available data */
    Code = SioGets(ParamPtr->Port,(LPSTR)Buffer,127);
    if(Code>0) 
      {ParamPtr->BytesRead += Code;
       Buffer[Code] = '\0';
       printf("%s",Buffer);
       fflush(stdout);
      }
    /* SioEvent will block this thread until there is more data */
    SioEvent(ParamPtr->Port, EV_RXCHAR);
   }
}

/* trap WSC error codes */

int ErrorCheck(int Port, int Code)
{if(Code<0)
   {char Temp[41];
    SioWinError(Temp,80);
    printf("ERROR %d: %s",Code, Temp);
    SioDone(Port);
    exit(1);
   }
 return Code;
}

/* display error & exit */

void SayError(char *Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

/*** main ***/

void main(int argc, char *argv[])
{int Version;
 DWORD ThreadID;
 HANDLE ThreadHandle;
 ParamType Params;
 char c;
 int Port;
 int Baud;
 /* process args */
 if(argc!=3)
   {printf("Usage: EVENT <port> <baud>\n");
    return;
   }
 Port = atoi(argv[1]) - 1;
 Baud = atoi(argv[2]);
 Version = SioInfo('V');
 printf("WSC Version %d.%d.%d\n", (Version>>8),0x0f&(Version>>4),0x0f&Version);
 /* reset the port */
 ErrorCheck( Port, SioReset(Port,1024,512) );
 ErrorCheck( Port, SioBaud(Port,Baud) );
 /* set DTR and RTS */
 SioDTR(Port,'S');
 SioRTS(Port,'S') ;
 /* save info for thread */
 Params.Port = Port;
 Params.BytesRead =  0;
 /* start thread to handle incoming serial */
 ThreadHandle = CreateThread(0,1024,(LPTHREAD_START_ROUTINE)TheThread,(void *)&Params,0,&ThreadID);
 if(ThreadHandle==0)
   {printf("Could not start thread\n");
    SioDone(Port);
    exit(1);
   }
 /* start main loop */
 printf("Type ^Z to abort...\n");
 while(1)
   {/* wait for user to type a character (no echo) */
    c = getch();
    /* quit if user typed ^Z */
    if(c==0x1a) break;
    /* transmit this character */
    SioPutc(Port,c);
    Sleep(0);
   }
 SuspendThread(ThreadHandle);
 printf("\n_____________________\n");
 printf("%d bytes were received\n", Params.BytesRead);
 SioDone(Port);
} /* end main */

