#include <stdio.h>
#include <intrinsics.h>
/*
	Examples for using the intrinsics of lcc-win32.
	This program MUST be compiled with the -O option
*/
int main()
{
	double arg,sin,cos;
	char *p="abcd";
	long l;
	int i1,i2,i3,c;

	/* _fsincos returns the sin and stores the cosinus at the
	   given address
	*/
	arg = 0.5;
	sin = _fsincos(arg,&cos);
	printf("sin(0.5)=%g,cos(0.5)=%g\n",sin,cos);

	/* bswap instruction */
	l = _bswap(*(long *)p);
	*(unsigned long *)p = l;
	printf("byte swap of 'abcd'=%s\n",p);

	/* rounding a floating point number with _fistp */
	printf("rounding cos(0.5)=%d\n",_fistp(cos));

	/* built in constants of the fpu */
	printf("Pi=%4.15f\n",_fldpi());
	printf("e^2=%4.15f\n",_fldl2e());
	printf("log(2)=%4.15f\n",_fldlg2());
	printf("ln(2)=%4.15f\n",_fldln2());

	/* carry flag */
	c = _carry();
	printf("carry before=%d\n",c);
	i2 = 48765456L;
	i1 = 83654098L;
	i3 = i2*i1;
	c = _carry();
	printf("carry after=%d\n",c);
	
}
