#ifndef VERSION_H
#define VERSION_H

#ifdef _WIN32
#include <winver.h>
#else
#include <ver.h>
#endif

#define NUMVARIABLEFIELDS 12

typedef enum tagVS_VARIABLEFILEINFO_ID {
    VF_VF_COMMENTS, VF_VF_COMPANY, VF_VF_FILEDESCRIPTION,
    VF_VF_FILEVERSION, VF_VF_INTERNALNAME, VF_VF_LEGALCOPYRIGHT,
    VF_VF_LEGALTRADEMARKS, VF_VF_ORIGINALFILENAME, VF_VF_PRIVATEBUILD,
    VF_VF_PRODUCTNAME, VF_VF_PRODUCTVERSION, VF_VF_SPECIALBUILD
}
VS_VARIABLEFILEINFO_ID;

typedef struct tagVS_VARIABLEFILEINFO {
    char szVerName[32];
    char szVerValue[128];
}
VS_VARIABLEFILEINFO;

extern VS_VARIABLEFILEINFO g_avsvfi[NUMVARIABLEFIELDS];
extern VS_FIXEDFILEINFO g_vsffi;

BOOL GetVersionInfo( HINSTANCE hInstance, UINT uiUnknownStringID );
void FreeVersionInfo( void );

#endif
