#include <windows.h>
#include <windowsx.h>
#include "taquin.h"

LRESULT CALLBACK _export StatusBar_WndProc( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam );
BOOL StatusBar_Initialize( void );
BOOL StatusBar_OnCreate( HWND hwnd, LPCREATESTRUCT lpcs );
void StatusBar_OnDestroy( HWND hwnd );
void StatusBar_OnPaint( HWND hwnd );
HFONT StatusBar_CreateFont( void );

typedef struct tagSTATUSBARDATA
{
    HWND hWnd;
    HFONT hFont;
    int iHeight;
    char szText[256];
}
STATUSBARDATA;

static STATUSBARDATA StatusBarData;

BOOL StatusBar_Initialize ( void )
{
    HDC hdc;
    TEXTMETRIC tm;

    StatusBarData.hFont = StatusBar_CreateFont();

    hdc = GetDC( NULL );
    GetTextMetrics( hdc, &tm );
    StatusBarData.iHeight = tm.tmHeight + tm.tmExternalLeading +
        7 * GetSystemMetrics(SM_CYBORDER);
    ReleaseDC( NULL, hdc );

    lstrcpy( StatusBarData.szText, "" );

    return TRUE;
}

int StatusBar_GetHeight ( void ) { return StatusBarData.iHeight; }
HFONT StatusBar_GetFont ( void ) { return StatusBarData.hFont; }

BOOL StatusBar_Register ( HINSTANCE hInst )
{
    WNDCLASS wc;

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = StatusBar_WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = NULL;
    wc.hCursor = LoadCursor( NULL, IDI_APPLICATION );
    wc.hbrBackground = (HBRUSH)(COLOR_BTNFACE + 1);  /* note button color */
    wc.lpszMenuName = NULL;
    wc.lpszClassName = "Taquin16StatusBar";

    if ( !RegisterClass( &wc ) )
        return FALSE;

    return TRUE;
}

void StatusBar_SetWindowHandle ( HWND hwnd )
{
    StatusBarData.hWnd = hwnd;
}

LRESULT CALLBACK StatusBar_WndProc ( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    LRESULT lResult = 0L;

    switch ( message )
    {
        case WM_CREATE:
            lResult = HANDLE_WM_CREATE( hwnd, wParam, lParam, StatusBar_OnCreate );
            break;

        case WM_PAINT:
            lResult = HANDLE_WM_PAINT( hwnd, wParam, lParam, StatusBar_OnPaint );
            break;

        case WM_DESTROY:
            lResult = HANDLE_WM_DESTROY( hwnd, wParam, lParam, StatusBar_OnDestroy );
            break;

        default:
            lResult = DefWindowProc( hwnd, message, wParam, lParam );
            break;
    }

    return lResult;
}


BOOL StatusBar_OnCreate ( HWND hwnd, LPCREATESTRUCT lpcs )
{
    StatusBar_SetWindowHandle( hwnd );
    return TRUE;
}

HFONT StatusBar_CreateFont ( void )
{
    HDC hdc;
    int iFontHeight;
    HFONT hfont;

    hdc = GetDC( NULL );
    iFontHeight = -MulDiv( 10, GetDeviceCaps( hdc, LOGPIXELSY ), 72 );
    hfont = CreateFont( iFontHeight, 0, 0, 0, FW_NORMAL, 0, 0, 0,
        ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
        DEFAULT_QUALITY, VARIABLE_PITCH | FF_SWISS, "Helv" );
    ReleaseDC( NULL, hdc );

    return hfont;
}


void StatusBar_OnDestroy ( HWND hwnd )
{
    if ( StatusBarData.hFont )
        DeleteFont( StatusBarData.hFont );
}


void StatusBar_OnPaint ( HWND hwnd )
{
    HDC hdc;
    PAINTSTRUCT ps;
    RECT rc, rcTemp, rcTemp2;
    HBRUSH hBrush;
    int cyBorder, cyBorderx2, cyBorderx3, cyBorderx8, cyBorderx9;

    hdc = BeginPaint( hwnd, &ps );

    cyBorder = GetSystemMetrics(SM_CYBORDER);
    cyBorderx2 = cyBorder * 2;
    cyBorderx3 = cyBorder * 3;
    cyBorderx8 = cyBorder * 8;
    cyBorderx9 = cyBorder * 9;

    GetClientRect( hwnd, &rc );

    /* Shadow color */

    hBrush = CreateSolidBrush(GetSysColor(COLOR_BTNSHADOW));

    /* Top and left shadow */
    rcTemp = rc;
    rcTemp.top    = rc.top + cyBorderx3;
    rcTemp.bottom = rcTemp.top + cyBorder;

    /* Top of Status */
    rcTemp.left   = cyBorderx8;
    rcTemp.right  = rcTemp.right - cyBorderx8;
    FillRect(hdc, &rcTemp, hBrush);

    /* Left */
    rcTemp = rc;
    rcTemp.top    += cyBorderx3;
    rcTemp.bottom -= cyBorderx2;

    /* Left of bar */
    rcTemp.left   = cyBorderx8;
    rcTemp.right  = rcTemp.left + cyBorder;
    FillRect(hdc, &rcTemp, hBrush);

    DeleteBrush( hBrush );


    hBrush = CreateSolidBrush(GetSysColor(COLOR_BTNHIGHLIGHT));

    /* Right, top and bottom hilight */
    rcTemp = rc;
    rcTemp.top    = rc.bottom  - cyBorderx3;
    rcTemp.bottom = rcTemp.top + cyBorder;

    /* Bottom of status */
    rcTemp.left   = cyBorderx8;
    rcTemp.right  = rcTemp.right - cyBorderx8;

    FillRect(hdc, &rcTemp, hBrush);

    /* Right of status */
    rcTemp = rc;
    rcTemp.top += cyBorderx3;
    rcTemp.bottom -= cyBorderx2;
    rcTemp.left  = rc.right - cyBorderx8;
    rcTemp.right = rcTemp.left + cyBorder;

    FillRect(hdc, &rcTemp, hBrush);

    DeleteBrush( hBrush );

    /* solid black line across top */
    hBrush = CreateSolidBrush(GetSysColor(COLOR_WINDOWTEXT));
    rcTemp = rc;
    rcTemp.bottom = rcTemp.top;
    rcTemp.bottom += cyBorder;
    FillRect(hdc, &rcTemp, hBrush);
    DeleteBrush(hBrush);

    SelectFont( hdc, StatusBarData.hFont );
    SetTextColor( hdc, GetSysColor(COLOR_BTNTEXT) );
    SetBkColor( hdc, GetSysColor(COLOR_BTNFACE) );

    /* status bar text */
    rcTemp = rc;
    rcTemp.top    = rc.top + (cyBorder * 4);
    rcTemp.bottom = rc.bottom - cyBorderx3;
    rcTemp.left   = cyBorderx9;
    rcTemp.right  = rcTemp.right - cyBorderx8;

    rcTemp2 = rcTemp;

    ExtTextOut(hdc, rcTemp.left + cyBorderx2, rcTemp.top,
               ETO_OPAQUE | ETO_CLIPPED, &rcTemp2,
               (LPSTR) StatusBarData.szText,
               lstrlen((LPSTR) StatusBarData.szText), NULL);

    EndPaint( hwnd, &ps );
}

void StatusBar_Update ( void )
{
    InvalidateRect( StatusBarData.hWnd, NULL, TRUE );
}

void StatusBar_SetText ( char *szNewText )
{
    lstrcpy( StatusBarData.szText, szNewText );
    StatusBar_Update();
}

void StatusBar_GetText ( char *szBuffer )
{
    lstrcpy( szBuffer, StatusBarData.szText );
}
