/* Settings.c -- User interface settings for Jeu de Taquin */

#include <windows.h>
#include "taquin.h"
#include "resource.h"

static SETTINGS Settings;   /* the one and only instance of settings */

void Settings_EnableSound( void )    { Settings.bSound = TRUE;  }
void Settings_DisableSound( void )   { Settings.bSound = FALSE; }
BOOL Settings_IsSoundEnabled( void ) { return Settings.bSound;  }

void Settings_SetFont ( char *szNewFontName, int iNewFontSize, BOOL bIsFontBold, BOOL bIsFontItalic )
{
    lstrcpy( Settings.szFontName, szNewFontName );
    Settings.iFontSize = iNewFontSize;
    Settings.bFontBold = bIsFontBold;
    Settings.bFontItalic = bIsFontItalic;
}

int Settings_GetFontSize ( void ) { return Settings.iFontSize; }
BOOL Settings_IsFontBold ( void ) { return Settings.bFontBold; }
BOOL Settings_IsFontItalic ( void ) { return Settings.bFontItalic; }

void Settings_GetFontName ( char *szFontNameBuffer )
{
    lstrcpy( szFontNameBuffer, Settings.szFontName );
}

void Settings_SetSoundName ( GAMESOUND gsnd, char *szNewSoundName )
{
    switch ( gsnd )
    {
        case GSND_MOVE:
            lstrcpy( Settings.szMoveSound, szNewSoundName );
            break;
        case GSND_BLOCKED:
            lstrcpy( Settings.szBlockedSound, szNewSoundName );
            break;
        case GSND_SOLVED:
            lstrcpy( Settings.szSolvedSound, szNewSoundName );
            break;
        default:
            break;
    }
}

void Settings_GetSoundName ( GAMESOUND gsnd, char *szSoundNameBuffer )
{
    switch ( gsnd )
    {
        case GSND_MOVE:
            lstrcpy( szSoundNameBuffer, Settings.szMoveSound );
            break;
        case GSND_BLOCKED:
            lstrcpy( szSoundNameBuffer, Settings.szBlockedSound );
            break;
        case GSND_SOLVED:
            lstrcpy( szSoundNameBuffer, Settings.szSolvedSound );
            break;
        default:
            break;
    }
}
            
BOOL Settings_Read ( void )
{
    char szIniFileName[13];
    int iValue;
    char szNewFontName[LF_FACESIZE];
    int iNewFontSize;
    BOOL bFontBold, bFontItalic;
    char szSoundName[13];          /* 8 + 3 + '\0' */
    char szDefaultSoundName[13];   /* 8 + 3 + '\0' */

    LoadString( g_hInst, IDS_INIFILENAME,
        szIniFileName, sizeof(szIniFileName) );

    /* Process the [Options] section. */

    iValue = GetPrivateProfileInt(
        "Options",              /* section name */
        "Sound",                /* key name */
        1,                      /* default value (1 = sound on) */
        szIniFileName );        /* INI file name */
    if ( iValue == 1 )
    {
        Settings_EnableSound();
    }
    else
    {
        Settings_DisableSound();
    }

    GetPrivateProfileString(
        "Options",
        "FontName",
        "Arial",
        szNewFontName,
        sizeof(szNewFontName),
        szIniFileName );

    /* Get the size of the tile font. Default = 18 points. */
    iNewFontSize = GetPrivateProfileInt( "Options", "FontSize", 18, szIniFileName );
    if ( iNewFontSize > TILEWIDTH )  /* point size happens to coincide with tile size */
        iNewFontSize = TILEWIDTH;

    iValue = GetPrivateProfileInt( "Options", "FontBold", 0, szIniFileName );
    bFontBold = (iValue == 1) ? TRUE : FALSE;

    iValue = GetPrivateProfileInt( "Options", "FontItalic", 0, szIniFileName );
    bFontItalic = (iValue == 1) ? TRUE : FALSE;

    Settings_SetFont( szNewFontName, iNewFontSize, bFontBold, bFontItalic );
    
    /* Process the [Sounds] section. */

    LoadString( g_hInst, IDS_DEFAULTMOVESOUND, szDefaultSoundName, sizeof(szDefaultSoundName) );
    GetPrivateProfileString( "Sounds", "MoveSound", szDefaultSoundName, szSoundName, sizeof(szSoundName), szIniFileName );
    Settings_SetSoundName( GSND_MOVE, szSoundName );

    LoadString( g_hInst, IDS_DEFAULTBLOCKEDSOUND, szDefaultSoundName, sizeof(szDefaultSoundName) );
    GetPrivateProfileString( "Sounds", "BlockedSound", szDefaultSoundName, szSoundName, sizeof(szSoundName), szIniFileName );
    Settings_SetSoundName( GSND_BLOCKED, szSoundName );

    LoadString( g_hInst, IDS_DEFAULTSOLVEDSOUND, szDefaultSoundName, sizeof(szDefaultSoundName) );
    GetPrivateProfileString( "Sounds", "SolvedSound", szDefaultSoundName, szSoundName, sizeof(szSoundName), szIniFileName );
    Settings_SetSoundName( GSND_SOLVED, szSoundName );

    return TRUE;
}

BOOL Settings_Write ( void )
{
    char szIniFileName[13];
    char szValue[256];

    if ( !g_bSettingsChanged ) /* no need to write settings */
    {
        return FALSE;
    }

    LoadString( g_hInst, IDS_INIFILENAME, szIniFileName, sizeof(szIniFileName) );

    /* Process the [Options] section. */
    lstrcpy( szValue, Settings_IsSoundEnabled() ? "1" : "0" );
    WritePrivateProfileString( "Options", "Sound", szValue, szIniFileName );
    
    Settings_GetFontName( szValue );
    WritePrivateProfileString( "Options", "FontName", szValue, szIniFileName );
    
    wsprintf( szValue, "%d", Settings_GetFontSize() );
    WritePrivateProfileString( "Options", "FontSize", szValue, szIniFileName );

    lstrcpy( szValue, Settings_IsFontBold() ? "1" : "0" );
    WritePrivateProfileString( "Options", "FontBold", szValue, szIniFileName );
        
    lstrcpy( szValue, Settings_IsFontItalic() ? "1" : "0" );
    WritePrivateProfileString( "Options", "FontItalic", szValue, szIniFileName );

    /* Process the [Sounds] section. */

    Settings_GetSoundName( GSND_MOVE, szValue );
    WritePrivateProfileString( "Sounds", "MoveSound", szValue, szIniFileName );

    Settings_GetSoundName( GSND_BLOCKED, szValue );
    WritePrivateProfileString( "Sounds", "BlockedSound", szValue, szIniFileName );

    Settings_GetSoundName( GSND_MOVE, szValue );
    WritePrivateProfileString( "Sounds", "SolvedSound", szValue, szIniFileName );

    return TRUE;
}

