#include <windows.h>    /* just for BOOL, TRUE, and FALSE */
#include "taquin.h"

static GAMEDATA GameData;

void GameData_Init ( void )
{
    int iRow, iColumn;

    for ( iRow = 0;  iRow < NUMROWS;  iRow++ )
        for ( iColumn = 0;  iColumn < NUMCOLUMNS;  iColumn++ )
            GameData_SetCell( iRow, iColumn, iRow * NUMROWS + iColumn + 1 );

    GameData_SetBlankCell( NUMROWS - 1, NUMCOLUMNS - 1 );
    
    GameData_SetCell( GameData_GetBlankRow(), GameData_GetBlankColumn(), EMPTY );
    
    GameData.gsGameState = GS_IDLING;
}

/*
 * Check for a solution. Make sure that the puzzle position is the same
 * as the initial position. Special checking on the blank position.
 */
BOOL GameData_IsSolved ( void )
{
    int row, column;

    GameData_SetCell( GameData_GetBlankRow(), GameData_GetBlankColumn(), 16 );

    for ( row = 0;  row < NUMROWS;  row++ )
        for ( column = 0;  column < NUMCOLUMNS;  column++ )
        {
            if ( GameData_GetCell( row, column ) != row * NUMROWS + column + 1 )
            {
                GameData_SetCell( GameData_GetBlankRow(), GameData_GetBlankColumn(), EMPTY );
                return FALSE;
            }
        }

    return TRUE;
}

/* Return the value of the cell at 'row', 'column'. */
int GameData_GetCell ( int row, int column )
{
    return GameData.aiCells[row][column];
}

/* Set the cell at (iRow, iColumn) to iValue. */
void GameData_SetCell ( int iRow, int iColumn, int iValue )
{
    GameData.aiCells[iRow][iColumn] = iValue;
}

int GameData_GetBlankColumn ( void ) { return GameData.iBlankColumn; }
int GameData_GetBlankRow    ( void ) { return GameData.iBlankRow; }

void GameData_SetBlankCell ( int iRow, int iColumn )
{
    GameData.iBlankRow = iRow;
    GameData.iBlankColumn = iColumn;
    GameData.aiCells[iRow][iColumn] = EMPTY;
}

void GameData_SetGameState ( GAMESTATE gsNewState ) { GameData.gsGameState = gsNewState; }
GAMESTATE GameData_GetGameState ( void ) { return GameData.gsGameState; }

