//---------------------------------------------------------------------------------------------
// File TOOLBAR.CPP
//---------------------------------------------------------------------------------------------
#define INCL_WIN

#include <os2.h>
#include <stdio.h>
#include "editor1.h"

MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);    // Window procedure
MRESULT EXPENTRY NewFrameProc  (HWND, ULONG ,MPARAM, MPARAM); // subclass framewindow

HAB   hab;
HWND  hwndFrame,
      hwndClient,
      hwndStatus,
      hwndToolbar,
      hwndMenu,
      hwndMLE;

PFNWP pfnwOldFrameProc; // Pointer to normal Frame routine in kernel for subclassing

main()
     {
     HMQ   hmq;
     QMSG  qmsg;
     ULONG flFrameFlags = FCF_TITLEBAR |FCF_SYSMENU |FCF_SIZEBORDER |FCF_MINMAX |FCF_TASKLIST;
     CHAR  szClient[] = "CLIENT";

     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);

     WinRegisterClass (hab, szClient, ClientWndProc, CS_SIZEREDRAW, 0);

     // Create Frame window
     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,
                                     WS_VISIBLE,
                                     &flFrameFlags,
                                     szClient,
                                     "MLE editor",
                                     0,
                                     NULLHANDLE,
                                     MAINMENU,
                                     &hwndClient);

      // Create statusbar window
      hwndStatus= WinCreateWindow(hwndFrame,
                                  WC_STATIC,
                                 " StatusBar",
                                  SS_TEXT| DT_VCENTER | WS_VISIBLE
                                  ,0, 0, 0, 0,       // client window has no size or position at this point
                                  hwndFrame,         // Owner handle (Client area)
                                  HWND_TOP,          // Z-order ontop
                                  STATUSBAR,         // Window ID
                                  0,                 // Control
                                  0);                // Presentation Parameters

     hwndMLE = WinCreateWindow(hwndClient,           // Parent handle (Client area)
                               WC_MLE,               // Window class (NLE)
                               NULL,                 // Window header text
                               WS_VISIBLE|
                               MLS_WORDWRAP|
                               MLS_BORDER|
                               MLS_VSCROLL|
                               MLS_HSCROLL,          //Style flags
                               0, 0, 0, 0,           // client window has no size or position at this point
                               hwndClient,           // Owner handle (Client area)
                               HWND_TOP,             // Z-order ontop
                               MAINMLE,              // Window ID (Main MLE resource ID)
                               0,                    // Control
                               0);                   // Presentation Parameters

     //---------------------------------------------------------------------------------------------
     // Subclassing normal window proc
     //---------------------------------------------------------------------------------------------
     pfnwOldFrameProc = WinSubclassWindow(hwndFrame,NewFrameProc);  // subclass Framewin
     WinSetWindowULong(hwndFrame,QWL_USER,(ULONG)pfnwOldFrameProc); // Pointer to oldwinproc in winword

     // CODE CHANGE !!!!!!!!!!!!!!!! ---------------------------------------------------------------
     hwndMenu    = WinLoadMenu(hwndFrame,NULLHANDLE,MAINMENU);      // Load normal window menu
     hwndToolbar = WinLoadMenu(hwndFrame,NULLHANDLE,TOOLBAR);       // Load Toolbar
     // END CODE CHANGE !!!!!!!!!!!! ---------------------------------------------------------------


     WinSetWindowPos(hwndFrame,
                     NULLHANDLE,
                     10,10,550,300,
                     SWP_ACTIVATE|SWP_MOVE|
                     SWP_SIZE    |SWP_SHOW);


     WinStartTimer(hab, hwndClient, 1, 100);

     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);

     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     return(0);
     }


MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     switch (msg)
          {
          case WM_SIZE:
               {
               SWP   swpclient;
               WinQueryWindowPos(hwnd, &swpclient);            // Get SWP Client Area.
               WinSetWindowPos(hwndMLE,                        // Place and size MLE
                               HWND_TOP,                       // ONTOP in Z-order
                               0,                              // x coord(precies in de rand!)
                               0,                              // y coord
                               swpclient.cx,                   //
                               swpclient.cy,                   // Size,Place (same as Client Area)
                               SWP_SIZE | SWP_SHOW | SWP_MOVE);// Change size|move en Show
               }
          break;

          case WM_COMMAND:
               {
               switch (SHORT1FROMMP(mp1))
                    {
                    case IDM_NEW:
                         WinSetWindowText(hwndMLE, "");
                    break;

                    case IDM_UNDO:
                         WinSendMsg(hwndMLE, MLM_UNDO, 0L, 0L);
                    break;

                    case IDM_CUT:
                         WinSendMsg(hwndMLE, MLM_CUT, 0L, 0L);
                    break;

                    case IDM_COPY:
                         WinSendMsg(hwndMLE, MLM_COPY, 0L, 0L);
                    break;

                    case IDM_PASTE:
                         WinSendMsg(hwndMLE, MLM_PASTE, 0L, 0L);
                    break;

                    case IDM_CLEAR:
                         WinSendMsg(hwndMLE, MLM_CLEAR, 0L, 0L);
                    break;

                    case IDM_EXIT:
                         WinSendMsg(hwnd, WM_CLOSE, 0L, 0L);
                    break;

                    case IDM_ABOUT:
                         WinSetWindowText (hwndStatus, " MLE editor by Eric & Marc");
                    break;
                    }
               }

          case WM_TIMER:
               {
               CHAR      String[64];
               LONG      Line, Col, Position;
               static    LONG OldPosition;

               Position = LONGFROMMR(WinSendMsg(hwndMLE, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL,0L));
               if (Position != OldPosition)
                    {
                    OldPosition = Position;
                    Line = LONGFROMMR(WinSendMsg(hwndMLE, MLM_LINEFROMCHAR, (MPARAM)Position, 0L));
                    Col  = LONGFROMMR(WinSendMsg(hwndMLE, MLM_CHARFROMLINE, (MPARAM)Line, 0L));
                    Col  = Position - Col;
                    sprintf(String,"  Line: %-5d Col: %-5d",Line+1,Col+1);
                    WinSetWindowText(hwndStatus, String);
                    }
               }

          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }


//-------------------------------------------------------------------------------------------------
// NewFrameProc
//
// this proc is coupled through subclassing to the original window proc of the framewindow.
// If the framewindow proc is called, for example if the framewindow is put on the screen,
// this proc is called first. At the end of this subclass the handle is passed to the
// original proced.
//-------------------------------------------------------------------------------------------------
MRESULT EXPENTRY NewFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     PFNWP   oldFrameProc ;
     oldFrameProc = (PFNWP) WinQueryWindowULong( hwnd, QWL_USER );      // Pointer from windowword

     switch (msg)
          {
          case WM_QUERYFRAMECTLCOUNT:
               {
               USHORT   itemCount;
               itemCount = SHORT1FROMMR(oldFrameProc(hwnd,msg,mp1,mp2)); //get count of original frame controls
               return ( (MRESULT) (itemCount+2) );                       //add 2 for new controls
               }

           case WM_FORMATFRAME :
               {
               USHORT itemCount = SHORT1FROMMR( oldFrameProc( hwnd, msg, mp1, mp2 ));
               USHORT usClient  = 0,
                      usMinMax  = 0,  // CODE CHANGE !!!!!!!!!!
                      usToolbar = 0,
                      usMenu    = itemCount,
                      usStatus  = itemCount+1;

               PSWP pSWP = (PSWP)PVOIDFROMMP(mp1);

               while (pSWP[usClient].hwnd != WinWindowFromID(hwndFrame, FID_CLIENT))
                    ++usClient;
               // CODE CHANGE !!!!!!!!!!!!!!!! -------------------------------------------------
               while (pSWP[usToolbar].hwnd != hwndToolbar)
                    ++usToolbar;
               // END CODE CHANGE !!!!!!!!!!!! -------------------------------------------------
               while (pSWP[usMinMax].hwnd != WinWindowFromID(hwndFrame, FID_MINMAX))
                    ++usMinMax;

               // CODE CHANGE !!!!!!!!!!!!!!!! -------------------------------------------------
               // Fill in values for the menu
               pSWP[usMenu].fl = pSWP[usToolbar].fl;     // SWP_SIZE style flag
               pSWP[usMenu].cy = pSWP[usClient].cy;      // Heigth
               pSWP[usMenu].cx = pSWP[usClient].cx ;     // width is menu width
               pSWP[usMenu].hwndInsertBehind = HWND_TOP ;// On which window (ONTOP)
               pSWP[usMenu].hwnd = hwndMenu;             // Window handle

                WinSendMsg(pSWP[usMenu].hwnd,            // let the menu code make the adjustments(cy)
                          WM_ADJUSTWINDOWPOS,            // Message WM_ADJUSTWINDOWPOS to hwndTool
                          MPFROMP(pSWP+usMenu),          // mp1 == SWP struct of hwndTool
                          (MPARAM) 0L );                 // mp2 == Leeg */

               // position at top  framewindow
               pSWP[usMenu].x = pSWP[usToolbar].x ;                                        // XPOS in FRAME
               pSWP[usMenu].y = pSWP[usToolbar].y + pSWP[usToolbar].cy - pSWP[usMenu].cy ; // YPOS in FRAME

               pSWP[usToolbar].y = pSWP[usMenu].y - pSWP[usToolbar].cy;
               // END CODE CHANGE !!!!!!!!!!!! -------------------------------------------------


               // adjust client window size for 2nd menu
               // If not, the client window will be placed over the statusbar

               pSWP[usClient].cy= pSWP[usClient].cy - pSWP[usMenu].cy;

               // Fill in values for the statusbar
               pSWP[usStatus].fl = SWP_SIZE | SWP_MOVE;      // SWP_SIZE style flag
               pSWP[usStatus].cy = pSWP[usMinMax].cy;        // Heigth menu hoogte
               pSWP[usStatus].cx = pSWP[usToolbar].cx ;      // width is menu width
               pSWP[usStatus].x = pSWP[usClient].x ;         // XPOS in FRAME
               pSWP[usStatus].y = pSWP[usClient].y ;         // YPOS in FRAME
               pSWP[usStatus].hwndInsertBehind = HWND_TOP ;  // On which window (ONTOP)
               pSWP[usStatus].hwnd = hwndStatus;             // Window handle
               // adjust client window size for 2nd control
               // If not, the client window will be placed over the statusbar
               pSWP[usClient].cy= pSWP[usClient].cy - pSWP[usStatus].cy ;
               pSWP[usClient].y = pSWP[usStatus].y  + pSWP[usStatus].cy ;
               // return total count of frame controls
               return( MRFROMSHORT(itemCount+2));
               }

          default:
               return oldFrameProc(hwnd,msg,mp1,mp2);
          }
     }
