/* stack.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <alloca.h>

void print_esp (void)
{
  unsigned long n;

  n = (unsigned long)&n;
  printf ("ESP = 0x%.8lx\n", n);
}

void mysig (int sig)
{
  printf ("\n---Signal\n");
  exit (1);
}

void test (int level)
{
  int n, fill_flag;
  char buf[10000], *p;

  signal (SIGINT, mysig);   /* DosSetSignalExceptionFocus */
  fill_flag = 0;
  for (;;)
    {
      print_esp ();
      printf ("Input(%d): ", level); fflush (stdout);
      if (fgets (buf, sizeof (buf), stdin) == NULL)
        exit (0);
      p = strchr (buf, '\n');
      if (p != NULL) *p = 0;
      errno = 0;
      if (buf[0] == 0)
        break;
      if (buf[0] == 'r')
        test (level+1);
      else if (buf[0] == 'f')
        fill_flag = !fill_flag;
      else if ((n = strtol (buf, &p, 0)) > 0 && errno == 0 && *p == 0)
        {
          p = alloca (n);
          if (fill_flag)
            memset (p, '*', n);
        }
      else
        printf ("Redo!\n");
    }
}

int main (void)
{
  test (1);
  return 0;
}
