/* sig8.c (emx+gcc) */

/* Link with sigsysv.o (-Zsysv-signals)! */

/* Test System V signal handling. */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

static char flag;

static void sig_ret (int sig)
{
  putchar ('s');
  switch (flag)
    {
    case 'r':
      flag = 0;
      putchar ('r');
      signal (sig, sig_ret);
      raise (sig);
      break;
    case 'R':
      flag = 0;
      putchar ('R');
      raise (sig);
      break;
    default:
      signal (sig, sig_ret);
      break;
    }
}


int main (int argc, char *argv[])
{
  setvbuf (stdout, NULL, _IONBF, 0);

  signal (SIGINT, sig_ret);

  printf ("Expected output: +s+s+srs+s+sR\n");
  printf ("Actual output:   ");
  flag = 0;
  putchar ('+');
  raise (SIGINT);
  putchar ('+');
  raise (SIGINT);
  putchar ('+');
  flag = 'r';
  raise (SIGINT);
  putchar ('+');
  raise (SIGINT);
  flag = 'R';
  putchar ('+');
  raise (SIGINT);
  printf ("You should not see this text.\n");
  return 0;
}
