/* fullpath.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <sys/param.h>

#define FALSE 0
#define TRUE  1

static void usage (void);


static void usage (void)
{
  fputs ("Usage: [-acsw] fullpath <file> ...\n", stderr);
  exit (1);
}


int main (int argc, char *argv[])
{
  int c, i, rc, abs_flag, split_flag, cwd_flag, wd_flag;
  char buf[MAXPATHLEN+1];
  char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

  rc = 0;
  abs_flag = FALSE; split_flag = FALSE; cwd_flag = FALSE; wd_flag = 0;
  while ((c = getopt (argc, argv, "acsw")) != -1)
    switch (c)
      {
      case 'a':
        abs_flag = TRUE;
        break;
      case 'c':
        cwd_flag = TRUE;
        break;
      case 's':
        split_flag = TRUE;
        break;
      case 'w':
        wd_flag = TRUE;
        break;
      default:
        usage ();
      }
  if (!(optind < argc || cwd_flag || wd_flag))
    usage ();
  if (cwd_flag)
    {
      if (getcwd (buf, sizeof (buf)) != NULL)
        printf ("getcwd: %s\n", buf);
      else
        {
          rc = 2;
          perror ("getcwd");
        }
    }
  if (wd_flag)
    {
      if (getwd (buf) != NULL)
        printf ("getwd: %s\n", buf);
      else
        {
          rc = 2;
          fprintf (stderr, "getwd error: %s\n", buf);
        }
    }
  for (i = optind; i < argc; ++i)
    {
      if (split_flag)
        {
          _splitpath (argv[i], drive, dir, fname, ext);
          printf ("path  = %s\n", argv[i]);
          printf ("drive = %s\n", drive);
          printf ("dir   = %s\n", dir);
          printf ("fname = %s\n", fname);
          printf ("ext   = %s\n", ext);
        }
      if (abs_flag)
        {
          if (_abspath (buf, argv[i], sizeof (buf)) == 0)
            puts (buf);
          else
            {
              rc = 2;
              fprintf (stderr, "abspath %s failed\n", argv[i]);
            }
        }
      else
        {
          if (_fullpath (buf, argv[i], sizeof (buf)) == 0)
            puts (buf);
          else
            {
              rc = 2;
              fprintf (stderr, "fullpath %s failed\n", argv[i]);
            }
        }
    }
  return rc;
}
