
;
; A simple Fade-in and Fade-out routine.
;

ideal
p386n

segment code
assume cs:code
org 100h

start:
                mov     ax,13h                  ; Guess
                int     10h
                call    write_palette           ; Call
                push    0a000h                  ; Destenation now is VgaSeg.
                pop     es
                lea     si,[picture]            ; write picture to VgaSeg.
                mov     di,46*320
                mov     cx,107*80
                rep     movsd

                mov     bp,63                   ; fade in loop
fade_in_loop:   mov     cx,4
                call    vwait
                call    fade_in
                call    write_palette
                dec     bp
                jnz     fade_in_loop

                xor     ax,ax                   ; wait for a key press
                int     16h

                mov     bp,63                   ; fade out loop
fade_out_loop:  mov     cx,4
                call    vwait
                call    fade_out
                call    write_palette
                dec     bp
                jnz     fade_out_loop

                mov     ax,3                    ; texmode reset
                int     10h
                mov     ah,9                    ; drop ending text
                lea     dx,[endline]
                int     21h
                mov     ax,4c00h                ; return to operating system
                int     21h

        ;
        ; ------------------------------
        ;

proc            fade_in                         ; fade in palette
                xor     bx,bx
@@full_fade:    mov     al,[palette+bx]
                cmp     [pal_buf+bx],al
                je      no_inc
                inc     [pal_buf+bx]
no_inc:         inc     bx
                cmp     bx,768
                jne     @@full_fade
                ret
endp            fade_in

proc            fade_out                        ; fade out palette
                xor     bx,bx
@@full_fade:    cmp     [pal_buf+bx],0
                je      no_dec
                dec     [pal_buf+bx]
no_dec:         inc     bx
                cmp     bx,768
                jne     @@full_fade
                ret
endp            fade_out

proc            write_palette                   ; Write palette to port
                mov     dx,3c8h                 ; Writes the buffer,
                lea     si,[pal_buf]            ; not the palette!
                mov     cx,768                  ; the buffer is for the
                xor     al,al                   ; compare loop with fade in.
                out     dx,al
                inc     dx
                rep     outsb
                ret
endp            write_palette

proc            vwait                           ; Vertical Wait
                mov     dx,3dah
v1:             in      al,dx
                test    al,8
                jne     $-3
                in      al,dx
                test    al,8
                je      $-3
                loop    v1
                ret
endp            vwait

        ;
        ; ------------------------------
        ;

  include       "picpal.db"

  endline       db 'Graphics by PiNO / GROUND ZERO!',13,10
                db 'Please don''t use this picture for own use!',13,10
                db 'because it isn''t finished and shit',13,10
                db 'whoever uses this piece of un-finished art',13,10
                db 'will be punished within 24 hours...',13,10
                db 'A warned lamer counts for 2 :)',13,10
                db 24h

  pal_buf       db 768 dup (0)                  ; total blackness 4 fade in

ends code
end start

