;-------------------------------------------
;--  TXT mode scroller "intro"          ----
;--  by LK of Napalm Software         ----
;--  This source is freeware;           ----
;--  You may use this as you want.      ----
;-------------------------------------------
;-- IMPORTANT NOTES:                     ---
;--  This program does not check if the   --
;-- system has a VGA or not. So result    --
;-- will be a nice crash with systems     --
;-- without VGA!                          --
;--  When you compile this, the resulting --
;-- EXE file will be larger than my COM   --
;-------------------------------------------

code    segment
        assume cs:code, ds:code

start:
  jmp proggis            ;Jump to main part of program

wait_retrace proc near   ;Wait for VRI signal
  push ax                
  push dx
  mov dx,03dah
  @waitr:
  in  al,dx
  and al,8
  cmp al,8
  jne @waitr
  pop ax
  pop dx
  ret
wait_retrace endp

wait_display proc near   ;Wait "display enable"
  push ax                ;Don't change registers
  push dx
  mov  dx,03dah
  @waitd:
  in   al,dx
  and  al,8
  cmp  al,8
  je   @waitd
  pop  dx
  pop  ax
  ret
wait_display endp

set_scrstart proc near       ;Set CRTC start offset
;--------------------------
;-CX is new start offset --
;--------------------------
  push dx
  push ax
  cli
  mov  al,0ch                ;Set HB 
  mov  dx,03d4h
  out  dx,al
  inc  dx
  mov  ax,cx                 
  mov  al,ah
  out  dx,al
  dec  dx
  mov  al,0dh                ;Set LB
  out  dx,al
  inc  dx
  mov  ax,cx
  out  dx,al
  sti
  pop  ax
  pop  dx
  ret
set_scrstart endp

preset_rowscan proc near       ;Preset row scan to perform smooth one pixel scroll
;----------------------
;-CL is preset count --
;----------------------
  push dx                      ;Sure is sure...
  push ax
  mov  dx,03d4h
  mov  al,8                    ;Select preset row scan register
  out  dx,al
  inc  dx
  in   al,dx
  and  al,0e0h
  mov  ah,cl
  and  ah,0fh
  or   al,ah
  out  dx,al
  pop  ax
  pop  dx
  ret
preset_rowscan endp

setscan_start proc near    ;Set new starting scanline 
;------------------------  ;This is the actual scroll routine
;-BX is new scan start --
;------------------------
  push dx
  push ax
  push cx
  mov  ax,bx
  mov  cx,80
  shr  ax,1
  shr  ax,1
  shr  ax,1
  shr  ax,1
  mul  cx                  
  mov  cx,ax
  cli                      ;NO INTERRUPTS
  call wait_display        ;Make scroll synchronization stuff
  call set_scrstart
  call wait_retrace
  mov  cx,bx
  call preset_rowscan
  sti                          
  pop  cx
  pop  ax
  pop  dx
  ret
setscan_start endp

proggis:                ;Main program starts here!
  mov   ax,0b800h
  mov   es,ax
  mov   di,4000         ;First set all to white
  mov   cx,4000
  mov   ax,15
  rep   stosb
  mov   di,8000-5*160-50 ;50 is for the trash in the end if the 1st line
  xor   ax,ax
  mov   cx,5*80
  rep   stosw           ;Clear rows 20-25 
  mov   ah,0            ;Get timer counters
  int   1ah
  mov   ax,dx           ;Put AX LO counter -> get random color for text!
  and   ax,15           ;Disable background attributes
  or    ax,1            ;Make sure that color is not black!
  mov   di,4000+160*10
  mov   cx,9*160
  rep   stosb
  mov   ax,seg imagedata
  mov   ds,ax
  mov   bp,offset imagedata
  mov   di,4000
loopp:                  ;Copy image to video mem
  mov   al,[ds:bp]
  mov   [es:di],al
  inc   di
  inc   bp
  inc   di
  cmp   di,8000-5*80
  jge   exitt1
  jmp   loopp
exitt1:
  mov   si,4000
  mov   di,8000-5*160
  mov   cx,5*80
  mov   ax,es
  mov   ds,ax
  cld   
  rep   movsw           ;Copy upper "NAPALM" to lowest 5 rows
  mov   bp,8001-5*160   
  mov   al,10
loop2:
  mov   [es:bp],al      ;Put it with color 10
  inc   bp
  inc   bp
  cmp   bp,8001
  jg    exitt2
  jmp   loop2
exitt2:                 ;Here's the actual scroll routine
  xor   cx,cx
  xor   bx,bx
  loop1:
  call setscan_start
  inc  cx
  mov  ax,cx
  shr  ax,1
  shr  ax,1
  shr  ax,1
  add  bx,ax
  cmp  bx,25*16+8
  jge  exitt            ;Scroll complete?
  jmp  loop1
  exitt:
  mov ax,0              ;Wait a keyhit signal from user
  int 16h
  mov ah,63             ;Start from white, perform a "flash" on screen
  set_pal:              ;Set palette registers
  mov dx,03dah          ;Wait for retrace to sync palette setup
  @waitrr:
  in  al,dx
  and al,8
  cmp al,8
  jne @waitrr
  mov dx,3c8h           ;Palette index register to 0
  mov al,0
  out dx,al
  inc dx                ;Palette data register
  mov al,ah             ;Take AH
  mov cx,255*3          ;Do all 256 registers
  @loopa:
  out dx,al
  loop @loopa           ;Loop palette setting for all registers
  dec  ah               ;Decrement counter
  cmp  ah,0             ;Is it black?
  je   away
  jmp  set_pal
  away:                 ;Perform "exit to dos"
  mov ax,0003           ;Reset VGA to mode 3 for default palette
  int 10h               
  mov ax,4c00h          ;Exit, with exit code 0
  int 21h

IMAGEDATA LABEL BYTE    
        DB      '                     '
        DB      '                                   '
        DB      '                        '
        DB      '                           '
        DB      '                                  '
        DB      '               '
        DB      '                                                   '
        DB      '                                                   '
        DB      '       '
        DB      '                   '
        DB      '                 '
        DB      '                      '
        DB      '                   '
        DB      '                  '
        DB      '                                                   '
        DB      '                                           We progr'
        DB      'am games, utilities, intros ... ANYTHING!          '
        DB      '                                                   '
        DB      '                                                  C'
        DB      'urrently we are programming with Turbo Pascal and A'
        DB      'SM, but                     C may be our future too'
        DB      'l.                                                 '
        DB      '                                                   '
        DB      '                                   Members of Napal'
        DB      'm Soft :                                           '
        DB      '               Antti Virtanen alias LK(Creator of'
        DB      ' this "intro")                              Tapio '
        DB      'ijl                                              '
        DB      '                                                   '
        DB      '                                                 As'
        DB      ' you may see, few more dudes wouldn',39,'t be bad! '

code  ends
      end start
