{ For a brief summary of the routine look TEXTURE.DOC }
{ Also for those of you who can't code Pascal ... }

PROGRAM TextureScreen;
USES
    Crt,MCGA;
VAR
   I,J,Degree,Direction:Integer;
   TextSpr,BigSpr:Pointer;
   ScreenX,ScreenY:Integer;

PROCEDURE PutTexture(IncX,IncY:Integer; P:Pointer);
VAR
   XSize,YSize,XS8,YS8:Word;
   X,Y,PosX,PosY,PX,PY:Integer;
BEGIN
     XSize:=SpriteXSize(P);
     YSize:=SpriteXSize(P);
     XS8:=XSize SHL 8;
     YS8:=YSize SHL 8;
     PosX:=-(ScreenX SHR 1)*IncX;
     PosY:=-(ScreenY SHR 1)*IncY;
     FOR Y:=0 TO ScreenY-1 DO
     BEGIN
          PX:=PosX;
          PY:=PosY;
          ASM
             push ds
             mov ax,0a000h
             mov es,ax
             mov ax,y
             xchg al,ah
             mov di,ax
             shr di,2
             add di,ax
             mov cx,screenx
             shr cx,1
             lds si,p
             cld
             mov ax,incx
             db 66h
             shl ax,16
             mov ax,incy
             db 66h
             mov si,ax
             mov dx,px
             db 66h
             shl dx,16
             mov dx,py
@1:          db 66h
             add dx,si
             db 66h
             mov bx,dx
             db 66h
             shr bx,16
             mov bl,dh
             mov al,[bx]
             db 66h
             add dx,si
             db 66h
             mov bx,dx
             db 66h
             shr bx,16
             mov bl,dh
             mov ah,[bx]
             stosw
             dec cx
             jnz @1
             pop ds
          END;
          Inc(PosX,IncY);
          Inc(PosY,-IncX);
     END;
END;

BEGIN
     Write('X-Size of screen=');
     ReadLn(ScreenX);
     Write('Y-Size of screen=');
     ReadLn(ScreenY);
     MCGAOn;
     LoadPalette('KEWLAARD');
     LoadSprite('KEWLAARD',TextSpr);
     GetMem(BigSpr,65535);   { BigSpr -> Pointer to 64k Array [255][255] }
     IF Ofs(BigSpr)<>0 THEN
        BigSpr:=Ptr(Seg(BigSpr^)+1,0);
     FOR J:=0 TO 199 DO
         FOR I:=0 TO 255 DO
             Mem[Seg(BigSpr^):Word(J) SHL 8+I]:=Mem[Seg(TextSpr^):4+Word(J)*320+I];
     FillChar(Ptr(Seg(BigSpr^),51200)^,14336,0);
     Degree:=0;   { Degree is used for both rotating and zooming values! }
     Direction:=1;
     REPEAT
           VerticalRetrace;
           PutTexture(Round(4*Degree*Sin(Degree/180*Pi)),Round(4*Degree*Cos(Degree/180*Pi)),BigSpr);
           Inc(Degree,Direction);
           IF (Degree=0) OR (Degree=360) THEN
              Direction:=-Direction;
     UNTIL KeyPressed;
     MCGAOff;
END.

{ It's floating point Sin and Cosine calculations, call it lame, but I don't
  want to spend 5 minutes to make this 0.5% faster =)                    }
