
PROGRAM SpaceDemo;
USES
  driver,graph,graph3d;

CONST
  NumStars = 32;

TYPE StarPos = ARRAY[0..NumStars] OF TPoint3D;

VAR
  Stars : StarPos;
{----------------------------------------------------------------------------}

PROCEDURE Init;

VAR
  I : integer;

BEGIN
  randomize;
  FOR I := 0 TO NumStars DO
   BEGIN
    Stars[I].X := random(100)-50;
    Stars[I].Y := random(100)-50;
    Stars[I].Z := I*200 DIV NumStars;
   END;
 FOR i:=0 TO 63 DO
  BEGIN
   SetPaletteRGB(I,I,I,I);
  END;
END;

{----------------------------------------------------------------------------}

PROCEDURE ShowSPace;

VAR
  x,y:integer;
  I,Color : byte;
  Speed:integer;
PROCEDURE AddBall(num:integer);
BEGIN
 WHILE Num>0 DO
  BEGIN
   Stars[Num]:=Stars[Num-1];
   dec(num);
  END;

  Stars[0].X := random(100)-50;
  Stars[0].Y := random(100)-50;
  Stars[0].Z := 0
END;
BEGIN
 CursorRange(0,0,GetMaxX,GetMaxY);
 MoveCursor(160,100);
 Speed:=8;
  REPEAT
    SetOrigin3D(GetCursorX,GetCursorY,200);
    SetActivePage(1-GetActivePage);
    fillpage(0);
    Clearkeyboard;
    FOR I := 0 TO NumStars DO
     BEGIN
      WITH Stars[I] DO
       BEGIN
        inc(z,speed);
        SetColor(Z SHR 2);
        fillcircle3d(x,y,z,1);
        IF ((speed>0) AND (z>=200)) OR ((speed<0) AND (z<=0))
          THEN AddBall(I);
       END;
    END;
   retrace;
   SetVisualPage(GetActivePage);
  UNTIL keypressed;
END;

{----------------------------------------------------------------------------}
VAR x1,y1,x2,y2:integer;
BEGIN
 CursorMovement(Relative);
 RelativeMovement(8,8);
 IF testCard(VGA)
  THEN
   BEGIN
   IF JoystickAvail
    THEN
     BEGIN
      Writeln('Move joystick to Top left corner then press the button');
      REPEAT
       x1:=GetJoystickX;
       y1:=GetJoystickY;
      UNTIL GetJoystickButton AND $f0<>$f0;

      REPEAT UNTIL GetJoystickButton AND $f0=$f0;

      Writeln('Move joystick to Bottom Right corner then press the button');
      REPEAT
       x2:=GetJoystickX;
       y2:=GetJoystickY;
      UNTIL GetJoystickButton AND $f0<>$f0;
     JoystickLimits(x1,y1,x2,y2);
     SetCursor(Joystick);
    END
     ELSE
      IF MouseAvail
       THEN
        BEGIN
         CursorMovement(ABSOLUTE);
         SetCursor(Mouse)
        END
         ELSE
          BEGIN
           Writeln('You Need a Joystick or a mouse to run this demo.');
           exit;
          END;
    SetMode(20);
    Init;
    ShowSpace;
    SetMode(3);
   END
    ELSE
     writeln('You need a VGA card to run this program');
END.
