UNIT Tactics;
  {Tactical routines for Fumiko}


INTERFACE


  USES
    GloblCTV, Arcana, GroupMgr, BrdHndlr;


  PROCEDURE Grab_Territory (var board: board_type; player: color_type; var move: location_list;
                              var weights: integer_board; depth: byte);
    {Plays in wide-open areas}


  PROCEDURE Defend_Groups (var board: board_type; player: color_type; var move: location_list; depth: byte);
    {Defends weak groups}


  PROCEDURE Attack_Opponent (var board: board_type; player: color_type; var move: location_list; depth: byte);
    {Attacks weak groups}


  PROCEDURE Push (var board: board_type; player: color_type; var move: location_list; var weights: integer_board; depth: byte);
    {Plays on opponent's side of borders}


  PROCEDURE Invade (var board: board_type; player: color_type; var move: location_list;
                      var weights: integer_board; depth: byte);
    {Plays inside loose enemy territory}


  PROCEDURE Seal_Up (var board: board_type; player: color_type; var move: location_list;
                       var weights: integer_board; depth: byte);
    {Plays on own side of borders}


IMPLEMENTATION


  USES
    Sequence;


  FUNCTION Border (var x, y: byte; var weights: integer_board): boolean;
    {Returns true if the space is on the edge of an influence area.  LOCAL}
    Var
      direction: direction_type;
      neighbor: location_type;
      positive, negative: boolean;
    Begin  {Border}
      positive := false;
      negative := false;
      For direction := north to west do
        Begin
          neighbor := neighbors [x, y, direction];
          If on_board (neighbor.x, neighbor.y)
            Then Case weights [neighbor.x, neighbor.y] of
                   (-maxint - 1)..-1: negative := true;
                   0: Begin
                        positive := true;
                        negative := true
                      End;
                   1..maxint: positive := true
                 End
        End;
      border := negative and positive
    End;  {Border}


  PROCEDURE Grab_Territory (var board: board_type; player: color_type; var move: location_list;
                              var weights: integer_board; depth: byte);
    {Plays in wide-open areas}
    Var
      x, y: byte;
    Begin  {Grab Territory}
      WriteLn ('I''l take some of that territory...');
      For x := 1 to board_size do
        For y := 1 to board_size do
          If (weights [x, y] = 0) and legal_move (x, y, player, board) and not suicidal (x, y, player, board)
            Then weights [x, y] := 10000 + terrain [x, y]
            Else weights [x, y] := (10000 div abs (weights [x, y])) + terrain [x, y];
      move := highest_rated (weights)
    End;  {Grab Territory}

  PROCEDURE Defend_Groups (var board: board_type; player: color_type; var move: location_list; depth: byte);
    {Defends weak groups}
    Var
      value: integer_board;
      count, garbage: byte;
    Begin  {Defend Groups}
      WriteLn ('I''m a little nervous about these guys');
      value := zero_board;
      count := 1;
      While board.groups [count]^.size <> 0 do
        With board.groups [count]^ do
          Begin
            If (owner = player) and (aliveness in [3..5])
              Then If on_board (to_save.x, to_save.y) and legal_move (to_save.x, to_save.y, player, board)
                        and not suicidal (to_save.x, to_save.y, player, board)
                     Then Inc (value [to_save.x, to_save.y], size)
                     Else Begin
                            garbage := Life (board.groups [count]^, player, board, depth, to_save);
                            If on_board (to_save.x, to_save.y)
                              Then Inc (value [to_save.x, to_save.y], size)
                          End;
            Inc (count)
          End;
      move := highest_rated (value)
    End;  {Defend Groups}


  PROCEDURE Attack_Opponent (var board: board_type; player: color_type; var move: location_list; depth: byte);
    {Attacks weak groups}
    Var
      value: integer_board;
      count, garbage: byte;
    Begin  {Attack Opponent}
      WriteLn ('Die, Pink boy!');
      value := zero_board;
      count := 1;
      While board.groups [count]^.size <> 0 do
        With board.groups [count]^ do
          Begin
            If (owner = opposite (player)) and (aliveness in [3..5])
              Then If on_board (to_kill.x, to_kill.y) and legal_move (to_kill.x, to_kill.y, player, board)
                        and not suicidal (to_kill.x, to_kill.y, player, board)
                     Then Inc (value [to_kill.x, to_kill.y], size)
                     Else Begin
                            garbage := Life (board.groups [count]^, player, board, depth, to_kill);
                            If on_board (to_kill.x, to_kill.y)
                              Then Inc (value [to_kill.x, to_kill.y], size)
                          End;
            Inc (count)
          End;
      move := highest_rated (value)
    End;  {Attack Opponent}


  PROCEDURE Push (var board: board_type; player: color_type; var move: location_list; var weights: integer_board; depth: byte);
    {Plays on opponent's side of borders}
    Var
      x, y: byte;
      value: integer_board;
    Begin  {Push}
      WriteLn ('I just need a few more points...');
      If player = white_stone
        Then For x := 1 to board_size do
               For y := 1 to board_size do
                 weights [x, y] := - weights [x, y];
      For x := 1 to board_size do
        For y := 1 to board_size do
          If (weights [x, y] < 0) and border (x, y, weights)
               and legal_move (x, y, player, board) and not suicidal (x, y, player, board)
            Then value [x, y] := terrain [x, y] + weights [x, y]
            Else value [x, y] := 0;
      move := highest_rated (value)
    End;  {Push}


  PROCEDURE Invade (var board: board_type; player: color_type; var move: location_list;
                      var weights: integer_board; depth: byte);
    {Plays inside loose enemy territory}
    Var
      x, y: byte;
      value: integer_board;
    Begin  {Invade}
      WriteLn ('Geronimo!');
      If player = white_stone
        Then For x := 1 to board_size do
               For y := 1 to board_size do
                 weights [x, y] := - weights [x, y];
      For x := 1 to board_size do
        For y := 1 to board_size do
          If (weights [x, y] < 0) and maneuvering_room (x, y, player, board)
               and legal_move (x, y, player, board) and not suicidal (x, y, player, board)
            Then value [x, y] := terrain [x, y] + weights [x, y]
            Else value [x, y] := 0;
      move := highest_rated (value)
    End;  {Invade}


  PROCEDURE Seal_Up (var board: board_type; player: color_type; var move: location_list;
                       var weights: integer_board; depth: byte);
    {Plays on own side of borders}
    Var
      x, y: byte;
      value: integer_board;
    Begin  {Seal Up}
      WriteLn ('I don''t have to be greedy.');
      If player = white_stone
        Then For x := 1 to board_size do
               For y := 1 to board_size do
                 weights [x, y] := - weights [x, y];
      For x := 1 to board_size do
        For y := 1 to board_size do
          If (weights [x, y] > 0) and border (x, y, weights)
               and legal_move (x, y, player, board) and not suicidal (x, y, player, board)
            Then value [x, y] := (maxint - weights [x, y]) + terrain [x, y]
            Else value [x, y] := 0;
      move := highest_rated (value)
    End;  {Seal Up}


END.  {Tactics}

