{****************************************************************************

                     Copyright (c) 1996,97 by Florian Klaempfl

 ****************************************************************************}

{
  this units contains special support for the GDB
}

unit gdb;


  interface

    uses
       strings,cobjects,globals,aasm;

    {stab constants }
Const
    N_GSYM = $20;
    N_STSYM = 38; {initialized const }
    N_LCSYM = 40; {non initialized variable}
    N_Function = $22; {function or const }
    N_TextLine = $44;
    N_DataLine = $46;
    N_BssLine = $48;
    N_LSYM = $80;
    N_PSYM = 160;
    N_SourceFile = $64;
    N_IncludeFile = $84;
    N_BINCL = $82;
    N_EINCL = $A2;
    N_EXCL  = $C2;

    type
       pai_stabs = ^tai_stabs;

       tai_stabs = object(tai)
          str : pchar;
          constructor init(_str : pchar);
          destructor done; virtual;
       end;

       pai_stabn = ^tai_stabn;

       tai_stabn = object(tai)
          str : pchar;
          constructor init(_str : pchar);
          destructor done; virtual;
       end;

       pai_stab_function_name = ^tai_stab_function_name;

       tai_stab_function_name = object(tai)
          str : pchar;
          constructor init(_str : pchar);
          destructor done; virtual;
       end;

const          DBX_counter : plongint = nil;
               do_count_dbx : boolean = false;

  implementation

{$IfDef DBX}

{ to use N_EXCL we have to count the character in the stabs for
N_BINCL to N_EINCL
  Code comes from stabs.c for ld
      if (type == N_BINCL)
	(
	  bfd_vma val;
	  int nest;
	  bfd_byte *incl_sym;
	  struct stab_link_includes_entry *incl_entry;
	  struct stab_link_includes_totals *t;
	  struct stab_excl_list *ne;

	  val = 0;
	  nest = 0;
	  for (incl_sym = sym + STABSIZE;
	       incl_sym < symend;
	       incl_sym += STABSIZE)
	    (
	      int incl_type;

	      incl_type = incl_sym[TYPEOFF];
	      if (incl_type == 0)
		break;
	      else if (incl_type == N_EINCL)
		(
		  if (nest == 0)
		    break;
		  --nest;
		)
	      else if (incl_type == N_BINCL)
		++nest;
	      else if (nest == 0)
		(
		  const char *str;

		  str = ((char *) stabstrbuf
			 + stroff
			 + bfd_get_32 (abfd, incl_sym + STRDXOFF));
		  for (; *str != '\0'; str++)
		    (
		      val += *str;
		      if (*str == '(')
			(
			   Skip the file number.
			  ++str;
			  while (isdigit ((unsigned char) *str))
			    ++str;
			  --str;
			)
		    )
		)
	    ) }


   procedure count_dbx(st : pchar);
     var i : longint;
         do_count : boolean;
     begin
     do_count := false;
     if dbx_counter = nil then
     else
       begin
{$IfDef ExtDebug }
        writeln('counting ',st);
        writeln('count =  ',dbx_counter^);
        writeln('addr = ',longint(dbx_counter));
{$EndIf ExtDebug }
          for i:=0 to strlen(st) do
            begin
               if st[i] = '"' then
                 if do_count then exit
                 else do_count := true
               else
               if do_count then
                 begin
                   dbx_counter^ := dbx_counter^+byte(st[i]);
                   if st[i] = '(' then
                     begin
                        inc(i);
                        while st[i] in ['0'..'9'] do inc(i);
                        dec(i);
                     end;
                 end;
            end;
       end;
     end;

{$EndIf DBX}

    constructor tai_stabs.init(_str : pchar);

      begin
         inherited init;
         typ:=ait_stabs;
         str:=_str;
{$IfDef DBX}
         if do_count_dbx then
           begin
              count_dbx(str);
              do_count_dbx := false;
           end;
{$EndIf DBX}
      end;

    destructor tai_stabs.done;

      begin
         strdispose(str);
         inherited done;
      end;

    constructor tai_stabn.init(_str : pchar);

      begin
         inherited init;
         typ:=ait_stabn;
         str:=_str;
      end;

    destructor tai_stabn.done;

      begin
         strdispose(str);
         inherited done;
      end;

    constructor tai_stab_function_name.init(_str : pchar);

      begin
         inherited init;
         typ:=ait_stab_function_name;
         str:=_str;
      end;

    destructor tai_stab_function_name.done;

      begin
         strdispose(str);
         inherited done;
      end;
end.

