{****************************************************************************

                      Copyright (c) 1996 by Florian Klaempfl

 ****************************************************************************}

{
  this unit exports some routines for the reading of assembler for the i386

  History:
       9th december 1996:
         + created from scratch (and rai386)
      13th december 1996:
         + support of direct asm (old styled like <=0.6.x)

  What's to do:
}
unit rasm386;

  interface

    uses
       cobjects,globals,errors,aasm,symtable,scanner,tree,i386,attasmi3;

    type
       ti386asmmode = (I386_ATT,I386_INTEL,I386_DIRECT);

       tasmtoken = (A_LKLAMMER,A_RKLAMMER,A_KLAMMERAFFE,A_SEPERATOR,A_END,
         A_DB,A_DW,A_DD,A_DT,A_DF,A_DP,A_DQ,A_ID,A_PERCENT,A_DOLLAR);

       tasmkeyword = string[6];
       tkeywords = array[0..255] of tasmkeyword;
       tkeyword_tokens = array[0..255] of tasmtoken;

    var
       actasmtoken : tasmtoken;
       actasmpattern : string;
       count_asmkeywords : longint;
       asmkeywords : ^tkeywords;
       asmkeyword_token : ^tkeyword_tokens;

    const
       { the current mode which is in assembler blocks assumed }
       aktasmmode : ti386asmmode = I386_DIRECT;

    function gettoken : tasmtoken;
    procedure consume(t : tasmtoken);

  implementation

    function is_asmkeyword(var token : tasmtoken) : boolean;

      var
         m,n,k : integer;

      begin
         { one char is never a keyword }
         if length(actasmpattern)<=1 then
           begin
              is_asmkeyword:=false;
              exit;
           end;

         m:=1;
         n:=count_asmkeywords;
         while m<=n do
           begin
              k:=m+(n-m) div 2;
              if actasmpattern=asmkeywords^[k] then
                begin
                   token:=asmkeyword_token^[k];
                   is_asmkeyword:=true;
                   exit;
                end
              else if actasmpattern>asmkeywords^[k] then m:=k+1 else n:=k-1;
          end;
        is_asmkeyword:=false;
     end;

    procedure consume(t : tasmtoken);

      begin
         if t<>actasmtoken then
           error(_asm_syntax_error);
         actasmtoken:=gettoken;
      end;

    function gettoken : tasmtoken;

      var
         ht : tasmtoken;

      begin
         while (c=' ') or (c=#9) do
           c:=asmgetchar;
         case c of
            'A'..'Z','a'..'z','_' : begin
                         actasmpattern:=c;
                         c:=asmgetchar;
                         while ((ord(c)>=ord('A')) and (ord(c)<=ord('Z')))
                            or ((ord(c)>=ord('a')) and (ord(c)<=ord('z')))
                            or ((ord(c)>=ord('0')) and (ord(c)<=ord('9')))
                            or (c='_') do
                           begin
                              actasmpattern:=actasmpattern+c;
                              c:=asmgetchar;
                           end;
                           uppervar(actasmpattern);
                           { check for keywords }
                           if is_asmkeyword(ht) then
                             gettoken:=ht
                           else
                             gettoken:=A_ID;
                         end;
            '%' : begin
                     c:=asmgetchar;
                     gettoken:=A_PERCENT;
                  end;
            '{',#10,#13,';' : begin
                     { the comment is read by asmgetchar }
                     c:=asmgetchar;
                     gettoken:=A_SEPERATOR;
                  end;
            else error(ill_character);
         end;
      end;

end.
