{****************************************************************************

                      Copyright (c) 1996,97 by Florian Klaempfl

 ****************************************************************************}

{

  this unit calls the compiler and restores the heap state etc.

  History:
       5th november 1996:
         + unit started

       2th december 1996:
         + the tcompilestatus call is implemented in the scanner unit
         + implement the init and done code for the compiler call

  What's to do:
    o store and restore heap to disk
    o verbose and very verbose
    o pm (DPMI) support
    o test with FPKPascal
}
unit compiler;

  interface

    uses
       dos,sysutils,errors,globals,systems,tree,symtable,parser;

    { this must be called to execute the compiler
      what's to do before call:
      1) nothing (removed)

      2) install your own error handlers (if needed)
         (assign to errors.do_* your own procedures
          where * means warning, error, fatalerror and
          internalerror)

      3) install a handler which sets the switches to values given by the
         IDE

        Notes: - Verbose and very verbose work only
                 for a command line compiler


      4) setup exepath to the compiler executable

        Notes: - Don't allocate memory while in the error handler (or in
                 the status proc), because the old state of the heap
                 heap is restored after compile
               - To stop compiler execution return from an error handler or the
                 status handler with true (else the result must be false !!!!!)
               - To get the error message text for an error/warning
                 look at errors.geterrormsg

      5) call compiler.compile

        Notes: - the file filename must exist

      General notes:
             - This procedure works only for a real mode version
             - The types tcompilestatus and tcompilestatusproc are
               defined in the unit GLOBALS

    }
    procedure compile(const filename : string;_statusproc : tcompilestatusproc);

    var
       setcompilerswitches : procedure;

  implementation

    var
       recoverpos : tjmprec;

    procedure default_stop;far;

      begin
         longjmp(recoverpos,1);
      end;

    procedure compile(const filename : string;_statusproc : tcompilestatusproc);

      var
         oldfreelist,oldheapptr,oldheaporg,oldheapend : pointer;
         fdir : dirstr;
         fname : namestr;
         fext : extstr;

      begin
         compilestatusproc:=_statusproc;
         { install another handler for stops }
{$ifdef tp}
         do_stop:=default_stop;
{$else}
         do_stop:=@default_stop;
{$endif}
         { save heap state: }
         oldfreelist:=freelist;
         oldheapptr:=heapptr;
         oldheaporg:=heaporg;

         { make a new heap }
         heaporg:=oldheapptr;
         heapptr:=heaporg;
         freelist:=heaporg;

         { init some units }

         { inits only node management }
         init_tree;

         globalsinit;
         init_symtable;

         { call  *** after ***  init_symtable because macro }
         { symtable must be inited...                       }
         setcompilerswitches;

         { do some definitions which are done only once }
         initparser;

         fsplit(filename,fdir,fname,fext);

         { now we're ready to start the compiler }

         { mark the current position }
         if setjmp(recoverpos)=0 then
           begin
              { call the compiler }
              parser.compile(fdir,fname,fext);
           end;

         { restore the heap }
         freelist:=oldfreelist;
         heapptr:=oldheapptr;
         heaporg:=oldheaporg;
      end;

  end.
