{ ----------------------------------------------------------------- }
                             UNIT Mouse;
{ -----------------------------------------------------------------

                 AzzaMouse v1.0 - last update 31/10/94
                 -------------------------------------

 (c) Aaron ARDIRI, November 1994 - email : ardiriaj@cs.curtin.edu.au

   thus unit  has been written for the usage for possible graphics
   that are available  through  the Turbo Pascal v5.0+ graph units
   and BGI files.

    ( it was designed using the SVGA 1024x768, 256c resolution ).

  -----------------------------------------------------------------

    NB: please read the README.1st before using this unit for the
        usual  crap about  copyright - and what is available, and
        future upgrades etc...

  ----------------------------------------------------------------- }

{ ----------------------------------------------------------------- }
                             INTERFACE
{ ----------------------------------------------------------------- }

CONST
  COMPort  = $03F8;
  COMIntr  = $000C;

  ROMMSize  = 16;
  ROMMouseI : ARRAY[ 0..(ROMMSize - 1), 0..(ROMMSize - 1) ] OF BYTE
            = (
                ( 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,15,15,15,15,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,15,15,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,15,15,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,15,15,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,15,15,15,15,00,00,00,00,00,00 ),
                ( 00,15,00,00,00,15,15,00,00,15,15,00,00,00,15,00 ),
                ( 00,15,15,15,15,15,00,00,00,00,15,15,15,15,15,00 ),
                ( 00,15,15,15,15,15,00,00,00,00,15,15,15,15,15,00 ),
                ( 00,15,00,00,00,15,15,00,00,15,15,00,00,00,15,00 ),
                ( 00,00,00,00,00,00,15,15,15,15,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,15,15,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,15,15,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,15,15,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,15,15,15,15,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 )
              );
  ROMMouseM : ARRAY[ 0..(ROMMSize - 1), 0..(ROMMSize - 1) ] OF BYTE
            = (
                ( 15,15,15,15,15,00,00,00,00,00,00,15,15,15,15,15 ),
                ( 15,15,15,15,15,00,00,00,00,00,00,15,15,15,15,15 ),
                ( 15,15,15,15,15,00,00,00,00,00,00,15,15,15,15,15 ),
                ( 15,15,15,15,15,15,00,00,00,00,15,15,15,15,15,15 ),
                ( 15,15,15,15,15,00,00,00,00,00,00,15,15,15,15,15 ),
                ( 00,00,00,15,00,00,00,00,00,00,00,00,15,00,00,00 ),
                ( 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ),
                ( 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ),
                ( 00,00,00,15,00,00,00,00,00,00,00,00,15,00,00,00 ),
                ( 15,15,15,15,15,00,00,00,00,00,00,15,15,15,15,15 ),
                ( 15,15,15,15,15,15,00,00,00,00,15,15,15,15,15,15 ),
                ( 15,15,15,15,15,00,00,00,00,00,00,15,15,15,15,15 ),
                ( 15,15,15,15,15,00,00,00,00,00,00,15,15,15,15,15 ),
                ( 15,15,15,15,15,00,00,00,00,00,00,15,15,15,15,15 )
             );

  Vert     = 0;
  Horz     = 1;

TYPE
  MouseREC = RECORD
               x, y       : INTEGER;
               bmask      : INTEGER;
               Moved      : BOOLEAN;
               Visible    : BOOLEAN;

               Hotx, Hoty : BYTE;
               minx, maxx : INTEGER;
               miny, maxy : INTEGER;
               Width,
               Height     : BYTE;
               MouseIPtr,
               MouseMPtr,
               MouseBPtr  : POINTER;
             END;

VAR
  MouseData  : MouseREC;

  MouseExist : BOOLEAN;

  PROCEDURE InitMouseDriver;
  PROCEDURE KillMouseDriver;

  PROCEDURE ShowMouse;
  PROCEDURE HideMouse;

  PROCEDURE SetMinMax( Dir : BYTE; Min, Max : INTEGER );
  PROCEDURE SetMousePos( newx, newy : INTEGER );

{ ----------------------------------------------------------------- }
                           IMPLEMENTATION
{ ----------------------------------------------------------------- }

USES Dos, Graph, Drivers;

VAR
  ByteNum  : BYTE;
  COMBytes : ARRAY[ 0..2 ] OF BYTE;
  OldMouse : PROCEDURE;

  PROCEDURE NewMouse; Interrupt;
  VAR
    dx, dy : SHORTINT;
    inByte : BYTE;
    b1, b2 : BOOLEAN;

  BEGIN
    ASM CLI; END;

    MouseData.Moved := TRUE;

    IF MouseData.Visible
      THEN PutImage( MouseData.x, MouseData.y, MouseData.MouseBPtr^, NormalPut );

    inByte := Port[COMport];
    IF ( inByte AND 64 ) = 64 THEN ByteNum := 0;
    COMBytes[ByteNum] := inByte;
    ByteNum := ByteNum + 1;

    IF ( ByteNum = 3 )
      THEN BEGIN
             dx := ( COMBytes[0] AND 3 ) shl 6 + COMBytes[1];
             dy := ( COMBytes[0] AND 12 ) shl 4 + COMBytes[2];

             WITH MouseData DO
               BEGIN
                 x := x + dx;
                 y := y + dy;

                 IF y < Miny THEN y := Miny;
                 IF y > ( Maxy - Height ) THEN y := ( Maxy - Width );
                 IF x < Minx THEN x := MinX;
                 IF x > ( Maxx - Width ) THEN x := ( Maxx - Width );

                 b1 := (( COMBytes[0] AND 32 ) <> 0);
                 b2 := (( COMBytes[0] AND 16 ) <> 0);

                 bmask := (( ord(b1) * 2 ) + ord( b2 ));
               END;
             ByteNum := 0;
           END;

    IF MouseData.Visible
      THEN BEGIN
             GetImage( MouseData.x, MouseData.y,
                       MouseData.x + ( MouseData.Width - 1 ), MouseData.y + ( MouseData.Height - 1 ),
                       MouseData.MouseBPtr^ );
             PutImage( MouseData.x, MouseData.y, MouseData.MouseMPtr^, ANDPut );
             PutImage( MouseData.x, MouseData.y, MouseData.MouseIPtr^, XORPut );
           END;

    Port[$20] := $20;

    ASM STI; END;
  END;

  PROCEDURE InitMouseDriver;
  VAR
    i, j : BYTE;

  BEGIN
    FOR i := 0 TO ( ROMMSize - 1 ) DO
      FOR j := 0 TO ( ROMMSize - 1 ) DO
         PutPixel( i, j, ROMMouseI[ j, i ] );

    GetMem( MouseData.MouseIPtr, ImageSize( 0, 0, ( ROMMSize - 1 ), ( ROMMSize - 1 )));
    GetImage( 0, 0, ( ROMMSize - 1 ), ( ROMMSize - 1 ), MouseData.MouseIPtr^ );

    FOR i := 0 TO ( ROMMSize - 1 ) DO
      FOR j := 0 TO ( ROMMSize - 1 ) DO
        IF ROMMouseM[ j, i ] <> 0
          THEN PutPixel( i, j, 255 )
          ELSE PutPixel( i, j, 0 );

    GetMem( MouseData.MouseMPtr, ImageSize( 0, 0, ( ROMMSize - 1 ), ( ROMMSize - 1 ) ));
    GetImage( 0, 0, ( ROMMSize - 1 ), ( ROMMSize - 1 ), MouseData.MouseMPtr^ );

    GetMem( MouseData.MouseBPtr, ImageSize( 0, 0, ( ROMMSize - 1 ), ( ROMMSize - 1 ) ));
    ClearViewPort;

    WITH MouseData DO
      BEGIN
        x := GetMaxX shr 1;
        y := GetMaxY shr 1;

        minx := 0;
        maxx := GetMaxX;
        miny := 0;
        maxy := GetMaxY;

        Hotx := 8;
        Hoty := 8;

        Width := ROMMSize;
        Height := ROMMSize;

        Visible := FALSE;
        Moved := FALSE;
      END;

    GetIntVec( COMintr, @OldMouse );
    SetIntVec( COMintr, Addr( NewMouse ));
  END;

  PROCEDURE KillMouseDriver;
  BEGIN
    SetIntVec( COMintr, @OldMouse );
  END;

  PROCEDURE ShowMouse;
  BEGIN
    IF NOT MouseData.Visible
      THEN BEGIN
             GetImage( MouseData.x, MouseData.y,
                       MouseData.x + ( MouseData.Width - 1 ), MouseData.y + ( MouseData.Height - 1 ),
                       MouseData.MouseBPtr^ );
             PutImage( MouseData.x, MouseData.y, MouseData.MouseMPtr^, ANDPut );
             PutImage( MouseData.x, MouseData.y, MouseData.MouseIPtr^, XORPut );
           END;

    MouseData.Visible := TRUE;
  END;

  PROCEDURE HideMouse;
  BEGIN
    IF MouseData.Visible
      THEN PutImage( MouseData.x, MouseData.y, MouseData.MouseBPtr^, NormalPut );

    MouseData.Visible := FALSE;
  END;

  PROCEDURE SetMinMax( Dir : BYTE; Min, Max : INTEGER );
  BEGIN
    WITH MouseData DO
      BEGIN
        CASE Dir OF
          Vert : BEGIN
                   Miny := Min;
                   Maxy := Max;
                 END;
          Horz : BEGIN
                   Minx := Min;
                   Maxx := Max;
                 END;
        END;
      END;
  END;

  PROCEDURE SetMousePos( newx, newy : INTEGER );
  BEGIN
    WITH MouseData DO
      BEGIN
        x := newx;
        y := newy;
      END;
  END;

VAR
  Regs : Registers;

BEGIN
  FillChar( Regs, sizeof( Regs ), 0 );
  WITH Regs DO
    AX := 0;
  Intr( $33, Regs );

  MouseExist := ( ButtonCount <> 0 );  { use Drivers auto detect }
END.
