/******************************************************************************
*                                 project3.h                                  *
*      this unit has 2 instances : the first one is used with the windows      *
*               graphic user interface, and the other does not,                *
*                                                                              *
*             +-------------------------------------------------+              *
*             |  this unit is NOT interfaced to the window GUI, |              *
*             |   for use on a bare screen ONLY - for runTime!  |              *
*             |                ****                             |              *
*             +-------------------------------------------------+              *
*                                                                              *
*this unit handles the 3d -> 2d projections, we use 2 different methods        *
*       of projections :                                                       *
*                                                                              *
*               A : axonometric projections, no perspective due to             *
*                       distance is performed, the general way                 *
*                       we can look at the coordinate system is as             *
*                       follows :                                              *
*                                                                              *
*                               |  z axis                                      *
*                               |                                              *
*                              / \                                             *
*                    x axis   /   \  y axis                                    *
*                                                                              *
*               B : perspective projections : the normal eye perspective       *
*                       projection is performed, we can look at the 3d         *
*                       universe we are refering to as a cube of               *
*                       1000 x 1000 x 1000 integer locations, with             *
*                       the x axis, and y axis parallel to the screen          *
*                       x, y axis respectivly, and the z axis going into       *
*                       the screen.                                            *
*                                                                              *
*                       we will look at the coordinate system as follows :     *
*                                                                              *
*                        Y axis                                               *
*                                                                             *
*                Z axis x------ X axis                                         *
*                                                                              *
******************************************************************************/

#ifndef _project3_h
#define _project3_h

#if !defined(_hdr3d_h)
#include "hdr3d.h"
#endif

#ifndef _windows
#include <graphics.h>

extern int GraphDriver;
extern int GraphMode;
extern unsigned int maxX, maxY;
extern unsigned int maxColor;

#endif
extern int perspective; // true = perspective, else = axonometric

extern "C" void calcPoint(point3d p3d, screenPoints& psc);
extern "C" void setPerspective();
extern "C" void resetPerspective();
extern "C" void togglePerspective();

#ifndef _windows
extern "C" void startGraph(); // initialize the graphic engine
extern "C" void endGraph(); // end the graphic engine
#endif

#endif
