
; *****************************************
;
;               Prime Numbers
;
;   (c) 1995 by Topical Software
;
;   32 Bit assembler unit
;
;   To show the code is 32 bit, the
;   segment name is "Code32" to end with
;   "32". This will be recognized by the
;   Protected Mode loader. 
;
; *****************************************


; memory model "Large"
__large__	equ	1

; rules.asi declares the C-specific things
; swallow.inc inports Swallow's Assembler-API
		include rules.asi
		include	swallow.inc

		.386

; Macro: it has to be called at the begin of the procedure
;        to corrent return address from 16 to 32 bit
Entry32Proc	macro
		if      @wordsize eq 4
		pop	eax
		movzx	ebx,ax
		shr	eax,16
		push	eax
		push	ebx
		endif
		endm


; Macro: call 16 bit procedure from 32 bit code
;        return address is stored as 16 bit
Call16Proc	macro   Name
		local	@1
		if      @wordsize eq 4
		mov	eax,cs                  ; return address 16 bit
		push	ax
		push	small offset @1
		db      68h                     ; push dword
		dw	small seg &Name         ; target address
		dw      0
		db      68h                     ; push dword
		dw      small offset &Name
		dw      0
		retf                            ; jump to procedure
@1		equ	this byte               ; return address
		else
		call    Name                    ; simple call
						; in 16 bit segs
		endif
		endm


; constants for abort
ERR_USERABORT	equ	-1
ERR_OUTOFMEM	equ	-2

; main program variables (see there)
		extrn _Seg0040:word
		extrn _CheckBreak:proc
		extrn _PublicSqrt:proc

; the exported function
		public   _CountPrimes4


; the segment gets the name "Code32" to show
; the Protected Mode Loader, that it contains
; 32 bit code only. The ending "32" is the
; sign of 32 bit code.

; If you want to use 16 bit code (e.g. for debugging)
; you have to rename the segment to something like
; "Code" or "Code16" for correct loading in PM.

; With TP you have to declare an own Unit
; ending with "32", which contains _only_ this
; 32 bit code, because TP sets the name of the
; unit as the segment name and you have to set
; "Code" as the assembler segment name
Code32		Segment para use32 'CODE'
		assume	cs:Code32


;
;  Count prime number within the first "HighestNumber" numbers
;
;  -> ERR_OUTOFMEM = Out of memory
;     ERR_USERABORT = Use abort
;     >=0 count of prime numbers
;  assembler version of CountPrimes3
;  nothing extra is changed compared to the Pascal/C-Version
;
_CountPrimes4	proc	DIST MaxNumber:dword, BlockLen:dword
		local	Count:dword, BlockBegin:dword, BlockEnd:dword, \
			ScanEnd:dword, BlockEnd2:dword, ScanEnd2:dword, \
			BlBeginOffset:dword, \
			OldTime:word = LocalsLen

		Entry32Proc		; adapt return address
		push	bp		; create stack frame
		mov	bp,sp		; never use automatic stack frame!!!
		sub	sp,LocalsLen

		add	BlockLen,3
		and	BlockLen,not 3	; because bt accesses dwords
		shl	BlockLen,4
		mov	ebx,BlockLen
		shr	ebx,4
		add	ebx,3    	; because bt accesses dwords
		and	ebx,not 3
		mov	cl,82h          ; data/cleared
		mov	ax,knf_AllocWatchedMem or knf_NoCheck
		int	32h
		jc	@@Error1
		mov	es,ax		; TmpBlock
		mov	ebx,MaxNumber
		inc	ebx
		add	ebx,15
		shr	ebx,4
		add	ebx,3   	; because bt accesses dwords
		and	ebx,not 3
		mov	cl,82h          ; data/cleared
		mov	ax,knf_AllocWatchedMem or knf_NoCheck
		int	32h
		jc	@@Error2
		mov	fs,ax		; MainTable
		mov	Count,1
		mov	ax,seg _Seg0040
		mov	gs,ax
		mov	gs,gs:_Seg0040
		mov	ax,gs:[6ch]
		mov	OldTime,ax
		mov	BlockBegin,1
		mov	BlBeginOffset,0
		mov	eax,BlockLen
		dec	eax
		mov	BlockEnd,eax
@@NextBlock:	cmp	BlockBegin,3
		jg	@@1
		mov	BlockBegin,3
@@1:
@@NextBlock1:	mov	ebx,MaxNumber
		mov	eax,BlockEnd
		cmp	eax,ebx
		jl	@@2
		mov	eax,ebx
@@2:		mov	BlockEnd,eax
		mov	ecx,eax
		dec	ecx
		sar	ecx,1
		mov	BlockEnd2,ecx
		mov	ScanEnd,eax
		push	es
		push	fs
		pushad
		push	small ss
		lea	eax,ScanEnd
		push	ax
		Call16Proc _PublicSqrt 	; never use "call xxx" !!!
		add	sp, 4
		popad
		pop	fs
		pop	es
		mov	eax,ScanEnd
		cmp	eax,BlockBegin
		jl	@@3
		mov	eax,BlockBegin
		sub	eax,2
@@3:            mov	ScanEnd,eax
		sar	eax,1
		mov	ScanEnd2,eax

		mov	ebx,BlockEnd
		shr	ebx,4
		mov	edi,BlockBegin
		shr	edi,4
		sub	ebx,edi
		inc	ebx
		xor	edi,edi
		xor	eax,eax
		cld

		mov	ecx,ebx
		shr	ecx,2
		rep	stos dword ptr es:[edi]
		mov	cl,bl
		and	cl,3
		rep	stos byte ptr es:[edi]

		xor	edi,edi
		mov	bx,OldTime
@@ScanPrevious: mov	eax,3 shr 1
		mov	ecx,ScanEnd2
		cmp	eax,ecx
		jg	@@ScanEnd
@@Scanning:	bt	fs:[edi],eax
		jc	@@ScanFound
@@Scanning1:	inc	eax
		cmp	eax,ecx
		jle	@@Scanning
		jmp	@@ScanEnd

@@CheckBreak1:	mov	bx,gs:[6ch]
		mov	OldTime,bx
		pushad
		push	es
		push	fs
		push	gs
		lea	eax,[eax+eax+1]
		push	eax
		push	Count
		push	BlockBegin
		push	small 1
		call16Proc _CheckBreak   ; never use "call xxx" !!!
		add	esp,2+3*4
		or	ax,ax
		pop	gs
		pop	fs
		pop	es
		popad
		jne	@@Abort
		jmp	@@Continue1

@@ScanFound:	cmp	bx,gs:[6ch]
		jne	@@CheckBreak1
@@Continue1:	push	eax
		push	ecx
		lea	eax,[eax+eax+1]
		mov	ecx,eax
		add	eax,BlockBegin
		dec	eax
		mov	esi,eax
		cdq
		div	ecx
		sub	esi,edx
		test	al,1
		jnz	@@Odd
		add	esi,ecx
@@Odd:		lea	edx,[ecx+ecx]
		mov	eax,BlockEnd
		cmp	esi,eax
		ja	@@NoSign
		mov	edi,BlBeginOffset
		neg	edi
@@SignPrevious:	mov	ecx,esi
		shr	ecx,1
		bts	es:[edi],ecx
		add	esi,edx
		cmp	esi,eax
		jbe	@@SignPrevious
		xor	edi,edi
@@NoSign:	pop	ecx
		pop	eax
		jmp	@@Scanning1

@@ScanEnd:	mov	eax,BlockBegin
		shr	eax,1
		mov	ecx,BlockEnd2
		mov	edi,BlBeginOffset
		neg	edi
		cmp	eax,ecx
		jg	@@BlockEnd

@@Searching:	bt	es:[edi],eax
		jnc	@@Prime
@@Searching1:	inc	eax
		cmp	eax,ecx
		jle	@@Searching
		jmp	@@BlockEnd

@@CheckBreak2:	mov	bx,gs:[6ch]
		mov	OldTime,bx
		pushad
		push	es
		push	fs
		push	gs
		lea	eax,[eax+eax+1]
		push	large 0
		push	Count
		push	eax
		push	small 0
		call16Proc _CheckBreak   ; never use "call xxx" !!!
		add	esp,2+3*4
		or	ax,ax
		pop	gs
		pop	fs
		pop	es
		popad
		jne	@@Abort
		jmp	@@Continue2

@@Prime:        inc	Count
		cmp	bx,gs:[6ch]
		jne	@@CheckBreak2
@@Continue2:	push	eax
		push	ecx
		xor	esi,esi
		bts	fs:[esi],eax
		lea	esi,[eax+eax+1]
		lea	edx,[esi+esi]
		mov	eax,BlockEnd
@@MarkNonPrimes:mov	ecx,esi
		shr	ecx,1
		bts	es:[edi],ecx
		add	esi,edx
		cmp	esi,eax
		jbe	@@MarkNonPrimes
		pop	ecx
		pop	eax
		jmp	@@Searching1

@@BlockEnd:	mov	ebx,BlockBegin
		cmp	ebx,3
		jne	@@5
		mov	ebx,1
@@5:		mov	eax,BlockLen
		add	ebx,eax
		add	BlockEnd,eax
		shr	eax,4
		add	BlBeginOffset,eax
		cmp	ebx,MaxNumber
		mov	BlockBegin,ebx
		jbe	@@NextBlock1

		mov	bx,es
		mov	ax,knf_freewatchedmem
		int	32h
		mov	bx,fs
		mov	ax,knf_freewatchedmem
		int	32h
		mov	eax,Count
@@Exit:		shld	edx,eax,16
		mov	sp,bp
		pop	bp

		ret

@@Abort:	mov	eax,ERR_USERABORT
		jmp	@@Exit

@@Error2:	mov	bx,es
		mov	ax,knf_freewatchedmem
		int	32h
@@Error1:	mov	eax,ERR_OUTOFMEM
		jmp	@@Exit
_CountPrimes4	endp


Code32		ends


;Code_EndS@

		end


