;
; This code is needed because DOS insists on opening a char device
; in cooked mode.  The problem is that without adding code to every
; application that would ever use us, we have no way to alter this
; because the use of O_BINARY or setmode() do not affect char devices.
;
; The solution (kludge) is to watch open requests issued thru the
; INT 21 vector.  If we see a open request followed by a OPEN_DEV
; call to us, it must have been an open for us.  So during the return,
; force a call to the ioctl facility that will switch to raw mode.
;

;
; The Original INT 21 Vector
;
vect_int_21	equ	word ptr 4 * 21h
orig_int_21	dd	?			;Original INT 21 Vector

;
; OPEN_DEV flag is TRUE when we are opened
;
opened_flag	db	FALSE

patch_us_in	proc	near
		push	es
		push	ax
		mov	ax,0			;Patch Ourselves into
		mov	es,ax			;the INT 21 Vector
		mov	ax,es:[vect_int_21]	;Offset
		mov	word ptr orig_int_21,ax
		lea	ax,our_int_21
		mov	es:[vect_int_21],ax
		mov	ax,es:[vect_int_21+2]	;Segment
		mov	word ptr orig_int_21+2,ax
		mov	ax,cs
		mov	es:[vect_int_21+2],ax
		pop	ax
		pop	es
		ret
patch_us_in	endp

our_int_21	proc	far
		pushf				;Save entry flags
		cmp	ah,3Dh			;Is it an open request?
		jnz	not_open_req
		popf				;Restore entry flags
;
; We need to set things up so the 'iret' done by the INT 21
; code will have some the right stuff on the stack.
; #1 Flags with interrupts enabled
; #2 Return Address
;
		sti				;Allow interrupts
		pushf				;After the iret
		cli				;Shut interrupts off
		call	cs:orig_int_21		;While we Pass the request on
;
; Upon return, interrupts are enabled, so shut them off while we work
;
		pushf
		cli
		cmp	cs:opened_flag,FALSE	;Was it an open for us?
		jz	not_our_open
		mov	cs:opened_flag,FALSE	;Clear for next time
;
; We need to forge a call to the ioctl interface
; to switch DOS to raw mode when it talks to us
;
		pusha
		mov	bx,ax			;Save the Handle
		mov	ax,4400h		;Get Device Information
		pushf
		call	cs:orig_int_21
		mov	dh,0			;Setup
		or	dl,20h			;for RAW Mode
		mov	ax,4401h		;Set Device Information
		pushf
		call	cs:orig_int_21
		popa

not_our_open:	popf				;The Original Flags to return
;
; When we return, we need to pop the flags that the original INT 21
; call left on the stack, and return the flags we got back
;
		ret	2			;Return and discard flags

not_open_req:	popf				;Pop the saved flags
		jmp	cs:orig_int_21		;Continue with original code
our_int_21	endp
